/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.template;

import de.zwanzigeins.codecs.TextCodec;
import de.zwanzigeins.template.TestClass;
import de.zwanzigeins.util.ByteString;
import de.zwanzigeins.util.HelperDT;
import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperFormat;
import de.zwanzigeins.util.HelperIO;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TemplateParser {
    private Hashtable hshVars = new Hashtable();
    private TextCodec tcString = null;
    private boolean blnTextCodecEnabled = true;
    private ByteString bytstrCurrLoopContent = new ByteString();
    private String strCurrLoopVar = null;
    private Object objCurrLoopObject = null;

    public void clearVar(String string) {
        this.hshVars.remove(string.toLowerCase());
    }

    public void clearVars() {
        this.hshVars.clear();
    }

    private boolean evaluateToken(String string, OutputStream outputStream) throws IOException {
        String string2 = string.toLowerCase();
        if (string2.startsWith("loop ")) {
            this.strCurrLoopVar = HelperExtract.getRight(string, " ").trim();
            return true;
        }
        if (string2.equals("endloop")) {
            this.loop(this.strCurrLoopVar, this.bytstrCurrLoopContent.toByteArray(), outputStream);
            return true;
        }
        if (this.strCurrLoopVar != null) {
            return false;
        }
        String string3 = string;
        int n = 2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            try {
                n = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        string = string3;
        String string4 = this.strCurrLoopVar;
        Object object = this.objCurrLoopObject;
        int n2 = string.indexOf(".");
        if (n2 == -1) {
            if (object == null) {
                string4 = string;
                object = this.hshVars.get(string.toLowerCase());
            }
            this.object2string(object, n, outputStream);
            return true;
        }
        if (object == null) {
            string4 = string;
            object = this.hshVars.get(string.substring(0, n2).toLowerCase());
        }
        if ((string = string.substring(n2 + 1)).endsWith("()")) {
            string = string.substring(0, string.length() - 2);
            try {
                Method method = object.getClass().getMethod(string, new Class[0]);
                object = method.invoke(object, new Object[0]);
            }
            catch (Throwable throwable) {
                object = "Method " + string4 + " not found (" + throwable.toString() + ")";
            }
            this.object2string(object, n, outputStream);
            return true;
        }
        try {
            Field field = object.getClass().getField(string);
            object = field.get(object);
        }
        catch (Throwable throwable) {
            object = "Variable " + string4 + " not found (" + throwable.toString() + ")";
        }
        this.object2string(object, n, outputStream);
        return true;
    }

    private void loop(String string, byte[] byArray, OutputStream outputStream) throws IOException {
        Object v = this.hshVars.get(string);
        if (v instanceof Vector) {
            Vector vector = (Vector)v;
            int n = 0;
            while (n < vector.size()) {
                this.objCurrLoopObject = vector.elementAt(n);
                this.process(new ByteArrayInputStream(byArray), outputStream);
                ++n;
            }
        } else {
            Object[] objectArray = (Object[])this.hshVars.get(string);
            if (objectArray == null) {
                throw new IllegalArgumentException("Template demands loop variable '" + string + "' but is not found in the variable stack");
            }
            int n = 0;
            while (n < objectArray.length) {
                this.objCurrLoopObject = objectArray[n];
                this.process(new ByteArrayInputStream(byArray), outputStream);
                ++n;
            }
        }
        this.objCurrLoopObject = null;
    }

    public static void main(String[] stringArray) throws Throwable {
        TemplateParser templateParser = new TemplateParser();
        FileInputStream fileInputStream = new FileInputStream("c:\\template.tpl");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        templateParser.setVar("loop", new TestClass[]{new TestClass(), new TestClass()});
        templateParser.setVar("test", "out_test");
        templateParser.setVar("alla", "out_alla");
        templateParser.setVar("class", new TestClass());
        templateParser.process(fileInputStream, (OutputStream)byteArrayOutputStream);
        System.out.println(byteArrayOutputStream.toString());
    }

    private void object2string(Object object, int n, OutputStream outputStream) throws IOException {
        if (object == null) {
            object = "<null>";
        }
        String string = null;
        if (object instanceof Double) {
            string = HelperFormat.number_rset((Double)object, 0, n);
        }
        if (object instanceof Float) {
            string = HelperFormat.number_rset(((Float)object).floatValue(), 0, n);
        }
        if (object instanceof Date) {
            string = HelperDT.getDDMMYYYY((java.util.Date)object);
        }
        if (object instanceof java.util.Date) {
            string = HelperDT.getDDMMYYYY((java.util.Date)object);
        }
        if (object instanceof Time) {
            string = HelperDT.getHHMMSS((java.util.Date)object);
        }
        if (string == null) {
            string = object.toString();
        }
        outputStream.write(string.getBytes());
    }

    public synchronized void process(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            try {
                this.process0(inputStream, outputStream);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable.toString());
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            HelperIO.close(inputStream);
            throw throwable;
        }
        Object var3_7 = null;
        HelperIO.close(inputStream);
    }

    public synchronized String process(String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.process0(byteArrayInputStream, byteArrayOutputStream);
        }
        catch (IOException iOException) {}
        return byteArrayOutputStream.toString();
    }

    public synchronized void process(String string, OutputStream outputStream) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this.process0(byteArrayInputStream, outputStream);
    }

    private void process0(InputStream inputStream, OutputStream outputStream) throws IOException {
        this.bytstrCurrLoopContent.setLength(0);
        this.strCurrLoopVar = null;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        byte by = 0;
        byte by2 = (byte)inputStream.read();
        while ((by = by2) != -1) {
            by2 = (byte)inputStream.read();
            if (by2 == -1) {
                outputStream.write(by);
                break;
            }
            if (by == 91 && by2 == 37) {
                bl = true;
                stringBuffer.setLength(0);
                continue;
            }
            if (by == 37 && by2 == 93) {
                bl = false;
                String string = stringBuffer.toString();
                if (string.length() == 0) continue;
                string = string.substring(1);
                if (!this.evaluateToken(string = string.trim(), outputStream) && this.strCurrLoopVar != null) {
                    this.bytstrCurrLoopContent.append("[%" + string + "%]");
                }
                by2 = (byte)inputStream.read();
                continue;
            }
            if (bl) {
                stringBuffer.append((char)by);
                continue;
            }
            if (this.strCurrLoopVar != null) {
                this.bytstrCurrLoopContent.append((char)by);
                continue;
            }
            outputStream.write(by);
        }
    }

    public void setTextCodec(TextCodec textCodec) {
        this.tcString = textCodec;
    }

    public void setTextEnabled(boolean bl) {
        this.blnTextCodecEnabled = bl;
    }

    public void setVar(String string, double d) {
        this.hshVars.put(string.toLowerCase(), new Double(d));
    }

    public void setVar(String string, float f) {
        this.hshVars.put(string.toLowerCase(), new Float(f));
    }

    public void setVar(String string, int n) {
        this.hshVars.put(string.toLowerCase(), new Integer(n));
    }

    public void setVar(String string, long l) {
        this.hshVars.put(string.toLowerCase(), new Long(l));
    }

    public void setVar(String string, Object object) {
        this.hshVars.put(string.toLowerCase(), object);
    }

    public void setVar(String string, String string2) {
        if (this.tcString != null && this.blnTextCodecEnabled) {
            string2 = this.tcString.encode(string2);
        }
        this.hshVars.put(string.toLowerCase(), string2);
    }
}

