/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.sql;

import de.zwanzigeins.sql.SQLconnection;
import de.zwanzigeins.util.HelperDT;
import de.zwanzigeins.util.HelperFilter;
import de.zwanzigeins.util.HelperIO;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.Hashtable;

public class HtmlSQLQueryModule {
    private Connection con = null;
    private String strQuery = null;
    int intQueryParams = 0;
    private Object[] objQueryParams = null;
    private Statement stmt = null;
    private ResultSet res = null;
    private int intRowCount = 0;
    private String[] strLastRow = null;
    private Hashtable hshLinkTable = null;

    public HtmlSQLQueryModule(Connection connection) {
        this.con = connection;
        this.reset();
    }

    public void addQueryLine(String string) {
        string = string.trim();
        this.strQuery = this.strQuery == null ? string : String.valueOf(this.strQuery) + " " + string;
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '?') {
                ++this.intQueryParams;
            }
            ++n;
        }
    }

    public String execQuery() {
        int n;
        try {
            this.stmt = this.con.createStatement();
            this.res = this.stmt.executeQuery(this.prepareQuery(this.strQuery));
        }
        catch (SQLException sQLException) {
            this.reset();
            throw new RuntimeException("execQuery(exec): " + sQLException.toString());
        }
        String[] stringArray = null;
        boolean[] blArray = null;
        int[] nArray = null;
        ResultSetMetaData resultSetMetaData = null;
        try {
            resultSetMetaData = this.res.getMetaData();
            this.strLastRow = new String[resultSetMetaData.getColumnCount()];
            stringArray = new String[resultSetMetaData.getColumnCount()];
            blArray = new boolean[resultSetMetaData.getColumnCount()];
            nArray = new int[resultSetMetaData.getColumnCount()];
            resultSetMetaData = this.res.getMetaData();
            int n2 = 0;
            while (n2 < resultSetMetaData.getColumnCount()) {
                stringArray[n2] = resultSetMetaData.getColumnLabel(n2 + 1);
                if (stringArray[n2] == null || stringArray[n2].length() == 0) {
                    stringArray[n2] = resultSetMetaData.getColumnName(n2 + 1);
                }
                nArray[n2] = resultSetMetaData.getColumnType(n2 + 1);
                switch (nArray[n2]) {
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 8: {
                        blArray[n2] = true;
                    }
                }
                ++n2;
            }
        }
        catch (SQLException sQLException) {
            this.reset();
            throw new RuntimeException("execQuery(metadata): " + sQLException.toString());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table border=\"1\" cellpadding=\"4\" cellspacing=\"0\" width=\"100%\">\n");
        try {
            stringBuffer.append("<tr>");
            n = 0;
            while (n < resultSetMetaData.getColumnCount()) {
                stringBuffer.append("<td nowrap=\"nowrap\" valign=\"middle\" ");
                if (blArray[n]) {
                    stringBuffer.append("align=\"right\"");
                } else {
                    stringBuffer.append("align=\"left\"");
                }
                stringBuffer.append(">");
                stringBuffer.append("<b>" + stringArray[n] + "</b>");
                stringBuffer.append("</td>");
                ++n;
            }
            stringBuffer.append(" </tr>\n");
        }
        catch (SQLException sQLException) {
            this.reset();
            throw new RuntimeException("execQuery(header): " + sQLException.toString());
        }
        try {
            while (this.res.next()) {
                ++this.intRowCount;
                stringBuffer.append("<tr>");
                n = 0;
                while (n < resultSetMetaData.getColumnCount()) {
                    stringBuffer.append("<td nowrap=\"nowrap\" valign=\"middle\" ");
                    if (blArray[n]) {
                        stringBuffer.append("align=\"right\"");
                    } else {
                        stringBuffer.append("align=\"left\"");
                    }
                    stringBuffer.append(">");
                    String string = null;
                    switch (nArray[n]) {
                        case 91: {
                            string = HelperDT.getDDMMYYYY(this.res.getDate(n + 1));
                            break;
                        }
                        case 92: {
                            string = HelperDT.getHHMMSS(this.res.getTime(n + 1));
                            break;
                        }
                        default: {
                            string = this.res.getString(n + 1);
                        }
                    }
                    this.strLastRow[n] = string;
                    String string2 = (String)this.hshLinkTable.get(new Integer(n));
                    if (string2 != null) {
                        string2 = HelperFilter.replaceMore(string2, "?", string);
                        stringBuffer.append("<a href=\"?" + string2 + "\">");
                    }
                    stringBuffer.append(string);
                    if (string2 != null) {
                        stringBuffer.append("</a>");
                    }
                    stringBuffer.append("</td>");
                    ++n;
                }
                stringBuffer.append("</tr>\n");
            }
        }
        catch (SQLException sQLException) {
            this.reset();
            throw new RuntimeException("execQuery(result): " + sQLException.toString());
        }
        stringBuffer.append("</table>\n");
        return stringBuffer.toString();
    }

    public String[] getLastRow() {
        return this.strLastRow;
    }

    public int getRowCount() {
        return this.intRowCount;
    }

    public static void main(String[] stringArray) throws SQLException {
        SQLconnection.setDB_User("benutzer");
        SQLconnection.setDB_Pass("kennwort");
        SQLconnection.setDB_Database("webshop");
        Connection connection = null;
        try {
            connection = SQLconnection.getConnection();
        }
        catch (SQLException sQLException) {
            System.out.println(sQLException);
            HelperIO.close(connection);
            return;
        }
        HtmlSQLQueryModule htmlSQLQueryModule = new HtmlSQLQueryModule(connection);
        htmlSQLQueryModule.addQueryLine("select pk_customer as Kunde,inv_name_1 as Name,dec(sum(total_brutto),9,2) as Brutto");
        htmlSQLQueryModule.addQueryLine(" from customer_orders_hd");
        htmlSQLQueryModule.addQueryLine(" group by pk_customer,inv_name_1");
        htmlSQLQueryModule.addQueryLine(" order by Brutto desc");
        String string = htmlSQLQueryModule.execQuery();
        System.out.println(string);
        HelperIO.close(connection);
    }

    private String prepareQuery(String string) {
        if (this.intQueryParams != 0 && this.objQueryParams == null) {
            throw new RuntimeException("prepareQuery: no query parameter was set");
        }
        if (this.intQueryParams != this.objQueryParams.length) {
            throw new RuntimeException("prepareQuery: queryparameter set and requested differ");
        }
        boolean bl = true;
        int n = 0;
        while (n < this.intQueryParams) {
            if (this.objQueryParams[n] == null) {
                bl = false;
            }
            ++n;
        }
        if (!bl) {
            throw new RuntimeException("prepareQuery: query parameters not set");
        }
        n = 0;
        int n2 = -1;
        while (n < this.intQueryParams && (n2 = string.indexOf("?")) != -1) {
            string = String.valueOf(string.substring(0, n2)) + this.objQueryParams[n++].toString() + string.substring(n2 + 1);
        }
        return string;
    }

    public void reset() {
        this.strQuery = null;
        this.intQueryParams = 0;
        this.objQueryParams = null;
        this.intRowCount = 0;
        this.strLastRow = null;
        this.hshLinkTable = new Hashtable();
        if (this.res != null) {
            HelperIO.close(this.res);
            this.res = null;
        }
        if (this.stmt != null) {
            HelperIO.close(this.stmt);
            this.stmt = null;
        }
    }

    private void sanity_check(int n) {
        if (this.objQueryParams == null) {
            this.objQueryParams = new Object[this.intQueryParams];
        }
        if (n < 1 || n > this.intQueryParams) {
            throw new RuntimeException("setQueryParam: " + n + " is out of range");
        }
    }

    public void setLinkColumn(int n, String string) {
        this.hshLinkTable.put(new Integer(n - 1), string);
    }

    public void setQueryParam(int n, double d) {
        this.sanity_check(n);
        this.objQueryParams[n - 1] = new Double(d);
    }

    public void setQueryParam(int n, float f) {
        this.sanity_check(n);
        this.objQueryParams[n - 1] = new Float(f);
    }

    public void setQueryParam(int n, int n2) {
        this.sanity_check(n);
        this.objQueryParams[n - 1] = new Integer(n2);
    }

    public void setQueryParam(int n, long l) {
        this.sanity_check(n);
        this.objQueryParams[n - 1] = new Long(l);
    }

    public void setQueryParam(int n, String string) {
        this.sanity_check(n);
        this.objQueryParams[n - 1] = string;
    }

    public void setQueryParam(int n, Date date) {
        this.sanity_check(n);
        this.objQueryParams[n - 1] = date;
    }

    public void setQueryParam(int n, Time time) {
        this.sanity_check(n);
        this.objQueryParams[n - 1] = time;
    }
}

