/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.sort;

import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.ComparatorString;
import de.zwanzigeins.util.HelperFormat;
import java.util.Vector;

public class HelperSort {
    private HelperSort() {
    }

    public static final void bubble(Vector vector, Comparator comparator) {
        boolean bl = false;
        do {
            bl = false;
            int n = 0;
            while (n < vector.size() - 1) {
                if (comparator.compare(vector.elementAt(n), vector.elementAt(n + 1)) > 0) {
                    HelperSort.swap(vector, n, n + 1);
                    bl = true;
                }
                ++n;
            }
        } while (bl);
    }

    public static final void bubble(Object[] objectArray, Comparator comparator) {
        boolean bl = false;
        do {
            bl = false;
            int n = 0;
            while (n < objectArray.length - 1) {
                if (comparator.compare(objectArray[n], objectArray[n + 1]) < 0) {
                    HelperSort.swap(objectArray, n, n + 1);
                    bl = true;
                }
                ++n;
            }
        } while (bl);
    }

    public static final boolean isSorted(Vector vector, Comparator comparator) {
        int n = 1;
        while (n < vector.size()) {
            if (comparator.compare(vector.elementAt(n), vector.elementAt(n - 1)) < 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static final boolean isSorted(Object[] objectArray, Comparator comparator) {
        int n = 1;
        while (n < objectArray.length) {
            if (comparator.compare(objectArray[n], objectArray[n - 1]) < 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        Object object;
        Vector<String> vector = new Vector<String>(5000);
        int n = 0;
        while (n < 1000) {
            object = String.valueOf((int)(Math.random() * 50000.0));
            vector.addElement(HelperFormat.rset((String)object, 5, ' '));
            ++n;
        }
        ComparatorString comparatorString = new ComparatorString();
        object = (Vector)vector.clone();
        long l = System.currentTimeMillis();
        HelperSort.quick((Vector)object, (Comparator)comparatorString);
        System.out.println("Quick: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        HelperSort.quick((Vector)object, (Comparator)comparatorString);
        System.out.println("Quick sorted: " + (System.currentTimeMillis() - l));
        object = (Vector)vector.clone();
        l = System.currentTimeMillis();
        HelperSort.shell((Vector)object, (Comparator)comparatorString);
        System.out.println("Shell: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        HelperSort.shell((Vector)object, (Comparator)comparatorString);
        System.out.println("Shell sorted: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        HelperSort.bubble((Vector)object, (Comparator)comparatorString);
        System.out.println("Bubble: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        HelperSort.bubble((Vector)object, (Comparator)comparatorString);
        System.out.println("Bubble sorted: " + (System.currentTimeMillis() - l));
    }

    /*
     * Unable to fully structure code
     */
    private static final void qsort0(Vector var0, Comparator var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = var0.elementAt((var2_2 + var3_3) / 2);
            ** GOTO lbl16
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && var1_1.compare(var0.elementAt(var4_4), var6_6) < 0) continue block0;
                    while (var5_5 > var2_2 && var1_1.compare(var0.elementAt(var5_5), var6_6) > 0) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    HelperSort.swap(var0, var4_4, var5_5);
                    ++var4_4;
                    --var5_5;
lbl16:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                HelperSort.qsort0(var0, var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                HelperSort.qsort0(var0, var1_1, var4_4, var3_3);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final void qsort0(Object[] var0, Comparator var1_1, int var2_2, int var3_3) {
        block5: {
            var4_4 = var2_2;
            var5_5 = var3_3;
            if (var3_3 <= var2_2) break block5;
            var6_6 = var0[(var2_2 + var3_3) / 2];
            ** GOTO lbl16
            {
                ++var4_4;
                do {
                    if (var4_4 < var3_3 && var1_1.compare(var0[var4_4], var6_6) < 0) continue block0;
                    while (var5_5 > var2_2 && var1_1.compare(var0[var5_5], var6_6) > 0) {
                        --var5_5;
                    }
                    if (var4_4 > var5_5) continue;
                    HelperSort.swap(var0, var4_4, var5_5);
                    ++var4_4;
                    --var5_5;
lbl16:
                    // 3 sources

                } while (var4_4 <= var5_5);
            }
            if (var2_2 < var5_5) {
                HelperSort.qsort0(var0, var1_1, var2_2, var5_5);
            }
            if (var4_4 < var3_3) {
                HelperSort.qsort0(var0, var1_1, var4_4, var3_3);
            }
        }
    }

    public static final void quick(Vector vector, Comparator comparator) {
        HelperSort.qsort0(vector, comparator, 0, vector.size() - 1);
    }

    public static final void quick(Object[] objectArray, Comparator comparator) {
        HelperSort.qsort0(objectArray, comparator, 0, objectArray.length - 1);
    }

    public static final void shell(Vector vector, Comparator comparator) {
        int n = 1;
        while (n < vector.size()) {
            n = 3 * n + 1;
        }
        while (n > 0) {
            int n2 = n = (n - 1) / 3;
            while (n2 < vector.size()) {
                Object e = vector.elementAt(n2);
                int n3 = 0;
                n3 = n2 - n;
                while (n3 >= 0 && comparator.compare(e, vector.elementAt(n3)) < 0) {
                    vector.setElementAt(vector.elementAt(n3), n3 + n);
                    n3 -= n;
                }
                vector.setElementAt(e, n3 + n);
                ++n2;
            }
        }
    }

    public static final void shell(Object[] objectArray, Comparator comparator) {
        int n = 1;
        while (n < objectArray.length) {
            n = 3 * n + 1;
        }
        while (n > 0) {
            int n2 = n = (n - 1) / 3;
            while (n2 < objectArray.length) {
                Object object = objectArray[n2];
                int n3 = 0;
                n3 = n2 - n;
                while (n3 >= 0 && comparator.compare(object, objectArray[n3]) < 0) {
                    objectArray[n3 + n] = objectArray[n3];
                    n3 -= n;
                }
                objectArray[n3 + n] = object;
                ++n2;
            }
        }
    }

    public static final void swap(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n);
        vector.setElementAt(vector.elementAt(n2), n);
        vector.setElementAt(e, n2);
    }

    public static final void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }
}

