/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.randomaccessdb;

import de.zwanzigeins.randomaccessdb.DataRecord;
import de.zwanzigeins.randomaccessdb.DatabaseDefinition;
import de.zwanzigeins.randomaccessdb.Field;
import de.zwanzigeins.randomaccessdb.SearchRecord;
import de.zwanzigeins.sort.Comparator;
import de.zwanzigeins.sort.ComparatorString;
import de.zwanzigeins.sort.HelperSort;
import de.zwanzigeins.util.HelperPath;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.Vector;

public class RandomAccessDatabase
extends DataRecord {
    private static Object LOCK = new Object();
    private RandomAccessFile rafFDB = null;
    private int[] internalresult_array = null;
    private int internalresult_pointer = 0;

    public RandomAccessDatabase(DatabaseDefinition databaseDefinition) {
        super(databaseDefinition);
        String string = HelperPath.splitPath_getPath(databaseDefinition.getDatabaseFile().getPath());
        new File(string).mkdirs();
        try {
            this.rafFDB = new RandomAccessFile(databaseDefinition.getDatabaseFile(), "rw");
        }
        catch (IOException iOException) {
            throw new RuntimeException("init: " + iOException.toString());
        }
    }

    public void close() {
        try {
            this.rafFDB.close();
        }
        catch (IOException iOException) {}
        this.rafFDB = null;
    }

    private void fdb_del(int n) throws IOException {
        DataRecord dataRecord = this.cloneRecord();
        this.fdb_recordseek(n);
        byte by = this.rafFDB.readByte();
        if (by != 70 || by != 66) {
            throw new RuntimeException("Record " + n + " corrupt");
        }
        this.rafFDB.read(dataRecord.buffer);
        Enumeration enumeration = dataRecord.ddf.fieldEnumerator();
        while (enumeration.hasMoreElements()) {
            Field field = (Field)enumeration.nextElement();
            if (field.bytType != 1) continue;
            String string = dataRecord.getString(field);
            this.ddf.getBlobFile(string).delete();
        }
        this.fdb_recordseek(n);
        this.rafFDB.writeByte(70);
    }

    private boolean fdb_get(int n) throws IOException {
        this.clear();
        this.fdb_recordseek(n);
        byte by = this.rafFDB.readByte();
        if (by == 66) {
            return false;
        }
        if (by != 70) {
            throw new RuntimeException("Record " + n + " corrupt");
        }
        this.rafFDB.read(this.buffer);
        return true;
    }

    private void fdb_put(int n) throws IOException {
        int n2 = n;
        if (n == -1) {
            n2 = this.fdb_records();
            int n3 = 0;
            while (n3 < this.fdb_records()) {
                this.fdb_recordseek(n3);
                byte by = this.rafFDB.readByte();
                if (by != 66 && by != 70) {
                    throw new RuntimeException("Record " + n3 + " corrupt");
                }
                if (by == 66) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
        }
        this.fdb_recordseek(n2);
        this.rafFDB.writeByte(70);
        this.rafFDB.write(this.buffer);
    }

    private int fdb_records() {
        int n = 0;
        try {
            n = (int)(((double)(this.rafFDB.length() + (long)this.ddf.getPagesize()) - 0.5) / (double)this.ddf.getPagesize());
        }
        catch (IOException iOException) {}
        return n;
    }

    private void fdb_recordseek(int n) {
        try {
            this.rafFDB.seek(n * this.ddf.getPagesize());
        }
        catch (IOException iOException) {}
    }

    private int[] fdb_search(SearchRecord searchRecord, int n) throws IOException {
        Vector<String> vector = new Vector<String>();
        DataRecord dataRecord = this.cloneRecord();
        int n2 = 0;
        while (n2 < this.fdb_records()) {
            this.fdb_recordseek(n2);
            if (this.rafFDB.readByte() != 66) {
                this.rafFDB.read(dataRecord.buffer);
                if (dataRecord.equals(searchRecord)) {
                    if (n != 0) {
                        vector.addElement(String.valueOf(dataRecord.sortString()) + "#" + this.rset(Integer.toString(n2), 16));
                    } else {
                        vector.addElement(Integer.toString(n2));
                    }
                }
            }
            ++n2;
        }
        switch (n) {
            case -1: 
            case 1: {
                HelperSort.quick(vector, (Comparator)new ComparatorString(n));
                break;
            }
        }
        int[] nArray = new int[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            String string = (String)vector.elementAt(n3);
            if (n != 0) {
                string = string.substring(string.length() - 16).trim();
            }
            nArray[n3] = Integer.parseInt(string);
            ++n3;
        }
        return nArray;
    }

    public void finalize() {
        this.close();
    }

    public static void main(String[] stringArray) throws Throwable {
        DatabaseDefinition databaseDefinition = new DatabaseDefinition(new File("C:\\$alla\\flatfile.fdb"), 1024);
        databaseDefinition.addColumnString("string", 25);
        databaseDefinition.addColumnString("value", 25);
        databaseDefinition.defineKeyColumn(1);
        RandomAccessDatabase randomAccessDatabase = new RandomAccessDatabase(databaseDefinition);
        randomAccessDatabase.setString(1, "stringval1");
        randomAccessDatabase.setString(2, "value_1");
        randomAccessDatabase.recordUpdate();
        randomAccessDatabase.setString(1, "stringval2");
        randomAccessDatabase.setString(2, "value_2");
        randomAccessDatabase.recordUpdate();
        SearchRecord searchRecord = new SearchRecord(databaseDefinition);
        searchRecord.clear();
        searchRecord.setString(1, "strin*");
        boolean bl = randomAccessDatabase.recordFindFirst(searchRecord, 1);
        while (bl) {
            System.out.println(randomAccessDatabase);
            bl = randomAccessDatabase.recordFindNext();
        }
        randomAccessDatabase.close();
    }

    public void recordDelete(SearchRecord searchRecord) {
        Object object = LOCK;
        synchronized (object) {
            try {
                int[] nArray = this.fdb_search(searchRecord, 0);
                int n = 0;
                while (n < nArray.length) {
                    this.fdb_del(nArray[n]);
                    ++n;
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("recordDelete: " + iOException.toString());
            }
        }
    }

    public synchronized boolean recordFind(SearchRecord searchRecord) {
        Object object = LOCK;
        synchronized (object) {
            try {
                this.clear();
                int[] nArray = this.fdb_search(searchRecord, 0);
                if (nArray.length != 0) {
                    this.fdb_get(nArray[0]);
                    return true;
                }
                return false;
            }
            catch (IOException iOException) {
                throw new RuntimeException("recordFind: " + iOException.toString());
            }
        }
    }

    public synchronized boolean recordFindFirst(SearchRecord searchRecord, int n) {
        Object object = LOCK;
        synchronized (object) {
            try {
                this.clear();
                this.internalresult_array = this.fdb_search(searchRecord, n);
                this.internalresult_pointer = 0;
                if (this.internalresult_pointer < this.internalresult_array.length) {
                    this.fdb_get(this.internalresult_array[this.internalresult_pointer++]);
                    return true;
                }
                this.internalresult_array = null;
                this.internalresult_pointer = 0;
                return false;
            }
            catch (IOException iOException) {
                throw new RuntimeException("recordFindFirst: " + iOException.toString());
            }
        }
    }

    public synchronized boolean recordFindNext() {
        Object object = LOCK;
        synchronized (object) {
            if (this.internalresult_array == null) {
                throw new RuntimeException("recordFindNext without recordFindFirst!");
            }
            try {
                this.clear();
                if (this.internalresult_pointer < this.internalresult_array.length) {
                    this.fdb_get(this.internalresult_array[this.internalresult_pointer++]);
                    return true;
                }
                this.internalresult_array = null;
                this.internalresult_pointer = 0;
                return false;
            }
            catch (IOException iOException) {
                throw new RuntimeException("recordFindNext: " + iOException.toString());
            }
        }
    }

    public synchronized void recordGet(int n) {
        Object object = LOCK;
        synchronized (object) {
            if (n < 0 || n > this.fdb_records()) {
                throw new RuntimeException("recordGet: Recordnumber out of range");
            }
            try {
                this.clear();
                this.fdb_get(n);
            }
            catch (IOException iOException) {
                throw new RuntimeException("recordGet: " + iOException.toString());
            }
        }
    }

    public synchronized void recordPut(int n) {
        Object object = LOCK;
        synchronized (object) {
            if (n < 0 || n > this.fdb_records()) {
                throw new RuntimeException("recordPut: Recordnumber out of range");
            }
            try {
                this.fdb_put(n);
            }
            catch (IOException iOException) {
                throw new RuntimeException("recordPut: " + iOException.toString());
            }
        }
    }

    public synchronized void recordUpdate() {
        Object object = LOCK;
        synchronized (object) {
            try {
                int[] nArray = this.fdb_search(this, 0);
                if (nArray.length == 0) {
                    this.fdb_put(-1);
                    return;
                }
                if (nArray.length == 1) {
                    this.fdb_put(nArray[0]);
                    return;
                }
                throw new RuntimeException("recordUpdate: duplicate results");
            }
            catch (IOException iOException) {
                throw new RuntimeException("recordUpdate: " + iOException.toString());
            }
        }
    }
}

