/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.randomaccessdb;

import de.zwanzigeins.randomaccessdb.DatabaseDefinition;
import de.zwanzigeins.randomaccessdb.Field;
import de.zwanzigeins.randomaccessdb.FieldTypes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Enumeration;

public abstract class DatabaseRecord
implements FieldTypes {
    protected DatabaseDefinition ddf = null;
    protected byte[] buffer = null;

    public DatabaseRecord(DatabaseDefinition databaseDefinition) {
        this.ddf = databaseDefinition;
    }

    public void clear() {
        int n = 0;
        while (n < this.buffer.length) {
            this.buffer[n] = 0;
            ++n;
        }
    }

    protected InputStream getBlob(Field field) throws FileNotFoundException {
        String string = this.getString(field);
        return new FileInputStream(this.ddf.getBlobFile(string));
    }

    protected byte getByte(Field field) {
        return this.buffer[field.intPosStart];
    }

    protected char getChar(Field field) {
        int n = field.intPosStart;
        char c = '\u0000';
        c = (char)(c + ((this.buffer[n++] & 0xFF) << 8));
        c = (char)(c + ((this.buffer[n++] & 0xFF) << 0));
        return c;
    }

    protected Date getDate(Field field) {
        return new Date(this.getLong(field));
    }

    protected double getDouble(Field field) {
        return Double.longBitsToDouble(this.getLong(field));
    }

    protected float getFloat(Field field) {
        return Float.intBitsToFloat(this.getInt(field));
    }

    protected int getInt(Field field) {
        int n = field.intPosStart;
        int n2 = 0;
        n2 += (this.buffer[n++] & 0xFF) << 24;
        n2 += (this.buffer[n++] & 0xFF) << 16;
        n2 += (this.buffer[n++] & 0xFF) << 8;
        return n2 += (this.buffer[n++] & 0xFF) << 0;
    }

    protected long getLong(Field field) {
        int n = field.intPosStart;
        long l = 0L;
        l += (long)(this.buffer[n++] & 0xFF) << 56;
        l += (long)(this.buffer[n++] & 0xFF) << 48;
        l += (long)(this.buffer[n++] & 0xFF) << 40;
        l += (long)(this.buffer[n++] & 0xFF) << 32;
        l += (long)(this.buffer[n++] & 0xFF) << 24;
        l += (long)(this.buffer[n++] & 0xFF) << 16;
        l += (long)(this.buffer[n++] & 0xFF) << 8;
        return l += (long)(this.buffer[n++] & 0xFF) << 0;
    }

    protected String getString(Field field) {
        int n = field.intLength;
        int n2 = 0;
        while (n2 < n) {
            if (this.buffer[n2 + field.intPosStart] == 0) {
                n = n2;
                break;
            }
            ++n2;
        }
        try {
            return new String(this.buffer, field.intPosStart, n, this.ddf.getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return unsupportedEncodingException.toString();
        }
    }

    public String lset(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            n2 = n;
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = (byte)string.charAt(n3);
            ++n3;
        }
        n3 = n2++;
        while (n3 < n) {
            byArray[n3] = 32;
            ++n3;
        }
        return new String(byArray);
    }

    public String rset(String string, int n) {
        int n2 = string.length();
        if (n2 > n) {
            n2 = n;
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n3 < n - n2) {
            byArray[n3] = 32;
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            byArray[n3 + n - n2] = (byte)string.charAt(n3);
            ++n3;
        }
        return new String(byArray);
    }

    protected void sanitycheck(Field field, byte by) {
        if (this.buffer == null) {
            throw new RuntimeException("Buffer not allocated!");
        }
        if (field == null) {
            return;
        }
        if (field.intPosEnd + 1 > this.buffer.length) {
            throw new RuntimeException("Field access beyond buffer");
        }
        if (field.bytType != by) {
            throw new RuntimeException("Type mismatch on requested field " + field.strName);
        }
    }

    protected void setBlob(Field field, InputStream inputStream) throws IOException {
        String string = this.getString(field);
        if (string.length() > 0) {
            this.ddf.getBlobFile(string).delete();
        }
        string = this.ddf.getBlobUID();
        this.setString(field, string);
        File file = this.ddf.getBlobFile(string);
        file.delete();
        int n = 0;
        byte[] byArray = new byte[8192];
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileOutputStream = new FileOutputStream(file);
                while ((n = inputStream.read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("setBlob: " + iOException.toString());
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var8_11 = null;
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
    }

    protected void setByte(Field field, byte by) {
        this.buffer[field.intPosStart] = by;
    }

    protected void setChar(Field field, char c) {
        int n = field.intPosStart;
        this.buffer[n++] = (byte)(c >>> 8 & 0xFF);
        this.buffer[n++] = (byte)(c >>> 0 & 0xFF);
    }

    protected void setDate(Field field, Date date) {
        this.setLong(field, date.getTime());
    }

    protected void setDouble(Field field, double d) {
        this.setLong(field, Double.doubleToLongBits(d));
    }

    protected void setFloat(Field field, float f) {
        this.setInt(field, Float.floatToIntBits(f));
    }

    protected void setInt(Field field, int n) {
        int n2 = field.intPosStart;
        this.buffer[n2++] = (byte)(n >>> 24 & 0xFF);
        this.buffer[n2++] = (byte)(n >>> 16 & 0xFF);
        this.buffer[n2++] = (byte)(n >>> 8 & 0xFF);
        this.buffer[n2++] = (byte)(n >>> 0 & 0xFF);
    }

    protected void setLong(Field field, long l) {
        int n = field.intPosStart;
        this.buffer[n++] = (byte)(l >>> 56 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 48 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 40 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 32 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 24 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 16 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 8 & 0xFFL);
        this.buffer[n++] = (byte)(l >>> 0 & 0xFFL);
    }

    protected void setString(Field field, String string) {
        int n = string.length();
        if (n > field.intLength) {
            n = field.intLength;
        }
        byte[] byArray = null;
        try {
            byArray = string.getBytes(this.ddf.getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Unsupported charset: " + this.ddf.getCharset());
        }
        int n2 = 0;
        while (n2 < n) {
            this.buffer[n2 + field.intPosStart] = byArray[n2];
            ++n2;
        }
        if (n < field.intLength) {
            this.buffer[field.intPosStart + n] = 0;
        }
    }

    public String sortString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.ddf.fieldEnumerator();
        while (enumeration.hasMoreElements()) {
            Field field = (Field)enumeration.nextElement();
            if (!field.blnKeyField) continue;
            switch (field.bytType) {
                case 1: {
                    stringBuffer.append(this.getString(field));
                    break;
                }
                case 2: {
                    stringBuffer.append(this.lset(this.getString(field), field.intLength));
                    break;
                }
                case 3: {
                    stringBuffer.append(this.rset(Long.toString(this.getLong(field)), 16));
                    break;
                }
                case 4: {
                    stringBuffer.append(this.rset(Integer.toString(this.getInt(field)), 8));
                    break;
                }
                case 5: {
                    stringBuffer.append(this.rset(String.valueOf(this.getChar(field)), 2));
                    break;
                }
                case 6: {
                    stringBuffer.append(this.rset(Byte.toString(this.getByte(field)), 3));
                    break;
                }
                case 7: {
                    stringBuffer.append(this.rset(Long.toString(this.getLong(field)), 16));
                    break;
                }
                case 8: {
                    stringBuffer.append(this.rset(Long.toString(this.getLong(field)), 16));
                    break;
                }
                case 9: {
                    stringBuffer.append(this.rset(Integer.toString(this.getInt(field)), 8));
                }
            }
            stringBuffer.append("#");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.ddf.fieldEnumerator();
        while (enumeration.hasMoreElements()) {
            Field field = (Field)enumeration.nextElement();
            stringBuffer.append(field.strName);
            stringBuffer.append("=");
            switch (field.bytType) {
                case 1: {
                    stringBuffer.append(this.getString(field));
                    break;
                }
                case 2: {
                    stringBuffer.append(this.getString(field));
                    break;
                }
                case 3: {
                    stringBuffer.append(this.getLong(field));
                    break;
                }
                case 4: {
                    stringBuffer.append(this.getInt(field));
                    break;
                }
                case 5: {
                    stringBuffer.append(this.getChar(field));
                    break;
                }
                case 6: {
                    stringBuffer.append(this.getByte(field));
                    break;
                }
                case 7: {
                    stringBuffer.append(this.getDate(field));
                    break;
                }
                case 8: {
                    stringBuffer.append(this.getDouble(field));
                    break;
                }
                case 9: {
                    stringBuffer.append(this.getFloat(field));
                }
            }
            stringBuffer.append(",");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

