/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.randomaccessdb;

import de.zwanzigeins.randomaccessdb.Field;
import de.zwanzigeins.randomaccessdb.FieldTypes;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.TimeFactory;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class DatabaseDefinition
implements FieldTypes {
    private Vector vecFields = new Vector(10, 1);
    private Hashtable hshFields = new Hashtable(50);
    private boolean blnHasKeyField = false;
    private int intBytesAllocated = 0;
    private File flDatabase = null;
    private int intPageSize;
    private String strCharset = null;

    public DatabaseDefinition(File file, int n) {
        this(file, n, "iso-8859-1");
    }

    public DatabaseDefinition(File file, int n, String string) {
        this.init();
        this.flDatabase = file;
        this.intPageSize = n;
        this.strCharset = string;
        try {
            "".getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = "iso-8859-1";
        }
    }

    private void addColumn(byte by, String string, int n) {
        if (this.hshFields.containsKey(string = string.toUpperCase())) {
            throw new RuntimeException("Duplicate column name: " + string);
        }
        Field field = new Field();
        field.bytType = by;
        field.strName = string;
        field.intLength = n;
        field.intPosStart = this.intBytesAllocated;
        this.intBytesAllocated += n;
        field.intPosEnd = this.intBytesAllocated;
        this.vecFields.addElement(field);
        this.hshFields.put(string, new Integer(this.vecFields.size() - 1));
    }

    protected void addColumnBlob(String string) {
        this.addColumn((byte)1, string, 20);
    }

    protected void addColumnByte(String string) {
        this.addColumn((byte)6, string, 20);
    }

    protected void addColumnChar(String string) {
        this.addColumn((byte)5, string, 2);
    }

    protected void addColumnDate(String string) {
        this.addColumn((byte)7, string, 8);
    }

    protected void addColumnDouble(String string) {
        this.addColumn((byte)8, string, 8);
    }

    protected void addColumnFloat(String string) {
        this.addColumn((byte)9, string, 4);
    }

    protected void addColumnInt(String string) {
        this.addColumn((byte)4, string, 4);
    }

    protected void addColumnLong(String string) {
        this.addColumn((byte)3, string, 8);
    }

    protected void addColumnString(String string, int n) {
        this.addColumn((byte)2, string, n);
    }

    public void defineKeyColumn(int n) {
        this.defineKeyColumn(this.getFieldByIdx(n));
    }

    private void defineKeyColumn(Field field) {
        field.blnKeyField = true;
        this.blnHasKeyField = true;
    }

    public void defineKeyColumn(String string) {
        this.defineKeyColumn(this.getFieldByName(string));
    }

    public boolean equals(Object object) {
        if (!(object instanceof DatabaseDefinition)) {
            return false;
        }
        DatabaseDefinition databaseDefinition = (DatabaseDefinition)object;
        if (this.vecFields.size() != databaseDefinition.vecFields.size()) {
            return false;
        }
        int n = 0;
        while (n < this.vecFields.size()) {
            Field field = (Field)this.vecFields.elementAt(n);
            Field field2 = (Field)databaseDefinition.vecFields.elementAt(n);
            if (field.blnKeyField && field.bytType != field2.bytType) {
                return false;
            }
            ++n;
        }
        return true;
    }

    Enumeration fieldEnumerator() {
        return this.vecFields.elements();
    }

    File getBlobFile(String string) {
        String string2 = HelperPath.splitPath_getPath(this.flDatabase.getPath());
        return new File(string2, String.valueOf(string) + ".blob");
    }

    String getBlobUID() {
        return TimeFactory.createUID();
    }

    String getCharset() {
        return this.strCharset;
    }

    File getDatabaseFile() {
        return this.flDatabase;
    }

    Field getFieldByIdx(int n) {
        if (n < 1 || n > this.vecFields.size()) {
            throw new RuntimeException("Fieldindex out of range: '" + n + "'");
        }
        return (Field)this.vecFields.elementAt(n - 1);
    }

    Field getFieldByName(String string) {
        Integer n = (Integer)this.hshFields.get(string.toUpperCase());
        if (n == null) {
            throw new RuntimeException("Unknown Field: '" + string + "'");
        }
        return (Field)this.vecFields.elementAt(n);
    }

    int getPagesize() {
        return this.intPageSize;
    }

    public void init() {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.vecFields.size()) {
            Field field = (Field)this.vecFields.elementAt(n);
            stringBuffer.append("Name: ");
            stringBuffer.append(field.strName);
            stringBuffer.append(", Type: ");
            stringBuffer.append(Field.type2string(field.bytType));
            stringBuffer.append("; ");
            ++n;
        }
        return stringBuffer.toString();
    }
}

