/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.randomaccessdb;

import de.zwanzigeins.randomaccessdb.DatabaseDefinition;
import de.zwanzigeins.randomaccessdb.Field;
import de.zwanzigeins.randomaccessdb.SearchRecord;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;

public class DataRecord
extends SearchRecord {
    protected static final byte REC_FREE = 66;
    protected static final byte REC_BUSY = 70;

    public DataRecord(DatabaseDefinition databaseDefinition) {
        super(databaseDefinition);
        this.buffer = new byte[databaseDefinition.getPagesize() - 1];
    }

    public DataRecord cloneRecord() {
        DataRecord dataRecord = new DataRecord(this.ddf);
        dataRecord.buffer = new byte[this.buffer.length];
        int n = 0;
        while (n < this.buffer.length) {
            dataRecord.buffer[n] = this.buffer[n];
            ++n;
        }
        return dataRecord;
    }

    public boolean equals(Object object) {
        if (!(object instanceof SearchRecord)) {
            return false;
        }
        SearchRecord searchRecord = (SearchRecord)object;
        if (searchRecord.ddf.getPagesize() != this.ddf.getPagesize()) {
            return false;
        }
        boolean bl = true;
        Enumeration enumeration = searchRecord.ddf.fieldEnumerator();
        while (enumeration.hasMoreElements()) {
            Field field = (Field)enumeration.nextElement();
            Field field2 = this.ddf.getFieldByName(field.strName);
            if (!field.blnKeyField) continue;
            if (field.bytType != field2.bytType) {
                bl = false;
                break;
            }
            switch (field.bytType) {
                case 1: {
                    break;
                }
                case 2: {
                    String string = searchRecord.getString(field);
                    String string2 = this.getString(field2);
                    int n = string.indexOf("*");
                    if (n == -1) {
                        bl = string.equals(string2);
                        break;
                    }
                    if (string2.length() < n) {
                        bl = false;
                        break;
                    }
                    string = string.substring(0, n);
                    string2 = string2.substring(0, n);
                    bl &= string.equals(string2);
                    break;
                }
                case 3: {
                    bl &= this.getLong(field2) == searchRecord.getLong(field);
                    break;
                }
                case 4: {
                    bl &= this.getInt(field2) == searchRecord.getInt(field);
                    break;
                }
                case 5: {
                    bl &= this.getChar(field2) == searchRecord.getChar(field);
                    break;
                }
                case 6: {
                    bl &= this.getByte(field2) == searchRecord.getByte(field);
                    break;
                }
                case 7: {
                    bl &= this.getLong(field2) == searchRecord.getLong(field);
                    break;
                }
                case 8: {
                    bl &= this.getLong(field2) == searchRecord.getLong(field);
                    break;
                }
                case 9: {
                    bl &= this.getInt(field2) == searchRecord.getInt(field);
                }
            }
            if (!bl) break;
        }
        return bl;
    }

    public InputStream getBlob(int n) throws FileNotFoundException {
        Field field = this.ddf.getFieldByIdx(n);
        this.sanitycheck(field, (byte)1);
        return this.getBlob(field);
    }

    public InputStream getBlob(String string) throws FileNotFoundException {
        Field field = this.ddf.getFieldByName(string);
        this.sanitycheck(field, (byte)1);
        return this.getBlob(field);
    }

    public byte getByte(int n) {
        Field field = this.ddf.getFieldByIdx(n);
        this.sanitycheck(field, (byte)6);
        return this.getByte(field);
    }

    public byte getByte(String string) {
        Field field = this.ddf.getFieldByName(string);
        this.sanitycheck(field, (byte)6);
        return this.getByte(field);
    }

    public char getChar(int n) {
        Field field = this.ddf.getFieldByIdx(n);
        this.sanitycheck(field, (byte)5);
        return this.getChar(field);
    }

    public char getChar(String string) {
        Field field = this.ddf.getFieldByName(string);
        this.sanitycheck(field, (byte)5);
        return this.getChar(field);
    }

    public Date getDate(int n) {
        Field field = this.ddf.getFieldByIdx(n);
        this.sanitycheck(field, (byte)7);
        return this.getDate(field);
    }

    public Date getDate(String string) {
        Field field = this.ddf.getFieldByName(string);
        this.sanitycheck(field, (byte)7);
        return this.getDate(field);
    }

    public double getDouble(int n) {
        Field field = this.ddf.getFieldByIdx(n);
        this.sanitycheck(field, (byte)8);
        return this.getDouble(field);
    }

    public double getDouble(String string) {
        Field field = this.ddf.getFieldByName(string);
        this.sanitycheck(field, (byte)8);
        return this.getDouble(field);
    }

    public float getFloat(int n) {
        Field field = this.ddf.getFieldByIdx(n);
        this.sanitycheck(field, (byte)9);
        return this.getFloat(field);
    }

    public float getFloat(String string) {
        Field field = this.ddf.getFieldByName(string);
        this.sanitycheck(field, (byte)9);
        return this.getFloat(field);
    }

    public int getInt(int n) {
        Field field = this.ddf.getFieldByIdx(n);
        this.sanitycheck(field, (byte)4);
        return this.getInt(field);
    }

    public int getInt(String string) {
        Field field = this.ddf.getFieldByName(string);
        this.sanitycheck(field, (byte)4);
        return this.getInt(field);
    }

    public long getLong(int n) {
        Field field = this.ddf.getFieldByIdx(n);
        this.sanitycheck(field, (byte)3);
        return this.getLong(field);
    }

    public long getLong(String string) {
        Field field = this.ddf.getFieldByName(string);
        this.sanitycheck(field, (byte)3);
        return this.getLong(field);
    }

    public String getString(int n) {
        Field field = this.ddf.getFieldByIdx(n);
        this.sanitycheck(field, (byte)2);
        return this.getString(field);
    }

    public String getString(String string) {
        Field field = this.ddf.getFieldByName(string);
        this.sanitycheck(field, (byte)2);
        return this.getString(field);
    }
}

