/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.menue;

import de.zwanzigeins.menue.MenuItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class TreeMenu {
    private static final int MAX_DEPTH = 5;
    private Vector vecItems = null;
    private int intCurrentDepth = -1;
    private int[] intParentStack = null;
    private int[] intSubmenuCounter = null;
    private int intLastClicked = 0;

    public TreeMenu() {
        this.init();
    }

    public void addMenuItem(String string) {
        this.addMenuItem(string, null);
    }

    public void addMenuItem(String string, Object object) {
        int n;
        if (string.trim().startsWith(";")) {
            return;
        }
        MenuItem menuItem = new MenuItem();
        while (menuItem.intIndentation < string.length() && string.charAt(menuItem.intIndentation) == ' ') {
            ++menuItem.intIndentation;
        }
        menuItem.strDisplay = string.trim();
        menuItem.objAction = object;
        menuItem.isVisible = menuItem.intIndentation == 0;
        menuItem.intIdx = this.vecItems.size();
        if (menuItem.intIndentation > this.intCurrentDepth) {
            this.intParentStack[menuItem.intIndentation] = this.vecItems.size() - 1;
            this.getMenuItem((int)(this.vecItems.size() - 1)).isBranchNode = true;
        }
        menuItem.intParent = this.intParentStack[menuItem.intIndentation];
        if (menuItem.intIndentation < this.intCurrentDepth && this.intCurrentDepth > 0) {
            n = menuItem.intIndentation + 1;
            while (n < this.intCurrentDepth) {
                this.intSubmenuCounter[n] = 0;
                ++n;
            }
        }
        int n2 = menuItem.intIndentation;
        this.intSubmenuCounter[n2] = this.intSubmenuCounter[n2] + 1;
        menuItem.strNumeration = "";
        n = 0;
        while (n < menuItem.intIndentation + 1) {
            menuItem.strNumeration = String.valueOf(menuItem.strNumeration) + this.intSubmenuCounter[n] + ".";
            ++n;
        }
        menuItem.strNumeration = menuItem.strNumeration.substring(0, menuItem.strNumeration.length() - 1);
        if (this.vecItems.size() > 0) {
            this.getMenuItem((int)(this.vecItems.size() - 1)).isLast = menuItem.intIndentation != this.intCurrentDepth;
        }
        menuItem.isLast = true;
        this.intCurrentDepth = menuItem.intIndentation;
        this.vecItems.addElement(menuItem);
    }

    private void click(int n, int n2) {
        this.intLastClicked = n;
        MenuItem menuItem = this.getMenuItem(n);
        if (!menuItem.isBranchNode) {
            return;
        }
        switch (n2) {
            case -1: {
                menuItem.isOpen = false;
                break;
            }
            case 0: {
                menuItem.isOpen = !menuItem.isOpen;
                break;
            }
            case 1: {
                menuItem.isOpen = true;
            }
        }
        boolean bl = menuItem.isOpen;
        int cfr_ignored_0 = menuItem.intParent;
        int n3 = menuItem.intIndentation;
        if (bl) {
            int n4 = n + 1;
            while (n4 < this.vecItems.size()) {
                menuItem = this.getMenuItem(n4);
                if (menuItem.intIndentation == n3 + 1) {
                    menuItem.isVisible = true;
                    menuItem.isOpen = !menuItem.isBranchNode;
                    ++n4;
                    continue;
                }
                break;
            }
        } else {
            int n5 = n + 1;
            while (n5 < this.vecItems.size()) {
                menuItem = this.getMenuItem(n5);
                if (menuItem.intIndentation > n3) {
                    menuItem.isVisible = false;
                    menuItem.isOpen = false;
                    ++n5;
                    continue;
                }
                break;
            }
        }
    }

    public void clickClose(int n) {
        this.click(n, -1);
    }

    public void clickOpen(int n) {
        this.click(n, 1);
    }

    public void clickToggle(int n) {
        this.click(n, 0);
    }

    public void closeAll() {
        int n = 0;
        while (n < this.size()) {
            MenuItem menuItem = this.getMenuItem(n);
            menuItem.isVisible = true;
            if (menuItem.intIndentation > 0) {
                menuItem.isVisible = false;
            }
            menuItem.isOpen = false;
            ++n;
        }
    }

    public void dump() {
        System.out.println("Items: " + this.vecItems.size());
        int n = 0;
        while (n < this.vecItems.size()) {
            MenuItem menuItem = (MenuItem)this.vecItems.elementAt(n);
            System.out.println(menuItem);
            ++n;
        }
    }

    public int getClickedMenuIndex() {
        return this.intLastClicked;
    }

    public String getClickedMenuName() {
        return this.getMenuItem((int)this.intLastClicked).strDisplay;
    }

    public String getClickedMenuNumber() {
        return this.getMenuItem((int)this.intLastClicked).strNumeration;
    }

    public String getClickedMenuPath() {
        String[] stringArray = this.getClickedMenuPathList();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n < stringArray.length - 1) {
                stringBuffer.append(" / ");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String[] getClickedMenuPathList() {
        Vector<String> vector = new Vector<String>();
        new StringBuffer();
        String string = this.getMenuItem((int)this.intLastClicked).strNumeration;
        int n = 0;
        while (n < string.length()) {
            int n2 = 0;
            while (n2 < this.size()) {
                MenuItem menuItem = this.getMenuItem(n2);
                if (menuItem.strNumeration.equals(string.substring(0, n + 1))) {
                    vector.addElement(menuItem.strDisplay);
                }
                ++n2;
            }
            n += 2;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public MenuItem getMenuItem(int n) {
        if (n < 0 || n >= this.vecItems.size()) {
            MenuItem menuItem = new MenuItem();
            menuItem.strNumeration = "0.0.0.0";
            menuItem.strDisplay = "illegal index '" + n + "'";
            return menuItem;
        }
        return (MenuItem)this.vecItems.elementAt(n);
    }

    public String getMenuStatus() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.intLastClicked);
        stringBuffer.append("#");
        int n = 0;
        while (n < this.size()) {
            MenuItem menuItem = this.getMenuItem(n);
            stringBuffer.append(menuItem.isVisible ? "1" : "0");
            stringBuffer.append("#");
            stringBuffer.append(menuItem.isOpen ? "1" : "0");
            stringBuffer.append("#");
            ++n;
        }
        return stringBuffer.toString();
    }

    private void init() {
        this.reset();
    }

    public boolean load(File file) {
        this.reset();
        if (!file.exists()) {
            return false;
        }
        BufferedReader bufferedReader = null;
        try {
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.trim().length() == 0 || string.startsWith("#") || string.startsWith(";")) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
                    String string2 = stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) {
                        this.addMenuItem(string2);
                        continue;
                    }
                    this.addMenuItem(string2, stringTokenizer.nextToken());
                }
            }
            catch (IOException iOException) {
                Object var3_7 = null;
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable) {}
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            try {
                bufferedReader.close();
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        Object var3_9 = null;
        try {
            bufferedReader.close();
        }
        catch (Throwable throwable) {}
        return false;
    }

    public static void main(String[] stringArray) {
        TreeMenu treeMenu = new TreeMenu();
        treeMenu.addMenuItem("Startseite");
        treeMenu.addMenuItem("Shop");
        treeMenu.addMenuItem(" Datenupload");
        treeMenu.addMenuItem(" Sperren");
        treeMenu.addMenuItem(" Freigeben");
        treeMenu.addMenuItem(" Bestellungen");
        treeMenu.addMenuItem(" Auswertungen");
        treeMenu.addMenuItem("  Hitlisten");
        treeMenu.addMenuItem("   ..nach Umsatz");
        treeMenu.addMenuItem("   ..nach Positionen");
        treeMenu.addMenuItem("   ..nach Bestellungen");
        treeMenu.addMenuItem("Administration");
        treeMenu.addMenuItem(" Shopstatus");
        treeMenu.addMenuItem("Abmelden");
        treeMenu.closeAll();
        treeMenu.clickOpen(1);
        treeMenu.setMenuStatus(treeMenu.getMenuStatus());
        treeMenu.clickOpen(6);
        treeMenu.setMenuStatus(treeMenu.getMenuStatus());
        treeMenu.dump();
    }

    public void openAll() {
        int n = 0;
        while (n < this.size()) {
            MenuItem menuItem = this.getMenuItem(n);
            menuItem.isVisible = true;
            menuItem.isOpen = true;
            ++n;
        }
    }

    public void reset() {
        this.vecItems = new Vector();
        this.intCurrentDepth = 0;
        this.intParentStack = new int[5];
        this.intSubmenuCounter = new int[5];
        this.intLastClicked = 0;
    }

    public void setMenuStatus(String string) {
        this.closeAll();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
        try {
            this.intLastClicked = Integer.parseInt(stringTokenizer.nextToken());
            int n = 0;
            while (n < this.size()) {
                MenuItem menuItem = this.getMenuItem(n);
                menuItem.isVisible = stringTokenizer.nextToken().equals("1");
                menuItem.isOpen = stringTokenizer.nextToken().equals("1");
                ++n;
            }
        }
        catch (Throwable throwable) {
            this.closeAll();
        }
    }

    public int size() {
        return this.vecItems.size();
    }
}

