/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.io;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TeeInputStream
extends InputStream {
    InputStream in = null;
    FileOutputStream fos = null;

    public TeeInputStream(InputStream inputStream, String string) {
        this.in = inputStream;
        try {
            this.fos = new FileOutputStream(string);
        }
        catch (IOException iOException) {
            System.out.println("Cannot create tee-file " + string + ": " + iOException.toString());
        }
    }

    public void close() throws IOException {
        this.in.close();
        if (this.fos != null) {
            this.fos.close();
        }
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1 && this.fos != null) {
            this.fos.write(n);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (n != -1 && this.fos != null) {
            this.fos.write(byArray, 0, n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 != -1 && this.fos != null) {
            this.fos.write(byArray, 0, n3);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }
}

