/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.io;

import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PartialInputStream
extends FilterInputStream {
    private long lngLwbByte = 0L;
    private long lngUpbByte = 0L;
    private long lngRemaining = 0L;
    private boolean blnHadSeeked = false;

    public PartialInputStream(InputStream inputStream, long l, long l2) {
        super(inputStream);
        this.lngLwbByte = l;
        this.lngUpbByte = l2;
    }

    public int available() throws IOException {
        int n = this.in.available();
        if ((long)n > this.lngRemaining) {
            return (int)this.lngRemaining;
        }
        return n;
    }

    private void firstSkip() throws IOException {
        if (this.blnHadSeeked) {
            return;
        }
        this.in.skip(this.lngLwbByte);
        this.lngRemaining = this.lngUpbByte - this.lngLwbByte + 1L;
        this.blnHadSeeked = true;
    }

    public static void main(String[] stringArray) throws IOException {
        FileInputStream fileInputStream = new FileInputStream("data");
        PartialInputStream partialInputStream = new PartialInputStream(fileInputStream, 11L, 10L);
        byte[] byArray = new byte[255];
        int n = partialInputStream.read(byArray);
        fileInputStream.close();
        System.out.println("Read  : " + n);
        System.out.println("Buffer: " + new String(byArray, 0, n));
    }

    public int read() throws IOException {
        this.firstSkip();
        --this.lngRemaining;
        if (this.lngRemaining < 0L) {
            return -1;
        }
        return this.in.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.firstSkip();
        if (this.lngRemaining == 0L) {
            return -1;
        }
        if (this.lngRemaining - (long)n2 < 0L) {
            n2 = (int)this.lngRemaining;
        }
        int n3 = this.in.read(byArray, n, n2);
        this.lngRemaining -= (long)n3;
        return n3;
    }
}

