/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.io;

import de.zwanzigeins.io.ExtendedBufferedOutputStreamCallback;
import java.io.BufferedReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;

public class ExtendedBufferedOutputStream
extends FilterOutputStream {
    private byte[] buffer = null;
    private int intBufferCount = 0;
    private boolean blnCommitted = false;
    private ExtendedBufferedOutputStreamCallback flushHandler = null;
    public String STACKTRACE = "";

    public ExtendedBufferedOutputStream(OutputStream outputStream) {
        this(outputStream, 512);
    }

    public ExtendedBufferedOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.buffer = new byte[n];
    }

    public synchronized void close() throws IOException {
        if (this.out == null) {
            return;
        }
        this.flush();
        this.out.close();
        this.out = null;
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    public synchronized void flush() throws IOException {
        if (this.out == null) {
            return;
        }
        this.flushBuffer();
        this.out.flush();
    }

    private void flushBuffer() throws IOException {
        if (this.flushHandler != null) {
            this.flushHandler.flushBefore();
            this.blnCommitted = true;
            this.stacktrace();
        }
        if (this.intBufferCount > 0) {
            this.out.write(this.buffer, 0, this.intBufferCount);
            this.intBufferCount = 0;
            this.blnCommitted = true;
            this.stacktrace();
        }
    }

    public synchronized int getBufferSize() {
        return this.buffer.length;
    }

    public synchronized boolean hasWritten() {
        return this.blnCommitted || this.intBufferCount > 0;
    }

    public synchronized boolean isCommitted() {
        return this.blnCommitted;
    }

    public synchronized void reset() {
        this.intBufferCount = 0;
        this.blnCommitted = false;
    }

    public synchronized void setBufferSize(int n) throws IOException {
        this.flushBuffer();
        this.buffer = new byte[n];
    }

    public void setHandler(ExtendedBufferedOutputStreamCallback extendedBufferedOutputStreamCallback) {
        this.flushHandler = extendedBufferedOutputStreamCallback;
    }

    private void stacktrace() {
        StringBuffer stringBuffer;
        try {
            throw new RuntimeException("SNAPSHOT");
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            stringBuffer = new StringBuffer();
            try {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable2.printStackTrace(printWriter);
                BufferedReader bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if ((string = string.trim()).length() == 0) continue;
                    stringBuffer.append("\n");
                    stringBuffer.append(string.trim());
                }
            }
            catch (IOException iOException) {}
        }
        this.STACKTRACE = stringBuffer.toString();
    }

    public String toString() {
        return new String(this.buffer, 0, this.intBufferCount);
    }

    public synchronized void write(int n) throws IOException {
        this.ensureOpen();
        if (this.intBufferCount >= this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.intBufferCount++] = (byte)n;
    }

    public synchronized void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (n2 >= this.buffer.length) {
            this.flushBuffer();
            this.out.write(byArray, n, n2);
            return;
        }
        if (n2 > this.buffer.length - this.intBufferCount) {
            this.flushBuffer();
        }
        System.arraycopy(byArray, n, this.buffer, this.intBufferCount, n2);
        this.intBufferCount += n2;
    }

    public synchronized void write_direct(int n) throws IOException {
        this.ensureOpen();
        this.out.write(n);
    }

    public synchronized void write_direct(byte[] byArray) throws IOException {
        this.ensureOpen();
        this.out.write(byArray);
    }

    public synchronized void write_direct(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        this.out.write(byArray, n, n2);
    }
}

