/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CRLFInputStream
extends InputStream {
    private InputStream in = null;
    private int intPushback = -1;
    private long lngBytesRead = 0L;
    private char chEOL;
    private StringBuffer strbLine = null;
    private int intExpectedLineLength = -1;

    public CRLFInputStream(InputStream inputStream) {
        this(inputStream, '\n', 255);
    }

    public CRLFInputStream(InputStream inputStream, char c, int n) {
        this.in = inputStream;
        this.chEOL = c;
        this.intExpectedLineLength = n;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public long getBytesRead() {
        return this.lngBytesRead;
    }

    public char getEOLChar() {
        return this.chEOL;
    }

    public static void main(String[] stringArray) throws Throwable {
        int n;
        File file = new File("\\request.$$$");
        File file2 = new File("\\xx");
        CRLFInputStream cRLFInputStream = new CRLFInputStream(new FileInputStream(file));
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] cfr_ignored_0 = new byte[256];
        while ((n = cRLFInputStream.readCRLF()) != -1) {
            fileOutputStream.write(n);
        }
        cRLFInputStream.close();
        fileOutputStream.close();
        System.out.println(cRLFInputStream.getBytesRead());
    }

    public void mark(int n) {
        this.in.mark(n);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        int n = this.intPushback;
        if (n == -1) {
            n = this.in.read();
        }
        if (n != -1) {
            ++this.lngBytesRead;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.intPushback;
        if (n3 == -1) {
            n3 = this.in.read(byArray, n, n2);
        } else {
            byArray[0] = (byte)(this.intPushback & 0xFF);
            n3 = this.in.read(byArray, n + 1, n2 - 1);
            if (n3 != -1) {
                ++n3;
            }
        }
        if (n3 != -1) {
            this.lngBytesRead += (long)n3;
        }
        return n3;
    }

    public int readCRLF() throws IOException {
        int n = this.intPushback;
        if (n != -1) {
            this.intPushback = -1;
        } else {
            n = this.in.read();
            if (n != -1) {
                ++this.lngBytesRead;
            }
        }
        if (n == 13) {
            this.intPushback = this.in.read();
            if (n != -1) {
                ++this.lngBytesRead;
            }
            if (this.intPushback == 10) {
                this.intPushback = -1;
            }
        }
        if (n == 13 || n == 10) {
            n = this.chEOL;
        }
        return n;
    }

    public String readCRLFLine() throws IOException {
        if (this.strbLine == null) {
            this.strbLine = new StringBuffer(this.intExpectedLineLength);
        } else {
            this.strbLine.setLength(0);
        }
        int n = 0;
        while ((n = this.readCRLF()) != -1 && n != this.chEOL) {
            this.strbLine.append((char)n);
        }
        return this.strbLine.toString();
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public void resetBytesRead() {
        this.setBytesRead(0L);
    }

    public void setBytesRead(long l) {
        this.lngBytesRead = l;
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }
}

