/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.gfx;

import de.zwanzigeins.gfx.ImagePanelWithText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

public class SplashPanelGFX
implements Runnable {
    public static final int CENTER = 0;
    public static final int NORTH_WEST = 1;
    public static final int NORTH = 2;
    public static final int NORTH_EAST = 3;
    public static final int EAST = 4;
    public static final int SOUTH_EAST = 5;
    public static final int SOUTH = 6;
    public static final int SOUTH_WEST = 7;
    public static final int WEST = 8;
    private boolean blnIsRunning;
    private long lngRes = 0L;
    private Frame frm = null;
    private boolean blnOwnFrame = false;
    private Window win = null;
    private Thread thrd = null;
    private Object objLock = null;
    private ImagePanelWithText ip = null;
    private long lngDelay = 0L;

    public SplashPanelGFX() {
        this.init();
    }

    public SplashPanelGFX(Frame frame) {
        this.frm = frame;
        this.init();
    }

    public void dispose() {
        if (this.win != null) {
            ((Component)this.win).setVisible(false);
            this.win.dispose();
            this.win = null;
        }
        if (this.blnOwnFrame && this.frm != null) {
            ((Component)this.frm).setVisible(false);
            this.frm.dispose();
            this.frm = null;
        }
        if (this.thrd != null) {
            this.blnIsRunning = false;
            Object object = this.objLock;
            synchronized (object) {
                this.objLock.notify();
            }
            this.thrd = null;
        }
    }

    private void init() {
        if (this.frm == null) {
            this.frm = new Frame();
            this.blnOwnFrame = true;
        }
        this.win = new Window(this.frm);
        this.ip = new ImagePanelWithText();
        this.ip.setDrawFrame(true);
        this.objLock = new Object();
        this.thrd = new Thread((Runnable)this, "SplashPanelGFX");
        this.lngDelay = 0L;
        this.lngRes = 500L;
    }

    public void run() {
        long l = 0L;
        this.blnIsRunning = true;
        while (this.blnIsRunning && (this.lngDelay == 0L || l < this.lngDelay)) {
            if (this.win != null && this.win.isVisible()) {
                this.win.toFront();
            }
            try {
                Object object = this.objLock;
                synchronized (object) {
                    this.objLock.wait(this.lngRes);
                }
            }
            catch (InterruptedException interruptedException) {}
            l += this.lngRes;
        }
        this.dispose();
    }

    public void setDelay(long l) {
        this.lngDelay = l;
    }

    public void setInfoMessage(String string, int n) {
        this.ip.setInfoMessage(string, n);
    }

    public void setInfoMessage(String string, int n, Font font) {
        this.ip.setInfoMessage(string, n, font);
    }

    public void setInfoMessage(String string, int n, Font font, Color color) {
        this.ip.setInfoMessage(string, n, font, color);
    }

    public void setPicture(File file) {
        this.ip.setPicture(file);
    }

    public void setPicture(InputStream inputStream) {
        this.ip.setPicture(inputStream);
    }

    public void setPicture(String string) {
        this.ip.setPicture(string);
    }

    public void setPicture(URL uRL) {
        this.ip.setPicture(uRL);
    }

    public void start() {
        ((Component)this.win).setVisible(true);
        Dimension dimension = this.ip.getPictureSize();
        if (dimension.width == 0 && dimension.height == 0) {
            this.dispose();
            return;
        }
        if (!this.blnOwnFrame) {
            int n = this.frm.getSize().width;
            int n2 = this.frm.getSize().height;
            ((Component)this.win).setLocation(n / 2 - dimension.width / 2 + this.frm.getLocationOnScreen().x, n2 / 2 - dimension.height / 2 + this.frm.getLocationOnScreen().y);
        } else {
            int n = Toolkit.getDefaultToolkit().getScreenSize().width;
            int n3 = Toolkit.getDefaultToolkit().getScreenSize().height;
            ((Component)this.win).setLocation(n / 2 - dimension.width / 2, n3 / 2 - dimension.height / 2);
        }
        this.win.add(this.ip);
        this.ip.setSize(dimension);
        ((Component)this.win).setSize(dimension);
        this.win.toFront();
        this.thrd.start();
    }
}

