/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.gfx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class ImagePanel
extends Panel
implements Runnable {
    private MediaTracker mtr = null;
    protected Image imgOrginal = null;
    protected Image imgScaled = null;
    private byte[] bytOrginal = null;
    private Thread thrd = null;
    private String strStatusMessage = "";
    private boolean blnHasError = false;
    private boolean blnImgLoaded = false;
    private boolean blnDrawFrame = false;
    private static final String MSG_LOAD_ERROR = "Ladefehler";
    private static final String MSG_LOADING = "Lade Bild";

    public ImagePanel() {
        this.init();
    }

    public void clearImage() {
        if (this.imgOrginal != null) {
            this.imgOrginal.flush();
            this.imgOrginal = null;
        }
        if (this.imgScaled != null) {
            this.imgScaled.flush();
            this.imgScaled = null;
        }
        this.repaint();
    }

    private void componentHandler(ComponentEvent componentEvent) {
        switch (componentEvent.getID()) {
            case 101: 
            case 102: {
                this.rescale();
            }
        }
    }

    public void dispose() {
        if (this.mtr == null) {
            return;
        }
        if (this.thrd != null) {
            MediaTracker mediaTracker = this.mtr;
            synchronized (mediaTracker) {
                this.mtr.notify();
            }
        }
        if (this.imgOrginal != null) {
            this.mtr.removeImage(this.imgOrginal);
            this.imgOrginal.flush();
            this.imgOrginal = null;
        }
        if (this.imgScaled != null) {
            this.imgScaled.flush();
            this.imgScaled = null;
        }
        this.bytOrginal = null;
    }

    public byte[] getPicture() {
        while (this.thrd != null) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.bytOrginal == null ? new byte[]{} : this.bytOrginal;
    }

    public Dimension getPictureSize() {
        try {
            while (!this.blnImgLoaded) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {}
        if (this.blnHasError) {
            return new Dimension(0, 0);
        }
        return new Dimension(this.imgOrginal.getWidth(this), this.imgOrginal.getHeight(this));
    }

    private void init() {
        this.mtr = new MediaTracker(this);
        this.addComponentListener(new ComponentAdapter(this){
            /* synthetic */ ImagePanel this$0;

            public void componentShown(ComponentEvent componentEvent) {
                ImagePanel.access$componentHandler(this.this$0, componentEvent);
            }

            public void componentResized(ComponentEvent componentEvent) {
                ImagePanel.access$componentHandler(this.this$0, componentEvent);
            }
            {
                this.this$0 = imagePanel;
            }
        });
    }

    private void loadImage(byte[] byArray) {
        if (byArray == null) {
            this.setStatusMessage(null);
            return;
        }
        this.setStatusMessage(MSG_LOADING);
        this.dispose();
        this.bytOrginal = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.bytOrginal, 0, byArray.length);
        this.imgOrginal = Toolkit.getDefaultToolkit().createImage(this.bytOrginal);
        this.mtr.addImage(this.imgOrginal, 0);
        this.thrd = new Thread((Runnable)this, "ImageFetcher");
        this.thrd.setPriority(10);
        this.thrd.start();
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame();
        ((Component)frame).setSize(100, 100);
        ImagePanel imagePanel = new ImagePanel();
        frame.add(imagePanel);
        ((Component)frame).setVisible(true);
        System.out.println("add");
        imagePanel.setPicture("c:\\9\\toaster6.gif");
        System.out.println("end");
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.strStatusMessage != null) {
            graphics.setFont(new Font("dialog", 1, 14));
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = 0;
            int n2 = 0;
            if (fontMetrics != null) {
                n = fontMetrics.stringWidth(this.strStatusMessage);
                n2 = fontMetrics.getHeight();
            }
            graphics.drawString(this.strStatusMessage, this.getSize().width / 2 - n / 2, this.getSize().height / 2 - n2 / 2);
            if (this.blnDrawFrame) {
                graphics.draw3DRect(0, 0, this.getSize().width, this.getSize().height, true);
            }
            return;
        }
        if (this.imgScaled != null) {
            try {
                graphics.drawImage(this.imgScaled, 0, 0, this.imgScaled.getWidth(this), this.imgScaled.getHeight(this), this);
            }
            catch (Exception exception) {}
            if (this.blnDrawFrame) {
                graphics.drawRect(0, 0, this.imgScaled.getWidth(this) - 1, this.imgScaled.getHeight(this) - 1);
            }
            return;
        }
    }

    protected void rescale() {
        if (this.imgOrginal == null) {
            return;
        }
        if (this.imgScaled != null) {
            this.imgScaled.flush();
        }
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = this.imgOrginal.getWidth(this);
        int n4 = this.imgOrginal.getHeight(this);
        if (n3 < 1 || n4 < 1 || n < 1 || n2 < 1) {
            return;
        }
        double d = (double)n / (double)n3;
        double d2 = (double)n2 / (double)n4;
        int n5 = n4;
        int n6 = n4;
        if (d > d2) {
            n5 = n3 * n2 / n4;
            n6 = n2;
        }
        if (d < d2) {
            n5 = n;
            n6 = -n4 * n / n3;
        }
        if (d == d2) {
            n5 = n;
            n6 = n2;
        }
        this.imgScaled = this.imgOrginal.getScaledInstance(n5, n6, 2);
    }

    public void run() {
        this.blnHasError = false;
        try {
            this.mtr.waitForID(0, 60000L);
            this.blnImgLoaded = true;
            this.blnHasError = this.mtr.isErrorID(0);
            this.mtr.removeImage(this.imgOrginal, 0);
            this.rescale();
            this.setStatusMessage(this.blnHasError ? "?" : null);
        }
        catch (InterruptedException interruptedException) {}
        this.thrd = null;
    }

    public void setDrawFrame(boolean bl) {
        this.blnDrawFrame = bl;
    }

    public void setPicture(File file) {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            this.setPicture(fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            this.blnHasError = true;
            this.setStatusMessage(MSG_LOAD_ERROR);
            this.repaint();
        }
    }

    public void setPicture(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        byte[] byArray = new byte[1024];
        int n = 0;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            this.loadImage(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            this.blnHasError = true;
            this.setStatusMessage(MSG_LOAD_ERROR);
        }
    }

    public void setPicture(String string) {
        this.setPicture(new File(string));
    }

    public void setPicture(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            this.setPicture(inputStream);
            inputStream.close();
        }
        catch (IOException iOException) {
            this.blnHasError = true;
            this.setStatusMessage(MSG_LOAD_ERROR);
            this.repaint();
        }
    }

    public void setPicture(byte[] byArray) {
        this.loadImage(byArray);
    }

    public void setStatusMessage(String string) {
        this.strStatusMessage = string;
        this.repaint();
    }

    static void access$componentHandler(ImagePanel imagePanel, ComponentEvent componentEvent) {
        imagePanel.componentHandler(componentEvent);
    }
}

