/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.email;

import de.zwanzigeins.email.EMail;
import de.zwanzigeins.email.MailSendException;
import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperIO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.dns;

public class MailSend {
    private String strDNS = null;
    private OutputStream osSok = null;
    private PrintWriter pwOut = null;
    private BufferedReader brIn = null;
    private String strMXHostUsed = null;
    private String strLastSent = null;
    private String strLastRecv = null;
    private String strSM_Host = null;
    private String strSM_Auth = null;
    private String strSM_User = null;
    private String strSM_Pass = null;
    public static final String AUTH_SMTP_AFTER_POP3 = "AUTH_SMTP_AFTER_POP3";
    public static final String AUTH_PLAIN = "AUTH_PLAIN";
    public static final String AUTH_LOGIN = "AUTH_LOGIN";
    public static final String AUTH_CRAM_MD5 = "AUTH_CRAM_MD5";
    public static final String AUTH_NONE = "AUTH_NONE";

    public MailSend(String string) {
        this.strDNS = string;
    }

    private Socket getAuthConnection() {
        if (this.strSM_Auth.equals(AUTH_SMTP_AFTER_POP3)) {
            Socket socket = null;
            try {
                try {
                    String string = "";
                    socket = new Socket(this.strSM_Host, 110);
                    socket.setSoTimeout(5000);
                    PrintWriter printWriter = new PrintWriter(socket.getOutputStream(), true);
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                    string = bufferedReader.readLine();
                    if (!string.startsWith("+")) {
                        throw new MailSendException("AUTH_SMTP_AFTER_POP3 Server returned error on logon");
                    }
                    printWriter.println("User " + this.strSM_User);
                    string = bufferedReader.readLine();
                    if (!string.startsWith("+")) {
                        throw new MailSendException("AUTH_SMTP_AFTER_POP3 Server returned error on USER [" + string + "]");
                    }
                    printWriter.println("Pass " + this.strSM_Pass);
                    string = bufferedReader.readLine();
                    if (!string.startsWith("+")) {
                        throw new MailSendException("AUTH_SMTP_AFTER_POP3 Server returned error on PASS [" + string + "]");
                    }
                }
                catch (IOException iOException) {
                    throw new MailSendException("AUTH_SMTP_AFTER_POP3 Cannot connect to POP3 server " + this.strSM_Host + " Reason: " + iOException.toString());
                }
            }
            catch (Throwable throwable) {
                Object var2_8 = null;
                HelperIO.close(socket);
                throw throwable;
            }
            Object var2_9 = null;
            HelperIO.close(socket);
            try {
                return new Socket(this.strSM_Host, 25);
            }
            catch (IOException iOException) {
                throw new MailSendException("AUTH_SMTP_AFTER_POP3 Cannot connect to SMTP server " + this.strSM_Host + " Reason: " + iOException.toString());
            }
        }
        if (this.strSM_Auth.equals(AUTH_NONE)) {
            try {
                return new Socket(this.strSM_Host, 25);
            }
            catch (IOException iOException) {
                throw new MailSendException("AUTH_NONE Cannot connect to SMTP server " + this.strSM_Host + " Reason: " + iOException.toString());
            }
        }
        throw new MailSendException("Unsupported smarthost auth " + this.strSM_Auth);
    }

    public String getLastReceived() {
        return this.strLastRecv;
    }

    public String getLastSent() {
        return this.strLastSent;
    }

    private Socket getMXConnection(String string) {
        String[] stringArray = this.getMXHosts(string);
        if (stringArray == null) {
            throw new MailSendException("Cannot find an MX server for " + string);
        }
        InetAddress inetAddress = null;
        int n = 0;
        while (n < stringArray.length) {
            try {
                Socket socket = new Socket(stringArray[n], 25, inetAddress, 0);
                socket.setSoTimeout(30000);
                return socket;
            }
            catch (IOException iOException) {
                ++n;
            }
        }
        throw new MailSendException("Cannot connect to any MX server for domain " + string);
    }

    private String[] getMXHosts(String string) {
        Object object;
        int n;
        ((Hashtable)System.getProperties()).put("dns.server", this.strDNS);
        Record[] recordArray = null;
        int n2 = 0;
        while (n2 < 5) {
            recordArray = dns.getRecords((String)string, (short)15);
            if (recordArray == null) {
                recordArray = dns.getRecords((String)string, (short)1);
            }
            if (recordArray != null) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            ++n2;
        }
        if (recordArray == null) {
            return null;
        }
        if (recordArray[0] instanceof MXRecord && recordArray.length > 0) {
            do {
                n2 = 0;
                n = 0;
                while (n < recordArray.length - 1) {
                    object = (MXRecord)recordArray[n];
                    MXRecord mXRecord = (MXRecord)recordArray[n + 1];
                    if (object.getPriority() > mXRecord.getPriority()) {
                        recordArray[n] = mXRecord;
                        recordArray[n + 1] = object;
                        n2 = 1;
                    }
                    ++n;
                }
            } while (n2 != 0);
        }
        String[] stringArray = new String[recordArray.length];
        n = 0;
        while (n < recordArray.length) {
            object = recordArray[n] instanceof MXRecord ? ((MXRecord)recordArray[n]).getTarget().toString() : ((ARecord)recordArray[n]).getName().toString();
            if (((String)object).endsWith(".")) {
                object = ((String)object).substring(0, ((String)object).length() - 1);
            }
            stringArray[n] = object;
            ++n;
        }
        return stringArray;
    }

    public static void main(String[] stringArray) throws IOException {
        EMail eMail = new EMail();
        eMail.setMailFrom("hohmann@harddiskcafe.de");
        eMail.addRecipient("hohmann@harddiskcafe.de");
        eMail.addRecipient("bernd.hohmann@zwanzigeins.de");
        eMail.setSubject("Testmail mit Umlauten \u00e4\u00f6\u00fc \u00c4\u00d6\u00dc \u00df");
        eMail.addContent("Das ist eine Testmail \u00e4\u00f6\u00fc \u00c4\u00d6\u00dc \u00df");
        MailSend mailSend = new MailSend("80.242.134.170");
        mailSend.setSmartHost("daisy.harddiskcafe.de", AUTH_SMTP_AFTER_POP3, "hohmann@harddiskcafe.de", "bernd");
        mailSend.send(eMail);
        System.out.println("Sent");
    }

    public void send(EMail eMail) throws IOException {
        String[] stringArray = eMail.getSmtpRecipients();
        int n = 0;
        while (n < stringArray.length) {
            Object var6_6;
            String string = HelperExtract.splitUserName_getDomain(stringArray[n]);
            Socket socket = null;
            socket = this.strSM_Host == null ? this.getMXConnection(string) : this.getAuthConnection();
            try {
                this.send0(socket, eMail.getSmtpSender(), stringArray[n], eMail.getMailAsByteArray());
            }
            catch (Throwable throwable) {
                var6_6 = null;
                HelperIO.close(socket);
                HelperIO.close(this.brIn);
                HelperIO.close(this.pwOut);
                throw throwable;
            }
            var6_6 = null;
            HelperIO.close(socket);
            HelperIO.close(this.brIn);
            HelperIO.close(this.pwOut);
            ++n;
        }
    }

    private boolean send0(Socket socket, String string, String string2, byte[] byArray) throws IOException {
        this.osSok = socket.getOutputStream();
        this.pwOut = new PrintWriter(this.osSok, true);
        this.brIn = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        if (!this.waitFor("220")) {
            return false;
        }
        if (!this.sendLine("HELO WORLD")) {
            return false;
        }
        if (!this.sendLine("MAIL FROM: <" + string + ">")) {
            return false;
        }
        if (!this.sendLine("RCPT TO: <" + string2 + ">")) {
            return false;
        }
        if (!this.sendLine("DATA")) {
            return false;
        }
        if (!this.sendLine(byArray)) {
            return false;
        }
        this.sendLine("QUIT");
        return true;
    }

    private boolean sendLine(String string) {
        try {
            this.strLastSent = string;
            this.strLastRecv = "";
            this.pwOut.println(string);
            this.pwOut.flush();
            do {
                this.strLastRecv = string = this.brIn.readLine();
            } while (string.substring(3, 4).equals("-"));
            return string.startsWith("2") || string.startsWith("3");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean sendLine(byte[] byArray) {
        String string = null;
        try {
            this.strLastSent = "<message>";
            this.strLastRecv = "";
            this.osSok.write(byArray);
            this.osSok.flush();
            do {
                this.strLastRecv = string = this.brIn.readLine();
            } while (string.substring(3, 4).equals("-"));
            return string.startsWith("2") || string.startsWith("3");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setSmartHost(String string, String string2, String string3, String string4) {
        this.strSM_Host = string;
        this.strSM_Auth = string2;
        this.strSM_User = string3;
        this.strSM_Pass = string4;
    }

    private boolean waitFor(String string) {
        try {
            String string2;
            this.strLastSent = "";
            do {
                this.strLastRecv = string2 = this.brIn.readLine();
            } while (string2.substring(3, 4).equals("-"));
            return string2.startsWith(string);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

