/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.email;

import de.zwanzigeins.codecs.QuotedPrintableCodec;
import de.zwanzigeins.template.TemplateParser;
import de.zwanzigeins.util.ByteString;
import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperIO;
import de.zwanzigeins.util.VectorString;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class EMail {
    private static final String VERSION = "20/1 EMailObject v1.0";
    protected static final String CRLF = "\r\n";
    protected boolean blnAddBCCToHeader = false;
    protected String strEncoding = null;
    protected StringBuffer strbContent = new StringBuffer();
    protected VectorString svecHeader = new VectorString();
    private String strMailFrom = "";
    private VectorString svecMailTo = new VectorString();
    private VectorString svecMailCC = new VectorString();
    private VectorString svecMailBCC = new VectorString();
    private String strReplyTo = "";
    private String strSubject = "";

    public EMail() throws UnsupportedEncodingException {
        this(false);
    }

    public EMail(String string) throws UnsupportedEncodingException {
        this(string, false);
    }

    public EMail(String string, boolean bl) throws UnsupportedEncodingException {
        this.blnAddBCCToHeader = bl;
        this.strEncoding = string;
        "".getBytes(string);
        this.setHeader("Date", new Date().toString());
        this.setHeader("MIME-Version", "1.0");
        this.setHeader("Content-type", "text/plain; charset=" + string);
        this.setHeader("Content-transfer-encoding", "8bit");
        this.setHeader("Priority", "Normal");
        this.setHeader("X-Mailer", VERSION);
    }

    public EMail(boolean bl) throws UnsupportedEncodingException {
        this("iso-8859-1", bl);
    }

    public void addContent(String string) {
        if (string.equals(".")) {
            string = "..";
        }
        this.strbContent.append(string);
        if (!string.endsWith(CRLF)) {
            this.strbContent.append(CRLF);
        }
    }

    public void addRecipient(String string) {
        if ((string = string.trim()).length() > 0) {
            this.svecMailTo.addElement(string);
        }
    }

    public void addRecipientBCC(String string) {
        if ((string = string.trim()).length() > 0) {
            this.svecMailBCC.addElement(string);
        }
    }

    public void addRecipientCC(String string) {
        if ((string = string.trim()).length() > 0) {
            this.svecMailCC.addElement(string);
        }
    }

    private String extractSmtpUser(String string) {
        int n = string.lastIndexOf(60) + 1;
        int n2 = string.indexOf(62, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        if (n == n2) {
            return "";
        }
        return string.substring(n, n2);
    }

    private ByteString generateMail() {
        int n;
        ByteString byteString = new ByteString(this.strbContent.length() + 1024);
        byteString.append("From: " + this.strMailFrom + CRLF);
        if (this.svecMailTo.size() > 0) {
            byteString.append("To: ");
            n = 0;
            while (n < this.svecMailTo.size()) {
                byteString.append(String.valueOf(this.svecMailTo.elementAt(n)) + ", ");
                ++n;
            }
            byteString.setLength(byteString.getLength() - 2);
            byteString.append(CRLF);
        }
        if (this.svecMailCC.size() > 0) {
            byteString.append("CC: ");
            n = 0;
            while (n < this.svecMailCC.size()) {
                byteString.append(String.valueOf(this.svecMailCC.elementAt(n)) + ", ");
                ++n;
            }
            byteString.setLength(byteString.getLength() - 2);
            byteString.append(CRLF);
        }
        if (this.svecMailBCC.size() > 0 && this.blnAddBCCToHeader) {
            byteString.append("BCC: ");
            n = 0;
            while (n < this.svecMailBCC.size()) {
                byteString.append(String.valueOf(this.svecMailBCC.elementAt(n)) + ", ");
                ++n;
            }
            byteString.setLength(byteString.getLength() - 2);
            byteString.append(CRLF);
        }
        if (this.strReplyTo.length() != 0) {
            byteString.append("Reply-To: " + this.strReplyTo + CRLF);
        }
        n = 0;
        while (n < this.svecHeader.size()) {
            byteString.append(this.svecHeader.elementAt(n));
            byteString.append(CRLF);
            ++n;
        }
        byteString.append("Subject: ");
        if (this.strSubject.length() > 0) {
            QuotedPrintableCodec quotedPrintableCodec = new QuotedPrintableCodec();
            try {
                byteString.append("=?" + this.strEncoding + "?q?" + quotedPrintableCodec.encode(this.strSubject.getBytes(this.strEncoding)) + "?=", this.strEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            byteString.append(CRLF);
        }
        byteString.append(CRLF);
        try {
            byteString.append(this.strbContent.toString(), this.strEncoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        byteString.append(".");
        byteString.append(CRLF);
        return byteString;
    }

    public String getEncoding() {
        return this.strEncoding;
    }

    private int getHeaderIdx(String string) {
        string = String.valueOf(string) + ":";
        string = string.toLowerCase();
        int n = 0;
        while (n < this.svecHeader.size()) {
            if (this.svecHeader.elementAt(n).toLowerCase().startsWith(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public byte[] getMailAsByteArray() {
        return this.generateMail().toByteArray();
    }

    public void getMailAsFile(File file) throws IOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            ByteString byteString = this.generateMail();
            fileOutputStream.write(byteString.getInternalByteArray(), 0, byteString.getLength());
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            HelperIO.close(fileOutputStream);
            throw throwable;
        }
        Object var3_7 = null;
        HelperIO.close(fileOutputStream);
    }

    public OutputStream getMailAsStream() throws IOException {
        ByteString byteString = this.generateMail();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byteString.getLength());
        byteArrayOutputStream.write(byteString.getInternalByteArray(), 0, byteString.getLength());
        return byteArrayOutputStream;
    }

    public String[] getSmtpRecipients() {
        VectorString vectorString = new VectorString(this.svecMailTo.size() + this.svecMailCC.size() + this.svecMailBCC.size());
        int n = 0;
        while (n < this.svecMailTo.size()) {
            vectorString.addElement(this.svecMailTo.elementAt(n));
            ++n;
        }
        n = 0;
        while (n < this.svecMailCC.size()) {
            vectorString.addElement(this.svecMailCC.elementAt(n));
            ++n;
        }
        n = 0;
        while (n < this.svecMailBCC.size()) {
            vectorString.addElement(this.svecMailBCC.elementAt(n));
            ++n;
        }
        n = 0;
        while (n < vectorString.size()) {
            String string = vectorString.elementAt(n);
            if ((string = this.extractSmtpUser(string)).length() == 0) {
                vectorString.removeElementAt(n);
                --n;
            } else {
                vectorString.setElementAt(string, n);
            }
            ++n;
        }
        String[] stringArray = new String[vectorString.size()];
        vectorString.copyInto(stringArray);
        return stringArray;
    }

    public String getSmtpSender() {
        return this.extractSmtpUser(this.strMailFrom);
    }

    public static void main(String[] stringArray) throws Throwable {
        String[] stringArray2 = HelperExtract.getRFC822_Recipients("\"Bernd Hohmann\" <hohmann@harddiskcafe.de>, \"Claudia Bennek\" <bennek@mmdeutschland.de>");
        int n = 0;
        while (n < stringArray2.length) {
            System.out.println(stringArray2[n]);
            ++n;
        }
        EMail eMail = new EMail(true);
        eMail.setMailFrom("\"Bernd Hohmann\" <bernd.hohmann@zwanzigeins.de>");
        eMail.addRecipient("\"Bernd Hohmann\" <hohmann@harddiskcafe.de>");
        eMail.addRecipient("\"Claudia Bennek\" <bennek@mmdeutschland.de>");
        String string = "Der Datenimport der Shopdaten wurde beendet.\n\nBen\u00f6tigte Zeit: [%duration%]\nEingabedatei  : [%inputfile%]";
        TemplateParser templateParser = new TemplateParser();
        templateParser.setVar("duration", "100sek");
        templateParser.setVar("inputfile", "c:\\test");
        eMail.setContent(templateParser.process(string));
        System.out.println(new String(eMail.getMailAsByteArray(), eMail.getEncoding()));
        eMail.getMailAsFile(new File("C:/mail.out"));
    }

    public void setContent(String string) {
        this.strbContent.setLength(0);
        StringReader stringReader = new StringReader(string);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        String string2 = null;
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                this.addContent(string2);
            }
        }
        catch (IOException iOException) {}
    }

    public void setHeader(String string, String string2) {
        int n = this.getHeaderIdx(string);
        if (n == -1) {
            this.svecHeader.addElement(String.valueOf(string) + ": " + string2);
        } else {
            this.svecHeader.setElementAt(String.valueOf(string) + ": " + string2, n);
        }
    }

    public void setMailFrom(String string) {
        this.strMailFrom = string;
    }

    public void setReplyTo(String string) {
        this.strReplyTo = string;
    }

    public void setSubject(String string) {
        this.strSubject = string;
    }
}

