/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.codecs;

import de.zwanzigeins.codecs.TextCodec;
import java.util.BitSet;

public class QuotedPrintableCodec
extends TextCodec {
    private static final BitSet PRINTABLE_CHARS = new BitSet(256);
    private static char ESCAPE_CHAR = (char)61;
    private static char TAB = (char)9;
    private static char SPACE = (char)32;

    static {
        int n = 33;
        while (n <= 60) {
            PRINTABLE_CHARS.set(n);
            ++n;
        }
        n = 62;
        while (n <= 126) {
            PRINTABLE_CHARS.set(n);
            ++n;
        }
        PRINTABLE_CHARS.set(TAB);
        PRINTABLE_CHARS.set(SPACE);
    }

    public String decode(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c != ESCAPE_CHAR) {
                stringBuffer.append(c);
            } else {
                try {
                    int n2 = Character.digit(cArray[++n], 16);
                    int n3 = Character.digit(cArray[++n], 16);
                    if (n2 == -1 || n3 == -1) break;
                    stringBuffer.append((char)((n2 << 4) + n3));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break;
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String encode(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (PRINTABLE_CHARS.get(c)) {
                stringBuffer.append(c);
            } else {
                stringBuffer.append(ESCAPE_CHAR);
                stringBuffer.append(Character.toUpperCase(Character.forDigit(c >> 4 & 0xF, 16)));
                stringBuffer.append(Character.toUpperCase(Character.forDigit(c & 0xF, 16)));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
    }
}

