/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.classloader;

import de.zwanzigeins.classloader.ClassPathEntry;
import de.zwanzigeins.util.ByteString;
import de.zwanzigeins.util.LogContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ExtendedClassLoader
extends ClassLoader {
    private static final String CLASSPATH_SEPARATOR = ";";
    private Vector vecClassPath = null;
    private Hashtable hshClassCache = null;
    private LogContext log = null;
    private String strLogPrefix = "";

    public ExtendedClassLoader(String string, String string2, LogContext logContext) {
        this.log = logContext;
        this.strLogPrefix = string2;
        this.init0(string);
    }

    private Vector appendClassPath(String string) {
        Vector vector = (Vector)this.vecClassPath.clone();
        if (string.length() > 0) {
            if (!(string = this.platformPath(string)).endsWith(File.separator)) {
                string = String.valueOf(string) + File.separator;
            }
            ClassPathEntry classPathEntry = new ClassPathEntry();
            classPathEntry.strPath = string;
            classPathEntry.blnIsArchive = false;
            vector.insertElementAt(classPathEntry, 0);
        }
        return vector;
    }

    public boolean classLoaded(String string) {
        return this.hshClassCache.containsKey(string);
    }

    private void close(Object object) {
        try {
            if (object instanceof InputStream) {
                ((InputStream)object).close();
                return;
            }
            if (object instanceof OutputStream) {
                ((OutputStream)object).close();
                return;
            }
            if (object instanceof Writer) {
                ((Writer)object).close();
                return;
            }
            if (object instanceof Reader) {
                ((Reader)object).close();
                return;
            }
            if (object instanceof ZipFile) {
                ((ZipFile)object).close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public void dispose() {
        this.log("Disposing Classloader");
        if (this.vecClassPath != null) {
            int n = 0;
            while (n < this.vecClassPath.size()) {
                ClassPathEntry classPathEntry = (ClassPathEntry)this.vecClassPath.elementAt(n);
                if (classPathEntry.zf != null) {
                    this.close(classPathEntry.zf);
                }
                ++n;
            }
            this.vecClassPath.removeAllElements();
            this.vecClassPath = null;
        }
        if (this.hshClassCache != null) {
            this.hshClassCache.clear();
            this.hshClassCache = null;
        }
    }

    private String getDirectory(String string) {
        if (string.length() == 0) {
            return string;
        }
        string = string.replace('\\', File.separatorChar);
        string = string.replace('/', File.separatorChar);
        File file = null;
        int n = 0;
        while (n < 2) {
            if (!string.endsWith(File.separator)) {
                string = String.valueOf(string) + File.separator;
            }
            if ((file = new File(string)).isDirectory()) {
                return string;
            }
            int n2 = (string = string.substring(0, string.length() - 1)).lastIndexOf(File.separator);
            if (n2 == -1) {
                return "";
            }
            string = string.substring(0, n2);
            ++n;
        }
        return null;
    }

    public URL getResource(String string) {
        return this.getResource(string, "");
    }

    public URL getResource(String string, String string2) {
        if ((string = this.platformPath(string)).startsWith(File.separator)) {
            string = string.substring(1);
        }
        URL uRL = null;
        uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            return uRL;
        }
        Vector vector = this.appendClassPath(string2);
        int n = 0;
        while (n < vector.size()) {
            ClassPathEntry classPathEntry = (ClassPathEntry)vector.elementAt(n);
            if (classPathEntry.blnIsArchive) {
                Object var8_9;
                ZipFile zipFile = null;
                try {
                    try {
                        zipFile = new ZipFile(new File(classPathEntry.strPath));
                        ZipEntry zipEntry = zipFile.getEntry(string);
                        if (zipEntry != null) {
                            uRL = new URL("jar:" + classPathEntry.strPath + "!/" + string);
                        }
                    }
                    catch (ZipException zipException) {
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.log("Bad URL", malformedURLException);
                    }
                    catch (IOException iOException) {}
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    this.close(zipFile);
                    throw throwable;
                }
                var8_9 = null;
                this.close(zipFile);
            } else {
                try {
                    uRL = new URL("file:" + classPathEntry.strPath + string);
                }
                catch (MalformedURLException malformedURLException) {
                    this.log("Bad URL", malformedURLException);
                }
            }
            ++n;
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        return this.getResourceAsStream(string, "");
    }

    public InputStream getResourceAsStream(String string, String string2) {
        if ((string = this.platformPath(string)).startsWith(File.separator)) {
            string = string.substring(1);
        }
        InputStream inputStream = null;
        inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        Vector vector = this.appendClassPath(string2);
        int n = 0;
        while (n < vector.size()) {
            ClassPathEntry classPathEntry = (ClassPathEntry)vector.elementAt(n);
            if (classPathEntry.blnIsArchive) {
                ZipFile zipFile = null;
                try {
                    classPathEntry.zf = zipFile = new ZipFile(new File(classPathEntry.strPath));
                    ZipEntry zipEntry = zipFile.getEntry(string);
                    if (zipEntry != null) {
                        inputStream = zipFile.getInputStream(zipEntry);
                    }
                }
                catch (Exception exception) {
                    this.close(inputStream);
                    this.close(zipFile);
                }
            } else {
                try {
                    inputStream = new FileInputStream(new File(classPathEntry.strPath, string));
                }
                catch (IOException iOException) {
                    this.close(inputStream);
                }
            }
            if (inputStream != null) break;
            ++n;
        }
        return inputStream;
    }

    private void init0(String string) {
        Object object;
        Object object2;
        ClassPathEntry classPathEntry;
        if (!string.endsWith(CLASSPATH_SEPARATOR)) {
            string = String.valueOf(string) + CLASSPATH_SEPARATOR;
        }
        this.vecClassPath = new Vector(1, 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, CLASSPATH_SEPARATOR);
        while (stringTokenizer.hasMoreTokens()) {
            classPathEntry = new ClassPathEntry();
            object2 = stringTokenizer.nextToken();
            object = this.getDirectory((String)object2);
            if (object == null) {
                this.log("Classpath " + (String)object2 + " isn't a valid directory or file, ignored");
                continue;
            }
            classPathEntry.strPath = object2;
            classPathEntry.blnIsArchive = false;
            this.vecClassPath.addElement(classPathEntry);
        }
        if (this.vecClassPath.size() == 0) {
            classPathEntry = new ClassPathEntry();
            classPathEntry.strPath = ".";
            classPathEntry.blnIsArchive = false;
            this.vecClassPath.addElement(classPathEntry);
        }
        int n = 0;
        while (n < this.vecClassPath.size()) {
            object2 = (ClassPathEntry)this.vecClassPath.elementAt(n);
            object = new File(((ClassPathEntry)object2).strPath);
            if (!((File)object).exists()) {
                this.log(String.valueOf(((File)object).getPath()) + " is not a valid file/directory");
            } else if (!((File)object).canRead()) {
                this.log.write("? " + ((File)object).getPath() + " is not readable");
            } else {
                if (((File)object).isFile()) {
                    try {
                        ZipFile zipFile = new ZipFile((File)object);
                        zipFile.close();
                        ((ClassPathEntry)object2).blnIsArchive = true;
                    }
                    catch (Throwable throwable) {
                        ((ClassPathEntry)object2).blnIsArchive = false;
                    }
                }
                this.log("Added " + ((ClassPathEntry)object2).toString() + " to container classpath");
            }
            ++n;
        }
        this.hshClassCache = new Hashtable();
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = (Class)this.hshClassCache.get(string);
        if (clazz != null) {
            this.log("Loaded " + string + " from cache");
        }
        if (clazz == null) {
            int n = 0;
            while (n < this.vecClassPath.size()) {
                ClassPathEntry classPathEntry = (ClassPathEntry)this.vecClassPath.elementAt(n);
                clazz = classPathEntry.blnIsArchive ? this.loadFromZip(string, classPathEntry.strPath) : this.loadFromFile(string, classPathEntry.strPath);
                if (clazz != null) {
                    this.log("Loaded " + string + " from containerpath");
                    break;
                }
                ++n;
            }
        }
        if (clazz == null) {
            try {
                clazz = this.findSystemClass(string);
            }
            catch (Throwable throwable) {
                clazz = null;
            }
            if (clazz != null) {
                this.log("Loaded " + string + " from systempath");
            }
        }
        if (clazz == null) {
            this.hshClassCache.remove(string);
            this.log("Cannot find class " + string);
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        this.hshClassCache.put(string, clazz);
        return clazz;
    }

    private Class loadFromFile(String string, String string2) {
        String string3 = string.replace('.', File.separatorChar);
        string3 = String.valueOf(string3) + ".class";
        while (!Character.isJavaIdentifierStart(string3.charAt(0))) {
            string3 = string3.substring(1);
        }
        FileInputStream fileInputStream = null;
        Class clazz = null;
        try {
            try {
                fileInputStream = new FileInputStream(new File(string2, string3));
                clazz = this.loadFromStream(string, fileInputStream);
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.close(fileInputStream);
            throw throwable;
        }
        Object var6_8 = null;
        this.close(fileInputStream);
        return clazz;
    }

    private Class loadFromStream(String string, InputStream inputStream) {
        ByteString byteString = new ByteString(8192);
        byte[] byArray = new byte[512];
        int n = -1;
        try {
            while ((n = inputStream.read(byArray)) != -1) {
                byteString.append(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (byteString.getLength() == 0) {
            return null;
        }
        return this.defineClass(string, byteString.getInternalByteArray(), 0, byteString.getLength());
    }

    private Class loadFromZip(String string, String string2) {
        String string3 = string.replace('.', '/');
        string3 = String.valueOf(string3) + ".class";
        ZipFile zipFile = null;
        InputStream inputStream = null;
        Class clazz = null;
        try {
            try {
                zipFile = new ZipFile(new File(string2));
                ZipEntry zipEntry = zipFile.getEntry(string3);
                if (zipEntry != null) {
                    inputStream = zipFile.getInputStream(zipEntry);
                    clazz = this.loadFromStream(string, inputStream);
                }
            }
            catch (ZipException zipException) {
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.close(inputStream);
            this.close(zipFile);
            throw throwable;
        }
        Object var7_10 = null;
        this.close(inputStream);
        this.close(zipFile);
        return clazz;
    }

    private void log(String string) {
        if (this.log == null) {
            return;
        }
        this.log.write(String.valueOf(this.strLogPrefix) + " " + string);
    }

    private void log(String string, Throwable throwable) {
        if (this.log == null) {
            return;
        }
        this.log.write(String.valueOf(this.strLogPrefix) + " " + string, throwable);
    }

    private String platformPath(String string) {
        if (string == null) {
            return null;
        }
        string = string.replace('\\', File.separatorChar);
        string = string.replace('/', File.separatorChar);
        return string;
    }

    public void setLogContext(LogContext logContext) {
        this.log = logContext;
    }
}

