/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.cache;

import de.zwanzigeins.cache.PrecomputedFileContentProducer;
import de.zwanzigeins.util.HelperIO;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.LogContext;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PrecomputedFileContentCache {
    private MessageDigest mdCacheName = null;
    private LogContext log = null;
    private int intCopyBufferSize = 0;
    private boolean blnDebug = false;
    private final long CACHEFILE_INVALID_SIZE = -1L;
    private DataInputStream disContent = null;
    private long lngContentLength = -1L;

    public PrecomputedFileContentCache() {
        this(null, 8192, false);
    }

    public PrecomputedFileContentCache(LogContext logContext) {
        this(logContext, 8192, false);
    }

    public PrecomputedFileContentCache(LogContext logContext, int n, boolean bl) {
        this.log = logContext;
        this.blnDebug = bl;
        this.intCopyBufferSize = n;
        try {
            this.mdCacheName = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("No MessageDigest: SHA");
        }
    }

    public void close() {
        if (this.disContent != null) {
            HelperIO.close(this.disContent);
        }
        this.disContent = null;
        this.lngContentLength = 0L;
    }

    public File getCacheFile_URL(String string, String string2) {
        String string3 = String.valueOf(string) + File.separator + string2;
        if ((string3 = HelperPath.pathFixup(string3, File.separator)).endsWith(File.separator)) {
            string3 = String.valueOf(string3) + "#root";
        }
        return new File(string3);
    }

    public InputStream getContent(File file, File file2, PrecomputedFileContentProducer precomputedFileContentProducer) {
        block18: {
            if (this.blnDebug) {
                this.log("D Sending GZIP/DSK " + file.getPath());
            }
            int n = 10;
            while (true) {
                boolean bl;
                if (n == 0) {
                    this.log("? Retries for building cache exhausted, abort");
                    return null;
                }
                long l = -1L;
                boolean bl2 = bl = file2.exists() && file2.length() > 32L;
                if (bl) {
                    RandomAccessFile randomAccessFile = null;
                    try {
                        randomAccessFile = new RandomAccessFile(file2, "r");
                        l = randomAccessFile.readLong();
                        bl &= randomAccessFile.readLong() == file.length();
                        bl &= randomAccessFile.readLong() == file.lastModified();
                    }
                    catch (IOException iOException) {
                        this.log("? Error reading cache header", iOException);
                        bl = false;
                    }
                    HelperIO.close(randomAccessFile);
                    if (l == -1L || l != file2.length()) {
                        this.wait_ms(150L);
                        if (!this.blnDebug) continue;
                        this.log("D PrecomputetFileContentCache under rebuild");
                        continue;
                    }
                }
                if (bl) break block18;
                if (!HelperIO.fileLock(file2.getPath())) {
                    if (this.blnDebug) {
                        this.log("D Waiting for lock release on " + file2.getPath());
                    }
                    this.wait_ms(150L);
                    --n;
                    continue;
                }
                int n2 = file2.getPath().lastIndexOf(File.separator);
                if (n2 == -1) {
                    this.log("? No slash in cachefilepath: " + file2.getPath());
                    return null;
                }
                String string = file2.getPath().substring(0, n2);
                string = HelperPath.removeTrailingSlashes(string);
                new File(string).mkdirs();
                DataOutputStream dataOutputStream = null;
                RandomAccessFile randomAccessFile = null;
                FileInputStream fileInputStream = null;
                try {
                    if (this.blnDebug) {
                        this.log("D Building cache file " + file2.getPath());
                    }
                    dataOutputStream = new DataOutputStream(new FileOutputStream(file2));
                    dataOutputStream.writeLong(-1L);
                    dataOutputStream.writeLong(-1L);
                    dataOutputStream.writeLong(-1L);
                    fileInputStream = new FileInputStream(file);
                    long l2 = precomputedFileContentProducer.produce(fileInputStream, dataOutputStream, new byte[this.intCopyBufferSize]);
                    HelperIO.close(fileInputStream);
                    HelperIO.close(dataOutputStream);
                    if (this.blnDebug) {
                        this.log("D Wrote " + l2 + " bytes to cachefile");
                    }
                    randomAccessFile = new RandomAccessFile(file2, "rw");
                    randomAccessFile.writeLong(file2.length());
                    randomAccessFile.writeLong(file.length());
                    randomAccessFile.writeLong(file.lastModified());
                    HelperIO.close(randomAccessFile);
                    if (!this.blnDebug) break;
                    this.log("D Built cached file " + file2.getPath());
                }
                catch (IOException iOException) {
                    HelperIO.close(fileInputStream);
                    HelperIO.close(dataOutputStream);
                    HelperIO.close(randomAccessFile);
                    if (this.blnDebug) {
                        this.log("D Cannot create cache for " + file2.getPath() + " " + iOException.toString());
                    }
                    file2.delete();
                    HelperIO.fileUnlock(file2.getPath());
                    this.wait_ms(150L);
                    --n;
                    continue;
                }
                break;
            }
            HelperIO.fileUnlock(file2.getPath());
        }
        try {
            if (this.blnDebug) {
                this.log("D Sending cached file " + file2.getPath());
            }
            this.disContent = new DataInputStream(new FileInputStream(file2));
            this.disContent.readLong();
            this.disContent.readLong();
            this.disContent.readLong();
            this.lngContentLength = file2.length() - 24L;
            return this.disContent;
        }
        catch (IOException iOException) {
            HelperIO.close(this.disContent);
            return null;
        }
    }

    public long getContentLength() {
        return this.lngContentLength;
    }

    private void log(String string) {
        if (this.log == null) {
            return;
        }
        this.log.write(string);
    }

    private void log(String string, Throwable throwable) {
        if (this.log == null) {
            return;
        }
        this.log.write(string, throwable);
    }

    private void wait_ms(long l) {
        try {
            PrecomputedFileContentCache precomputedFileContentCache = this;
            synchronized (precomputedFileContentCache) {
                this.wait(l);
            }
        }
        catch (InterruptedException interruptedException) {}
    }
}

