/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.cache;

import de.zwanzigeins.cache.PrecomputedFileContentProducer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashedFileContentProducer
extends PrecomputedFileContentProducer {
    private String strAlgorithm = null;

    public HashedFileContentProducer() {
        this("MD5");
    }

    public HashedFileContentProducer(String string) {
        this.strAlgorithm = string;
    }

    public long produce(InputStream inputStream, OutputStream outputStream, byte[] byArray) throws IOException {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(this.strAlgorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new IOException("No such MessageDigest: MD5");
        }
        int n = 0;
        long l = 0L;
        while ((n = inputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
            l += (long)n;
        }
        outputStream.write(messageDigest.digest());
        outputStream.flush();
        return l;
    }
}

