/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class StructurePanel
extends Panel {
    static final long serialVersionUID = 3720815111234515113L;
    private transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private transient FontMetrics fm = null;
    private transient int intInsets = 0;
    private int intSpacer = 4;
    private String fieldBorderText = new String();
    private Font fieldBorderFont = new Font("dialog", 0, 12);
    private Color fieldBorderColor = Color.lightGray;
    private Color fieldBorderFontColor = Color.black;
    private boolean blnFrameVisible = true;

    public StructurePanel() {
        this.setBackground(SystemColor.activeCaptionBorder);
    }

    public StructurePanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.setBackground(SystemColor.activeCaptionBorder);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChange != null) {
            this.propertyChange.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        if (this.propertyChange != null) {
            this.propertyChange.firePropertyChange(string, object, object2);
        }
    }

    public Color getBorderColor() {
        return this.fieldBorderColor;
    }

    public Font getBorderFont() {
        return this.fieldBorderFont;
    }

    public Color getBorderFontColor() {
        return this.fieldBorderFontColor;
    }

    public String getBorderText() {
        return this.fieldBorderText;
    }

    public Insets getInsets() {
        if (this.fm == null) {
            this.fm = this.getToolkit().getFontMetrics(this.fieldBorderFont);
            if (this.fm == null) {
                this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.fieldBorderFont);
            }
        }
        Insets insets = null;
        if (this.fieldBorderText.length() == 0) {
            this.intInsets = this.intSpacer;
            insets = new Insets(2 * this.intInsets, 2 * this.intInsets, 2 * this.intInsets, 2 * this.intInsets);
        } else {
            this.intInsets = this.intSpacer + this.fm.getHeight() / 4;
            insets = new Insets(2 * this.intInsets, 2 * this.intInsets, 2 * this.intInsets, 2 * this.intInsets);
        }
        return insets;
    }

    public int getSpacer() {
        return this.intSpacer;
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        try {
            this.getInsets();
            Dimension dimension = this.getSize();
            if (this.blnFrameVisible) {
                graphics.setColor(this.fieldBorderColor);
                graphics.draw3DRect(this.intInsets, this.intInsets, dimension.width - 2 * this.intInsets - 1, dimension.height - 2 * this.intInsets - 1, false);
            } else {
                graphics.setColor(this.getBackground());
            }
            if (this.fieldBorderText.length() == 0) {
                return;
            }
            graphics.clearRect(15, this.intInsets, this.fm.stringWidth(this.fieldBorderText) + 10, 1);
            graphics.setFont(this.fieldBorderFont);
            graphics.setColor(this.fieldBorderFontColor);
            graphics.drawString(this.fieldBorderText, 20, this.intInsets + (this.fm.getAscent() + this.fm.getLeading()) / 2);
        }
        catch (Throwable throwable) {
            super.paint(graphics);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChange.removePropertyChangeListener(propertyChangeListener);
    }

    public void setBorderColor(Color color) {
        Color color2 = this.fieldBorderColor;
        this.fieldBorderColor = color;
        this.firePropertyChange("borderColor", color2, color);
        this.repaint();
    }

    public void setBorderFont(Font font) {
        Font font2 = this.fieldBorderFont;
        this.fieldBorderFont = font;
        this.firePropertyChange("borderFont", font2, font);
        this.repaint();
    }

    public void setBorderFontColor(Color color) {
        Color color2 = this.fieldBorderFontColor;
        this.fieldBorderFontColor = color;
        this.firePropertyChange("borderFontColor", color2, color);
        this.repaint();
    }

    public void setBorderText(String string) {
        String string2 = this.fieldBorderText;
        this.fieldBorderText = string;
        this.firePropertyChange("borderText", string2, string);
        this.setSpacer(this.getSpacer());
        this.repaint();
    }

    public void setEnabled(boolean bl) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setEnabled(bl);
            ++n;
        }
        super.setEnabled(bl);
    }

    public void setFrameVisible(boolean bl) {
        this.blnFrameVisible = bl;
    }

    public void setSpacer(int n) {
        this.intSpacer = n;
        this.invalidate();
        this.doLayout();
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
    }
}

