/*
 * Decompiled with CFR 0.152.
 */
package xnap.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.cmdl.AbstractCommand;
import xnap.cmdl.Executer;
import xnap.cmdl.ParameterException;
import xnap.cmdl.SyntaxException;
import xnap.net.ITransferContainer;
import xnap.net.IUpload;
import xnap.net.IUploadContainer;
import xnap.net.IUser;
import xnap.net.SimpleUpload;
import xnap.util.TransferQueue;

public class UploadQueue
extends TransferQueue
implements PropertyChangeListener {
    private static UploadQueue singleton = new UploadQueue();
    private static /* synthetic */ Class class$Lxnap$util$DownloadQueue;

    public static UploadQueue getInstance() {
        return singleton;
    }

    public boolean add(IUpload iUpload) {
        return this.add(new SimpleUpload(iUpload));
    }

    public boolean add(IUploadContainer iUploadContainer) {
        if (!this.isQueued(iUploadContainer) && !this.isRunning(iUploadContainer)) {
            this.logger.debug("add " + iUploadContainer);
            super.add(iUploadContainer);
            if (this.check(iUploadContainer)) {
                return this.enqueue(iUploadContainer, this.isPreferred(iUploadContainer));
            }
        }
        return false;
    }

    public boolean canStart(ITransferContainer iTransferContainer) {
        if (TransferQueue.prefs.getLimitUploadsPerUser()) {
            IUser iUser = iTransferContainer.getUser();
            if (iUser.getMaxUploads() == -1) {
                return iUser.getLocalUploadCount() < TransferQueue.prefs.getMaxUploadsPerUser();
            }
            return iUser.getLocalUploadCount() < iUser.getMaxUploads();
        }
        return true;
    }

    public boolean check(IUploadContainer iUploadContainer) {
        if (iUploadContainer.getUser().getMaxUploads() == 0) {
            iUploadContainer.reject(XNap.tr("User blocked"));
            return false;
        }
        return true;
    }

    public int getLocalQueuePos(IUpload iUpload) {
        return super.getLocalQueuePos(new SimpleUpload(iUpload));
    }

    public boolean isPreferred(IUploadContainer iUploadContainer) {
        return iUploadContainer.getUser().getMaxUploads() == Integer.MAX_VALUE && (!TransferQueue.prefs.getLimitUploadsPerUser() || iUploadContainer.getUser().getLocalUploadCount() < TransferQueue.prefs.getMaxUploadsPerUser()) || iUploadContainer.getUser().getLocalDownloadCount() > iUploadContainer.getUser().getLocalUploadCount();
    }

    public boolean isRunning(IUpload iUpload) {
        return super.isRunning(new SimpleUpload(iUpload));
    }

    public void startUpload(IUploadContainer iUploadContainer) {
        this.startTransfer(iUploadContainer);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.updateLimit();
    }

    protected void updateLimit() {
        this.setMaxTransfers(TransferQueue.prefs.getLimitUploads() ? TransferQueue.prefs.getMaxUploads() : 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private UploadQueue() {
        super("UploadQueue");
        this.logger = Logger.getLogger(class$Lxnap$util$DownloadQueue != null ? class$Lxnap$util$DownloadQueue : (class$Lxnap$util$DownloadQueue = UploadQueue.class$("xnap.util.DownloadQueue")));
        TransferQueue.prefs.addPropertyChangeListener("limitUploads", this);
        TransferQueue.prefs.addPropertyChangeListener("maxUploads", this);
        TransferQueue.prefs.addPropertyChangeListener("limitUploadsPerUser", this);
        TransferQueue.prefs.addPropertyChangeListener("maxUploadsPerUser", this);
        this.updateLimit();
        Executer.addCommand(new ListUlsCmd());
        Executer.addCommand(new AbortUlCmd());
    }

    protected class ListUlsCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            UploadQueue.this.print();
            return true;
        }

        public ListUlsCmd() {
            this.putValue("cmd", new String[]{"listuploads", "lul", "pup"});
            this.putValue("shortHelp", "Shows the upload queue.");
        }
    }

    protected class AbortUlCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) throws SyntaxException, ParameterException {
            if (UploadQueue.this.lastTransfers == null) {
                UploadQueue.this.lastTransfers = UploadQueue.this.getTransfers();
            }
            int n = this.getInt(stringArray, 0, UploadQueue.this.lastTransfers.length - 1);
            UploadQueue.this.abort(UploadQueue.this.lastTransfers[n]);
            return true;
        }

        public AbortUlCmd() {
            this.putValue("cmd", new String[]{"abortupload", "aul"});
            this.putValue("parameter", "id");
            this.putValue("shortHelp", "Aborts an upload.");
        }
    }
}

