/*
 * Decompiled with CFR 0.152.
 */
package xnap.user;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.net.IUser;
import xnap.user.UserData;
import xnap.user.UserData2;
import xnap.util.EventVector;
import xnap.util.FileHelper;

public class UserManager
extends EventVector {
    public static final String USER_REPOSITORY_FILENAME = "users";
    public static final String[] CATEGORIES = new String[]{"", XNap.tr("Hotlist"), XNap.tr("Banned")};
    private static Logger logger = Logger.getLogger(class$Lxnap$user$UserManager != null ? class$Lxnap$user$UserManager : (class$Lxnap$user$UserManager = UserManager.class$("xnap.user.UserManager")));
    private static UserManager singleton = new UserManager();
    private Hashtable usersByName = new Hashtable();
    private static /* synthetic */ Class class$Lxnap$user$UserManager;

    public boolean add(UserData userData) {
        if (userData.parentClass != null) {
            try {
                userData = this.convert(userData);
                Class<?> clazz = Class.forName(userData.parentClass);
                Constructor<?> constructor = clazz.getConstructor(userData.getClass());
                Object obj = constructor.newInstance(userData);
                if (obj instanceof IUser) {
                    this.add((IUser)obj);
                    return true;
                }
            }
            catch (Exception exception) {
                logger.warn("error creating " + userData.parentClass);
            }
        }
        return false;
    }

    public void add(IUser iUser) {
        super.add(iUser);
        this.usersByName.put(iUser.getName(), iUser);
    }

    public static UserManager getInstance() {
        return singleton;
    }

    public IUser get(String string) {
        return (IUser)this.usersByName.get(string);
    }

    public void read() throws IOException {
        LinkedList linkedList = new LinkedList();
        File file = new File(FileHelper.getHomeDir() + USER_REPOSITORY_FILENAME);
        FileHelper.readBinary(file, linkedList);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof UserData)) continue;
            this.add((UserData)e);
        }
    }

    public void write() {
        LinkedList<UserData2> linkedList = new LinkedList<UserData2>();
        Object object = this.iterator();
        while (object.hasNext()) {
            IUser iUser = (IUser)object.next();
            if (iUser.isTemporary()) continue;
            linkedList.add(iUser.getData());
        }
        object = new File(FileHelper.getHomeDir() + USER_REPOSITORY_FILENAME);
        try {
            FileHelper.writeBinary((File)object, linkedList);
        }
        catch (IOException iOException) {
            logger.debug("error writing hotlist", iOException);
        }
    }

    protected UserData2 convert(UserData userData) {
        if (userData instanceof UserData2) {
            return (UserData2)userData;
        }
        return new UserData2(userData);
    }

    public static void reset(IUser iUser) {
        iUser.setChatIgnored(false);
        iUser.setCategory("");
        iUser.setMaxDownloads(-1);
        iUser.setMaxUploads(-1);
        iUser.setTemporary(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected UserManager() {
        try {
            this.read();
        }
        catch (IOException iOException) {
            logger.debug("error reading hotlist", iOException);
        }
    }
}

