/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.util;

import java.util.Collection;
import java.util.LinkedList;
import xnap.XNap;
import xnap.plugin.nap.net.GlobalUser;
import xnap.user.UserManager;
import xnap.util.FileHelper;
import xnap.util.PluginPreferencesSupport;
import xnap.util.QuotedStringTokenizer;
import xnap.util.StringHelper;
import xnap.util.prefs.IntValidator;
import xnap.util.prefs.PortRangeValidator;

public class NapPreferences
extends PluginPreferencesSupport {
    public static final int VERSION = 5;
    private static NapPreferences singleton = null;

    public static synchronized NapPreferences getInstance() {
        if (singleton == null) {
            singleton = new NapPreferences();
        }
        return singleton;
    }

    public void convert(int n) {
        if (n <= 0) {
            this.setTableColumns("user", "0;2;3;4;5;6;7;8");
            this.setTableColumns("server", "0;1;4;5;6;7");
        }
        if (n <= 1) {
            this.removeProperty("xnap.plugin.nap.userTableColumns");
            this.renameProperty("xnap.serverTableColumns", "xnap.plugin.nap.serverTableColumns");
            this.renameProperty("xnap.serverTableColumnWidth", "xnap.plugin.nap.serverTableColumnWidth");
            this.renameProperty("xnap.serverTableMaintainSortOrder", "xnap.plugin.nap.serverTableMaintainSortOrder");
            this.renameProperty("xnap.serverTableSortedColumn", "xnap.plugin.nap.serverTableSortedColumn");
        }
        if (n <= 2) {
            // empty if block
        }
        if (n <= 3) {
            GlobalUser globalUser;
            this.removeProperty("hotlistDividerLocation");
            this.removeProperty("hotlistTableColumns");
            LinkedList linkedList = StringHelper.toList(this.get("bannedUsers"), ";");
            Object object = linkedList.iterator();
            while (object.hasNext()) {
                globalUser = new GlobalUser(object.next().toString(), false);
                globalUser.setMaxUploads(0);
                globalUser.setCategory(XNap.tr("Banned"));
                UserManager.getInstance().add(globalUser);
            }
            this.removeProperty("bannedUsers");
            object = new QuotedStringTokenizer(this.get("hotlistUsers"));
            while (((QuotedStringTokenizer)object).hasMoreTokens()) {
                globalUser = new GlobalUser(((QuotedStringTokenizer)object).nextToken(), false);
                UserManager.getInstance().add(globalUser);
            }
            UserManager.getInstance().write();
            this.removeProperty("hotlistUsers");
        }
        if (n <= 4) {
            this.removeProperty("useSinglePort");
        }
    }

    public void destroy() {
        singleton = null;
    }

    public boolean getAutoFetchNapigator() {
        return this.getBoolean("autoFetchNaptigator");
    }

    public void setAutoFetchNapigator(boolean bl) {
        this.set("autoFetchNaptigator", bl);
    }

    public boolean getAutoLoadNapigator() {
        return this.getBoolean("autoLoadNaptigator");
    }

    public void setAutoLoadNapigator(boolean bl) {
        this.set("autoLoadNaptigator", bl);
    }

    public boolean getAutoSaveNapigator() {
        return this.getBoolean("autoSaveNaptigator");
    }

    public void setAutoSaveNapigator(boolean bl) {
        this.set("autoSaveNaptigator", bl);
    }

    public String getClientInfo() {
        return this.get("clientInfo");
    }

    public void setClientInfo(String string) {
        if (string.equals("")) {
            return;
        }
        this.set("clientInfo", string);
    }

    public boolean getCustomizeClientInfo() {
        return this.getBoolean("customizeClientInfo");
    }

    public void setCustomizeClientInfo(boolean bl) {
        this.set("customizeClientInfo", bl);
    }

    public String getFakeNetworks() {
        return this.get("fakeNetworks");
    }

    public String getFilterNetworks() {
        return this.get("filterNetworks");
    }

    public boolean getLimitSharesPerServer() {
        return this.getBoolean("limitSharesPerServer");
    }

    public void setLimitSharesPerServer(boolean bl) {
        this.set("limitSharesPerServer", bl);
    }

    public String getLocalPortRange() {
        return this.get("localPort");
    }

    public void setLocalPortRange(String string) {
        this.set("localPort", string);
    }

    public int getMaxAutoconnectServers() {
        return this.getInt("maxAutoconnectServers");
    }

    public void setMaxAutoconnectServers(int n) {
        if (n < 0) {
            return;
        }
        this.set("maxAutoconnectServers", n);
    }

    public int getMaxLoginsPerNetwork() {
        return this.getInt("maxLoginsPerNetwork");
    }

    public int getMaxPacketsPerTick() {
        return this.getInt("maxPacketsPerTick");
    }

    public int getMaxSearchResultsPerServer() {
        return this.getInt("maxSearchResultsPerServer");
    }

    public void setMaxSearchResultsPerServer(int n) {
        this.set("maxSearchResultsPerServer", n);
    }

    public int getMaxSearchServers() {
        return this.getInt("maxSearchServers");
    }

    public void setMaxSearchServers(int n) {
        if (n < 1) {
            return;
        }
        this.set("maxSearchServers", n);
    }

    public int getMaxSharesPerServer() {
        return this.getInt("maxSharesPerServer");
    }

    public void setMaxSharesPerServer(int n) {
        this.set("maxSharesPerServer", n);
    }

    public int getMinimumShares() {
        return this.getInt("minimumShares");
    }

    public void setMinimumShares(int n) {
        this.set("minimumShares", n);
    }

    public String getMinimumSharesMessage() {
        return this.get("minimumSharesMessage");
    }

    public void setMinimumSharesMessage(String string) {
        this.set("minimumSharesMessage", string);
    }

    public String getNapigatorFile() {
        return this.get("napigatorFile");
    }

    public String getNapigatorURL() {
        return this.get("napigatorURL");
    }

    public boolean getPreferSlavanap() {
        if (this.get("preferSlavanap").length() > 0) {
            return this.getBoolean("preferSlavanap");
        }
        return false;
    }

    public boolean getRemoveFailedServers() {
        return this.getBoolean("removeFailedServers");
    }

    public void setRemoveFailedServers(boolean bl) {
        this.set("removeFailedServers", bl);
    }

    public boolean getSendMinimumSharesMessage() {
        return this.getBoolean("sendMinimumSharesMessage");
    }

    public void setSendMinimumSharesMessage(boolean bl) {
        this.set("sendMinimumSharesMessage", bl);
    }

    public boolean getSendWholeRepository() {
        return this.getBoolean("sendWholeRepository");
    }

    public void setSendWholeRepository(boolean bl) {
        this.set("sendWholeRepository", bl);
    }

    public String getServerFile() {
        return this.get("serverFile");
    }

    public String getServerTableColumns() {
        return this.get("serverTableColumns");
    }

    public String[] getServerTableColumnsArray() {
        return StringHelper.toArray(this.getServerTableColumns(), ";");
    }

    public void setServerTableColumns(String string) {
        this.set("serverTableColumns", string);
    }

    public void setServerTableColumns(Collection collection) {
        this.setServerTableColumns(StringHelper.toString(collection, ";"));
    }

    public boolean getUseAutoconnector() {
        return this.getBoolean("useAutoconnector");
    }

    public void setUseAutoconnector(boolean bl) {
        this.set("useAutoconnector", bl);
    }

    public boolean getUseMinimumShares() {
        return this.getBoolean("useMinimumShares");
    }

    public void setUseMinimumShares(boolean bl) {
        this.set("useMinimumShares", bl);
    }

    public long getTickLength() {
        return this.getLong("tickLength");
    }

    public boolean getWhoisQueryOnTransfer() {
        return this.getBoolean("whoisQueryOnTransfer");
    }

    public void setWhoisQueryOnTransfer(boolean bl) {
        this.set("whoisQueryOnTransfer", bl);
    }

    private NapPreferences() {
        super("plugin.nap", 5);
        this.setDefault("autoFetchNaptigator", "true");
        this.setDefault("autoLoadNaptigator", "true");
        this.setDefault("autoSaveNaptigator", "true");
        this.setDefault("clientInfo", "XNap 2.4-pre5");
        this.setDefault("customizeClientInfo", "false");
        this.setDefault("fakeNetworks", "n/a");
        this.setDefault("filterNetworks", "Napster");
        this.setDefault("hotlistUsers", "");
        this.setDefault("limitSharesPerServer", "false");
        this.setDefault("localPort", "6600-6700", new PortRangeValidator());
        this.setDefault("maxAutoconnectServers", "10");
        this.setDefault("maxLoginsPerNetwork", "1");
        this.setDefault("maxPacketsPerTick", "50");
        this.setDefault("maxSearchResultsPerServer", "200", new IntValidator(0, Integer.MAX_VALUE));
        this.setDefault("maxSearchServers", "5");
        this.setDefault("maxSharesPerServer", "500");
        this.setDefault("minimumShares", "0");
        this.setDefault("minimumSharesMessage", "Sorry, you are not allowed to download since you do not share enough.");
        this.setDefault("napigatorFile", FileHelper.getHomeDir() + "napigator_hosts");
        this.setDefault("napigatorURL", "http://www.napigator.com/servers.php?version=112&client=napigator");
        this.setDefault("removeFailedServers", "false");
        this.setDefault("sendMinimumSharesMessage", "false");
        this.setDefault("sendWholeRepository", "false");
        this.setDefault("serverFile", FileHelper.getHomeDir() + "hosts");
        this.setDefault("serverTableColumns", "0;1;4;5;6;7");
        this.setDefault("useAutoconnector", "true");
        this.setDefault("useMinimumShares", "false");
        this.setDefault("tickLength", "100");
        this.setDefault("whoisQueryOnTransfer", "false");
        this.setDefault("whoisTableColumns", "0;2;3;4;5;6;7;8");
        if (!this.getCustomizeClientInfo()) {
            this.setClientInfo("XNap 2.4-pre5");
        }
    }
}

