/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.io.Repository;
import xnap.io.RepositoryFile;
import xnap.net.event.StatusChangeEvent;
import xnap.net.event.StatusChangeListener;
import xnap.plugin.nap.net.GlobalUser;
import xnap.plugin.nap.net.NapListener;
import xnap.plugin.nap.net.Napigator;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.AddHotlistEntryMessage;
import xnap.plugin.nap.net.msg.client.ShareFileMessage;
import xnap.plugin.nap.net.msg.client.UnshareAllFilesMessage;
import xnap.plugin.nap.net.msg.client.UnshareFileMessage;
import xnap.plugin.nap.util.NapPreferences;
import xnap.plugin.nap.util.ServerFile;
import xnap.plugin.nap.util.TrippyMXFile;
import xnap.user.UserManager;
import xnap.util.ChatManager;
import xnap.util.EventVector;
import xnap.util.Formatter;
import xnap.util.PortRange;
import xnap.util.Preferences;
import xnap.util.Range;
import xnap.util.SearchManager;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;
import xnap.util.event.StatusListener;

public class Connector
extends EventVector
implements Runnable,
PropertyChangeListener,
StatusChangeListener,
ListListener {
    public static final int LOGIN_INTERVAL = 180000;
    public static final int FAILED_INTERVAL = 60000;
    protected static Logger logger = Logger.getLogger(class$Lxnap$plugin$nap$util$Connector != null ? class$Lxnap$plugin$nap$util$Connector : (class$Lxnap$plugin$nap$util$Connector = Connector.class$("xnap.plugin.nap.util.Connector")));
    protected static Connector singleton;
    private Preferences prefs = Preferences.getInstance();
    private NapPreferences napPrefs = NapPreferences.getInstance();
    private int maxConnect = this.napPrefs.getMaxAutoconnectServers();
    private int maxTrying = 2 * this.maxConnect;
    private int connectedCount = 0;
    private int tryingCount = 0;
    private String stats;
    private boolean die = false;
    private Thread runner = null;
    private boolean enabled = false;
    private NapListener listener = new NapListener();
    private Object lock = new Object();
    protected StatusListener statusListener;
    protected LinkedList statsListener = new LinkedList();
    protected ServerVector connectedServers = new ServerVector();
    protected HashSet connectedNetworks = new HashSet();
    protected int repositoryIndex = 0;
    protected boolean addedTemporary = false;
    private static /* synthetic */ Class class$Lxnap$plugin$nap$util$Connector;

    public static synchronized Connector getInstance() {
        if (singleton == null) {
            singleton = new Connector();
        }
        return singleton;
    }

    public synchronized void setStatus(String string) {
        if (this.statusListener != null) {
            this.statusListener.setStatus(string);
        }
    }

    public synchronized void setStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }

    public synchronized void setStats(String string) {
        Iterator iterator = this.statsListener.iterator();
        while (iterator.hasNext()) {
            ((StatusListener)iterator.next()).setStatus(string);
        }
    }

    public synchronized void addStatsListener(StatusListener statusListener) {
        this.statsListener.add(statusListener);
    }

    public synchronized void removeStatsListener(StatusListener statusListener) {
        this.statsListener.remove(statusListener);
    }

    public synchronized void elementAdded(ListEvent listEvent) {
        if (listEvent.getSource() == Repository.getInstance() && !this.napPrefs.getLimitSharesPerServer()) {
            RepositoryFile repositoryFile = (RepositoryFile)listEvent.getElement();
            MessageHandler.send(new ShareFileMessage(listEvent.getIndex(), repositoryFile));
        }
    }

    public synchronized void elementRemoved(ListEvent listEvent) {
        if (listEvent.getSource() == Repository.getInstance()) {
            RepositoryFile repositoryFile = (RepositoryFile)listEvent.getElement();
            MessageHandler.send(new UnshareFileMessage(listEvent.getIndex(), repositoryFile));
        }
    }

    public boolean addServer(String string, String string2, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 2) {
            return false;
        }
        String string3 = stringTokenizer.nextToken();
        int n = 0;
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (string3.length() == 0 || n < 1 || n > 65535) {
            return false;
        }
        Server server = new Server(string3, n, string2);
        this.addServer(server);
        if (bl) {
            this.login(server);
        }
        return true;
    }

    public synchronized void addServer(int n, Server server) {
        if (!super.contains(server)) {
            server.setListener(this.listener);
            super.add(server);
            this.addedTemporary |= server.isTemporary();
            server.addStatusChangeListener(this);
            this.wakeup();
        }
    }

    public synchronized void addServer(Server server) {
        this.addServer(super.size(), server);
    }

    public synchronized void removeServer(Server server) {
        server.logout();
        server.removeStatusChangeListener(this);
        super.remove(server);
    }

    public synchronized void removeAllServers() {
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            server.logout();
            server.removeStatusChangeListener(this);
        }
        super.clear();
    }

    public synchronized Server getServer(String string) {
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            Server server = (Server)iterator.next();
            if (!server.getHost().equals(string)) continue;
            return server;
        }
        return null;
    }

    public synchronized Server[] getServers() {
        Server[] serverArray = new Server[super.size()];
        int n = 0;
        Iterator iterator = super.iterator();
        while (iterator.hasNext()) {
            serverArray[n] = (Server)iterator.next();
            ++n;
        }
        return serverArray;
    }

    public int getConnectedCount() {
        return this.connectedCount;
    }

    public EventVector getConnectedServers() {
        return this.connectedServers;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (this.enabled) {
            if (this.runner != null) {
                this.wakeup();
            }
            if (!this.runner.isAlive()) {
                logger.debug("OpenNapConnector Thread died");
                this.runner = new Thread((Runnable)this, "OpenNapConnector");
                this.runner.start();
            }
        }
    }

    public void init() {
        this.updateListener();
        this.runner = new Thread((Runnable)this, "OpenNapConnector");
        this.runner.start();
        new Thread(this, "ConnectorInit"){
            private final /* synthetic */ Connector this$0;

            public final void run() {
                try {
                    this.this$0.addFromFile(Connector.access$0(this.this$0).getServerFile(), false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (Connector.access$0(this.this$0).getAutoLoadNapigator()) {
                    try {
                        this.this$0.addFromFile(Connector.access$0(this.this$0).getNapigatorFile(), true);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (Connector.access$0(this.this$0).getAutoFetchNapigator()) {
                    this.this$0.addFromURL(Connector.access$0(this.this$0).getNapigatorURL());
                }
            }
            {
                this.this$0 = connector;
                this.constructor$0(connector, string);
            }

            private final void constructor$0(Connector connector, String string) {
            }
        }.start();
        this.updateStats();
    }

    private final void wakeup() {
        if (this.isEnabled()) {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }
    }

    public void run() {
        int n = 0;
        while (!this.die) {
            Object object;
            if (n > super.size()) {
                n = 0;
            }
            int n2 = n;
            boolean bl = false;
            while (super.size() > 0 && this.connectedCount <= this.maxConnect && this.tryingCount <= this.maxTrying) {
                try {
                    object = (Server)super.get(n);
                    if (!((Server)object).isReady() && this.canReconnect((Server)object) && (((Server)object).getNetwork().equals("") || this.connectedNetworks.add(((Server)object).getNetwork()))) {
                        this.login((Server)object);
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (++n >= super.size()) {
                    n = 0;
                    bl = true;
                }
                if (bl && n >= n2) break;
            }
            object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean canReconnect(Server server) {
        long l = System.currentTimeMillis() - server.getLastLogin();
        switch (server.getStatus()) {
            case 4: {
                return l > 180000L;
            }
            case 5: {
                return l > 60000L;
            }
            case 6: {
                return false;
            }
        }
        return true;
    }

    public void die() {
        this.die = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
        try {
            this.saveToFile(this.napPrefs.getServerFile(), false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.addedTemporary) {
            try {
                this.saveToFile(this.napPrefs.getNapigatorFile(), true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.removeAllServers();
        this.listener.die();
        singleton = null;
    }

    public void addFromFile(String string, boolean bl) throws IOException {
        ServerFile serverFile = string.endsWith(".dat") ? new TrippyMXFile(string) : new ServerFile(string);
        try {
            Server server;
            serverFile.openReader();
            while ((server = serverFile.readServer()) != null) {
                server.setTemporary(bl);
                this.addServer(server);
            }
            Object var5_6 = null;
            serverFile.close();
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            serverFile.close();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public void addFromURL(String var1_1) {
        var3_2 = new Napigator();
        try {
            var3_2.connect(var1_1);
            if (true) ** GOTO lbl11
        }
        catch (IOException var4_3) {
            this.setStatus("Could not open " + var1_1 + "(" + var4_3.getMessage() + ")");
            return;
        }
        do {
            var2_4.setTemporary(true);
            this.addServer(0, var2_4);
lbl11:
            // 2 sources

        } while ((var2_4 = var3_2.nextServer()) != null);
    }

    public void saveToFile(String string, boolean bl) throws IOException {
        ServerFile serverFile = new ServerFile(string);
        try {
            serverFile.openWriter();
            Iterator iterator = super.iterator();
            while (iterator.hasNext()) {
                Server server = (Server)iterator.next();
                if (server.isTemporary() != bl) continue;
                serverFile.writeServer(server);
            }
            Object var5_7 = null;
            serverFile.close();
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            serverFile.close();
            throw throwable;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("firewalled") || string.equals("useSinglePort") || string.equals("localPort")) {
            this.updateListener();
        } else if (string.equals("maxAutoconnectServers")) {
            this.maxConnect = this.napPrefs.getMaxAutoconnectServers();
            this.maxTrying = 2 * this.maxConnect;
            this.wakeup();
        }
    }

    protected void updateListener() {
        if (this.prefs.isFirewalled()) {
            this.listener.setPortRange(null);
        } else {
            PortRange portRange = new PortRange(this.napPrefs.getLocalPortRange());
            this.listener.setPortRange(portRange);
            if (this.listener.getPort() == 0) {
                this.setStatus("Could not start listener (check local port)");
            }
        }
    }

    public void statusChange(StatusChangeEvent statusChangeEvent) {
        switch (statusChangeEvent.getNewStatus()) {
            case 1: {
                if (statusChangeEvent.getOldStatus() != 0) break;
                ++this.tryingCount;
                break;
            }
            case 2: {
                if (statusChangeEvent.getOldStatus() == 1) {
                    Server server = (Server)statusChangeEvent.getSource();
                    --this.tryingCount;
                    ++this.connectedCount;
                    this.connectedServers.add(server);
                    ChatManager.getInstance().addServer(server);
                    SearchManager.getInstance().readyToSearch(true);
                    if (this.getConnectedCount() >= this.napPrefs.getMaxAutoconnectServers() / 2) {
                        SearchManager.getInstance().resumeDownloads();
                    }
                    this.postLogin(server);
                }
                this.updateStats();
                this.wakeup();
                break;
            }
            case 0: 
            case 4: 
            case 5: 
            case 6: {
                Server server = (Server)statusChangeEvent.getSource();
                if (statusChangeEvent.getOldStatus() == 1) {
                    --this.tryingCount;
                } else if (statusChangeEvent.getOldStatus() == 2) {
                    this.connectedServers.remove(server);
                    ChatManager.getInstance().removeServer(server);
                    --this.connectedCount;
                    SearchManager.getInstance().readyToSearch(false);
                }
                this.connectedNetworks.remove(server.getNetwork());
                if (server.isTemporary() && statusChangeEvent.getNewStatus() == 6 && this.napPrefs.getRemoveFailedServers()) {
                    this.removeServer(server);
                }
                this.updateStats();
                this.wakeup();
                break;
            }
            case 7: {
                this.updateStats();
                break;
            }
        }
    }

    public void login(Server server) {
        server.login(false);
    }

    public void logout(Server server) {
        if (server.isReady()) {
            if (server.isConnected()) {
                MessageHandler.send(server, new UnshareAllFilesMessage());
            }
            server.logout();
        }
    }

    public String getStats() {
        return this.stats;
    }

    private final void updateStats() {
        Object object;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        try {
            object = super.iterator();
            while (object.hasNext()) {
                Server server = (Server)object.next();
                if (!server.isConnected()) continue;
                l += (long)server.getUserCount();
                l2 += (long)server.getFileCount();
                l3 += (long)server.getFileSize();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = this.stats;
        l3 = l3 * 1024L * 1024L * 1024L;
        this.stats = Formatter.formatNumber(this.connectedCount) + " " + XNap.tr("Servers") + " / " + Formatter.formatNumber(l) + " " + XNap.tr("Users") + " / " + Formatter.formatNumber(l2) + " " + XNap.tr("Files") + " / " + Formatter.formatSize(l3) + " " + XNap.tr("Shared");
        this.setStats(this.stats);
    }

    public void postLogin(Server server) {
        Object[] objectArray = UserManager.getInstance().toArray();
        int n = 0;
        while (n < objectArray.length) {
            GlobalUser globalUser;
            if (objectArray[n] instanceof GlobalUser && !(globalUser = (GlobalUser)objectArray[n]).isTemporary()) {
                AddHotlistEntryMessage addHotlistEntryMessage = new AddHotlistEntryMessage(globalUser.getName());
                MessageHandler.sendLater(server, addHotlistEntryMessage);
            }
            ++n;
        }
        if (this.napPrefs.getLimitSharesPerServer()) {
            int n2 = this.napPrefs.getMaxSharesPerServer();
            while (n2 > 0) {
                int n3 = Repository.getInstance().size();
                int n4 = Math.min(n2, n3);
                Connector connector = this;
                synchronized (connector) {
                    n = this.repositoryIndex;
                    this.repositoryIndex += n4;
                    if (this.repositoryIndex >= n3) {
                        n4 = n3 - n - 1;
                        this.repositoryIndex = 0;
                    }
                }
                int n5 = this.shareFiles(server, n, n4);
                if (n5 == -1) {
                    return;
                }
                n2 -= n5;
            }
        } else {
            this.shareFiles(server, 0, Repository.getInstance().size());
        }
        MessageHandler.sendPending(server);
    }

    public int shareFiles(Server server, int n, int n2) {
        int n3 = 0;
        logger.debug("sharing index " + n + " - " + (n + n2));
        server.setShared(new Range(n, n + n2 - 1));
        int n4 = 0;
        while (n4 < n2) {
            RepositoryFile repositoryFile = Repository.getInstance().getFile(n + n4);
            if (repositoryFile != null) {
                if (!server.isReady()) {
                    return -1;
                }
                ShareFileMessage shareFileMessage = new ShareFileMessage(n + n4, repositoryFile);
                MessageHandler.sendLater(server, shareFileMessage);
                ++n3;
            }
            ++n4;
        }
        return n3;
    }

    static /* synthetic */ NapPreferences access$0(Connector connector) {
        return connector.napPrefs;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Connector() {
        this.prefs.addPropertyChangeListener(this);
        Repository.getInstance().addListListener(this);
    }

    public static class ServerVector
    extends EventVector {
        public void add(Server server) {
            super.add(server);
        }

        public void remove(Server server) {
            super.remove(server);
        }
    }
}

