/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import xnap.plugin.nap.net.BrowseSocket;
import xnap.plugin.nap.net.DirectBrowseUpload;
import xnap.plugin.nap.net.DownloadSocket;
import xnap.plugin.nap.net.IncomingSocket;
import xnap.plugin.nap.net.UploadSocket;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.client.ChangeDataPortMessage;
import xnap.util.PortRange;

public class NapListener {
    protected static Logger logger = Logger.getLogger(class$Lxnap$plugin$nap$net$NapListener$ListenerThread != null ? class$Lxnap$plugin$nap$net$NapListener$ListenerThread : (class$Lxnap$plugin$nap$net$NapListener$ListenerThread = NapListener.class$("xnap.plugin.nap.net.NapListener$ListenerThread")));
    private LinkedList sockets = new LinkedList();
    private Object lock = new Object();
    private PortRange range = null;
    private ListenerThread runner = null;
    private static /* synthetic */ Class class$Lxnap$plugin$nap$net$NapListener$ListenerThread;

    protected void addSocket(IncomingSocket incomingSocket) {
        Object object = this.lock;
        synchronized (object) {
            this.sockets.add(incomingSocket);
            this.lock.notifyAll();
        }
    }

    public int getPort() {
        return this.runner != null ? this.runner.getPort() : 0;
    }

    public void die() {
        if (this.runner != null) {
            this.runner.die();
            this.runner = null;
        }
    }

    private final void start(int n) {
        if (this.range != null) {
            ServerSocket serverSocket = null;
            if (n != 0) {
                try {
                    serverSocket = new ServerSocket(n);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (serverSocket == null) {
                PortRange.IntIterator intIterator = this.range.random();
                while (intIterator.hasNext()) {
                    try {
                        serverSocket = new ServerSocket(intIterator.next());
                        break;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            if (serverSocket != null) {
                this.runner = new ListenerThread(serverSocket);
                this.runner.start();
            } else {
                logger.debug("could not start listener on " + this.range.toString());
            }
        }
    }

    private final void restart(int n) {
        int n2 = this.getPort();
        this.die();
        this.start(n);
        if (n2 != this.getPort()) {
            MessageHandler.send(new ChangeDataPortMessage(this.getPort()));
        }
    }

    private final void restart() {
        this.restart(0);
    }

    public void setPortRange(PortRange portRange) {
        PortRange portRange2 = this.range;
        this.range = portRange;
        if (portRange != null && portRange.contains(this.getPort())) {
            return;
        }
        this.restart();
    }

    public IncomingSocket waitForSocket(IncomingSocket incomingSocket, long l) {
        long l2 = System.currentTimeMillis();
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                Iterator iterator = this.sockets.iterator();
                while (iterator.hasNext()) {
                    IncomingSocket incomingSocket2 = (IncomingSocket)iterator.next();
                    if (!incomingSocket2.equals(incomingSocket)) continue;
                    iterator.remove();
                    return incomingSocket2;
                }
                long l3 = l - (System.currentTimeMillis() - l2);
                if (l3 <= 0L) {
                    return null;
                }
                try {
                    this.lock.wait(l3);
                }
                catch (InterruptedException interruptedException) {
                    return null;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public NapListener(PortRange portRange) {
        this.setPortRange(portRange);
    }

    public NapListener() {
    }

    private class ListenerThread
    extends Thread {
        private ServerSocket listenerSocket = null;
        private boolean die = false;

        public void die() {
            this.die = true;
        }

        public int getPort() {
            return this.listenerSocket.getLocalPort();
        }

        private final void handleSocket(Socket socket) {
            block12: {
                BufferedInputStream bufferedInputStream = null;
                OutputStream outputStream = null;
                try {
                    bufferedInputStream = new BufferedInputStream(socket.getInputStream());
                    outputStream = socket.getOutputStream();
                    outputStream.write(49);
                    outputStream.flush();
                    byte[] byArray = new byte[2048];
                    ((InputStream)bufferedInputStream).mark(8);
                    int n = ((InputStream)bufferedInputStream).read(byArray, 0, 8);
                    if (n > 0) {
                        String string = new String(byArray, 0, n);
                        logger.debug("received: " + string);
                        ((InputStream)bufferedInputStream).reset();
                        if (string.startsWith("GETLIST")) {
                            ((InputStream)bufferedInputStream).skip(7L);
                            DirectBrowseUpload directBrowseUpload = new DirectBrowseUpload(socket);
                            directBrowseUpload.start();
                            break block12;
                        }
                        if (string.startsWith("GET")) {
                            ((InputStream)bufferedInputStream).skip(3L);
                            NapListener.this.addSocket(new UploadSocket(socket, bufferedInputStream));
                            break block12;
                        }
                        if (string.startsWith("SENDLIST")) {
                            ((InputStream)bufferedInputStream).skip(8L);
                            NapListener.this.addSocket(new BrowseSocket(socket, bufferedInputStream));
                            break block12;
                        }
                        if (string.startsWith("SEND")) {
                            ((InputStream)bufferedInputStream).skip(4L);
                            NapListener.this.addSocket(new DownloadSocket(socket, bufferedInputStream));
                            break block12;
                        }
                        throw new IOException("invalid request: " + string);
                    }
                    throw new IOException("empty request");
                }
                catch (IOException iOException) {
                    logger.warn("invalid listener request", iOException);
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        if (bufferedInputStream != null) {
                            ((InputStream)bufferedInputStream).close();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException2) {
                        // empty catch block
                    }
                }
            }
        }

        public void run() {
            boolean bl = false;
            logger.debug("started listener on port " + this.getPort());
            try {
                this.listenerSocket.setSoTimeout(10000);
            }
            catch (SocketException socketException) {
                bl = true;
                this.die = true;
            }
            while (!this.die) {
                Socket socket = null;
                try {
                    socket = this.listenerSocket.accept();
                    socket.setSoTimeout(30000);
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                catch (IOException iOException) {
                    bl = true;
                    break;
                }
                if (socket == null) continue;
                this.handleSocket(socket);
            }
            try {
                this.listenerSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.debug("stopped listener on port " + this.getPort());
            if (bl) {
                logger.debug("listener died unexpectively, restarting");
                NapListener.this.restart(this.getPort());
            }
        }

        public ListenerThread(ServerSocket serverSocket) {
            super("OpenNapListener :" + serverSocket.getLocalPort());
            this.listenerSocket = serverSocket;
        }
    }
}

