/*
 * Decompiled with CFR 0.152.
 */
package xnap.plugin.nap;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.StringTokenizer;
import xnap.XNap;
import xnap.cmdl.AbstractCommand;
import xnap.cmdl.CommandLineSupport;
import xnap.cmdl.Console;
import xnap.cmdl.Executer;
import xnap.cmdl.ParameterException;
import xnap.cmdl.SyntaxException;
import xnap.net.ISearch;
import xnap.plugin.AbstractPlugin;
import xnap.plugin.INetworkPlugin;
import xnap.plugin.nap.net.Search;
import xnap.plugin.nap.net.Server;
import xnap.plugin.nap.net.msg.ExceptionListener;
import xnap.plugin.nap.net.msg.MessageHandler;
import xnap.plugin.nap.net.msg.MessageSender;
import xnap.plugin.nap.net.msg.client.ClientMessage;
import xnap.plugin.nap.net.msg.client.ClientStatisticsMessage;
import xnap.plugin.nap.net.msg.client.WhoisRequestMessage;
import xnap.plugin.nap.util.Connector;
import xnap.plugin.nap.util.NapPreferences;
import xnap.util.Debug;
import xnap.util.Formatter;
import xnap.util.Preferences;
import xnap.util.SearchFilter;

public class Plugin
extends AbstractPlugin
implements INetworkPlugin,
CommandLineSupport {
    public static final String VERSION = "2.4-pre5";
    private static Plugin singleton;
    protected Console console = Console.getInstance();
    protected Preferences prefs = Preferences.getInstance();
    protected NapPreferences napPrefs = NapPreferences.getInstance();
    private int index = 0;
    private AbstractCommand[] commands = new AbstractCommand[]{new ConnectCmd(), new StatsCmd(), new ServerListCmd(), new WhoisCmd(), new ConnectorCmd(), new ClientStatisticsCmd(), new PluginStatsCmd()};

    public String getDescription() {
        return Plugin.tr("Support for the OpenNap protocol.");
    }

    public String getName() {
        return "OpenNap";
    }

    public String getVersion() {
        return VERSION;
    }

    public AbstractCommand[] getCommands() {
        return this.commands;
    }

    public static Plugin getInstance() {
        return singleton;
    }

    public int getStatus() {
        if (Connector.getInstance().getConnectedCount() > 0) {
            return 1;
        }
        return 2;
    }

    public String getStatusMessage() {
        return Connector.getInstance().getConnectedCount() + " " + XNap.tr("Servers");
    }

    public ISearch[] search(SearchFilter searchFilter, int n) {
        ISearch[] iSearchArray;
        Debug.log("nap: search");
        LinkedList<Search> linkedList = new LinkedList<Search>();
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = 0;
        Object[] objectArray = Connector.getInstance().getConnectedServers().toArray();
        if (objectArray.length == 0) {
            return null;
        }
        if (this.index >= objectArray.length) {
            this.index = 0;
        }
        int n3 = this.index;
        while (n2 < this.napPrefs.getMaxSearchServers() || this.napPrefs.getMaxSearchServers() <= 0) {
            iSearchArray = (ISearch[])objectArray[this.index];
            if (iSearchArray.getNetwork().equals("") || hashSet.add(iSearchArray.getNetwork())) {
                Search search = new Search(searchFilter, n, this.napPrefs.getMaxSearchResultsPerServer(), (Server)iSearchArray);
                linkedList.add(search);
                ++n2;
            }
            ++this.index;
            if (this.index == objectArray.length) {
                this.index = 0;
            }
            if (this.index == n3) break;
        }
        iSearchArray = new ISearch[linkedList.size()];
        System.arraycopy(linkedList.toArray(), 0, iSearchArray, 0, iSearchArray.length);
        return iSearchArray;
    }

    public void start() {
        Debug.log("nap: start");
        MessageSender.getInstance().start();
        Connector.getInstance().init();
        Connector.getInstance().setEnabled(this.napPrefs.getUseAutoconnector());
        Executer.installHandler(this);
        super.start();
    }

    public void stop() {
        super.stop();
        Debug.log("nap: stop");
        Executer.removeHandler(this);
        Connector.getInstance().die();
        MessageSender.getInstance().stop();
    }

    public static final String tr(String string) {
        return XNap.tr(string);
    }

    public static final String tr(String string, int n) {
        return XNap.tr(string, n);
    }

    public static final String tr(String string, int n, int n2) {
        return XNap.tr(string, n, n2);
    }

    public Plugin() {
        singleton = this;
    }

    protected class ConnectCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            boolean bl = true;
            if (stringArray.length == 2) {
                bl = Connector.getInstance().addServer(stringArray[1], "", true);
            } else if (stringArray.length == 3) {
                bl = Connector.getInstance().addServer(stringArray[1], stringArray[2], true);
            } else {
                return false;
            }
            if (!bl) {
                Plugin.this.console.println("Could not add server.");
            }
            return true;
        }

        public ConnectCmd() {
            this.putValue("cmd", new String[]{"opennapconnect"});
            this.putValue("parameter", "server:port [network]");
            this.putValue("shortHelp", "Connect to OpenNap server.");
        }
    }

    protected class StatsCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            Plugin.this.console.println(Connector.getInstance().getStats());
            return true;
        }

        public StatsCmd() {
            this.putValue("cmd", new String[]{"opennapstats"});
            this.putValue("shortHelp", "Show OpenNap statistics.");
        }
    }

    protected class ServerListCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            Server[] serverArray = Connector.getInstance().getServers();
            if (serverArray.length == 0) {
                Plugin.this.console.println("(list is empty)");
            } else {
                String[] stringArray2 = new String[serverArray.length];
                int n = 0;
                while (n < serverArray.length) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(n + 1);
                    stringBuffer.append("|" + serverArray[n].getHost() + ":" + serverArray[n].getPort());
                    stringBuffer.append("|" + serverArray[n].getStatusText());
                    if (serverArray[n].isConnected()) {
                        stringBuffer.append("|" + serverArray[n].getVersion());
                        stringBuffer.append("|" + serverArray[n].getUserCount() + " users");
                        stringBuffer.append("|" + serverArray[n].getFileCount() + " files");
                        int n2 = serverArray[n].getFileSize();
                        stringBuffer.append("|" + Formatter.formatSize(n2) + " shared");
                    }
                    stringArray2[n] = stringBuffer.toString();
                    ++n;
                }
                n = 0;
                int n3 = 2;
                int[] nArray = new int[]{n3, n, n, n, n3, n3, n3};
                Plugin.this.console.println(Formatter.formatTable(stringArray2, nArray));
            }
            return true;
        }

        public ServerListCmd() {
            this.putValue("cmd", new String[]{"opennapserverlist"});
            this.putValue("shortHelp", "Show list of OpenNap servers.");
        }
    }

    protected class WhoisCmd
    extends AbstractCommand
    implements ExceptionListener {
        public void exceptionThrown(Exception exception) {
            Plugin.this.console.println(exception.getMessage());
        }

        public boolean execute(String[] stringArray) throws SyntaxException, ParameterException {
            String string;
            Object object;
            String string2 = null;
            boolean bl = false;
            if (stringArray.length == 2) {
                object = new StringTokenizer(stringArray[1], "@");
                string = ((StringTokenizer)object).nextToken();
                if (((StringTokenizer)object).countTokens() == 1) {
                    string2 = ((StringTokenizer)object).nextToken();
                } else {
                    bl = true;
                }
            } else if (stringArray.length == 3) {
                string2 = stringArray[1];
                string = stringArray[2];
            } else {
                throw new SyntaxException();
            }
            object = new WhoisRequestMessage(string);
            ((ClientMessage)object).setExceptionListener(this);
            if (bl) {
                MessageHandler.send((ClientMessage)object);
            } else {
                Server server = Connector.getInstance().getServer(string2);
                if (server == null) {
                    throw new ParameterException("server not found");
                }
                MessageHandler.send(server, (ClientMessage)object);
            }
            return true;
        }

        public WhoisCmd() {
            this.putValue("cmd", new String[]{"opennapwhois", "who"});
            this.putValue("parameter", "(server user|user@server)");
            this.putValue("shortHelp", "Do a whois query.");
        }
    }

    protected class ConnectorCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            Connector connector;
            connector.setEnabled(!(connector = Connector.getInstance()).isEnabled());
            Plugin.this.console.println("OpenNap auto connector is " + (connector.isEnabled() ? "enabled" : "disabled") + ".");
            return true;
        }

        public ConnectorCmd() {
            this.putValue("cmd", new String[]{"opennapconnector"});
            this.putValue("shortHelp", "Toggle auto connector.");
        }
    }

    protected class ClientStatisticsCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            MessageHandler.send(new ClientStatisticsMessage());
            return true;
        }

        public ClientStatisticsCmd() {
            this.putValue("cmd", new String[]{"opennapclientstatistics"});
            this.putValue("shortHelp", "Query Opennap server for client statistics.");
        }
    }

    protected class PluginStatsCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Connected servers: ");
            stringBuffer.append(Connector.getInstance().getConnectedServers().size());
            stringBuffer.append("\n");
            Plugin.this.console.println(stringBuffer.toString());
            return true;
        }

        public PluginStatsCmd() {
            this.putValue("cmd", new String[]{"opennappluginstatus"});
            this.putValue("shortHelp", "Show plugin status.");
        }
    }
}

