/*
 * Decompiled with CFR 0.152.
 */
package xnap.net;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import xnap.XNap;
import xnap.io.ResumeFile3;
import xnap.net.AbstractTransferContainer;
import xnap.net.IDownload;
import xnap.net.IDownloadContainer;
import xnap.net.IUser;
import xnap.net.UserContainer;
import xnap.util.FileHelper;
import xnap.util.FiniteStateMachine;
import xnap.util.Preferences;
import xnap.util.State;

public class MultiDownload
extends AbstractTransferContainer
implements IDownloadContainer {
    public static final int WAKEUP_INTERVAL = 30000;
    public static final int MAX_TRIES = Preferences.getInstance().getDownloadMaxTries();
    private static Hashtable stateTable = new Hashtable();
    private LinkedList dlQueue = new LinkedList();
    private LinkedList runQueue = new LinkedList();
    private UserContainer users = new UserContainer();
    private HashSet queued = new HashSet();
    private IDownload download;
    private ResumeFile3 resumeFile;
    private Object lock = new Object();
    private int maxDownloads = 1;
    private long offset;
    private FileOutputStream out;
    private long nextWakeUp = 0L;
    private FiniteStateMachine fsm = new FiniteStateMachine(State.NOT_STARTED, stateTable);

    public void die() {
        this.wakeup();
    }

    public boolean add(IDownload iDownload) {
        if (iDownload == null) {
            return false;
        }
        if (iDownload.getUser().getMaxDownloads() == 0) {
            AbstractTransferContainer.logger.debug("not adding because is blocked: " + iDownload);
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.dlQueue.contains(iDownload) && !this.runQueue.contains(iDownload) && iDownload.getTryCount() < MAX_TRIES) {
                AbstractTransferContainer.logger.debug("add " + this.file.getName());
                this.dlQueue.addLast(iDownload);
                this.users.add(iDownload.getUser());
                this.wakeup();
                return true;
            }
        }
        return false;
    }

    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.dlQueue.clear();
            this.runQueue.clear();
            this.users.clear();
        }
    }

    public void start(IDownload iDownload) {
        Object object = this.lock;
        synchronized (object) {
            this.dlQueue.remove(iDownload);
            this.runQueue.addLast(iDownload);
        }
        this.wakeup();
    }

    public void setQueuePos(IDownload iDownload, int n) {
        if (n <= 0) {
            this.queued.remove(iDownload);
        } else {
            AbstractTransferContainer.logger.debug(this + " queued " + iDownload + " at pos " + n);
            this.queued.add(iDownload);
            this.wakeup();
        }
    }

    public void setFile(File file) {
        if (this.resumeFile != null) {
            this.resumeFile = new ResumeFile3(file, this.resumeFile.getFinalSize(), this.resumeFile.getFilterData());
            super.setFile(this.resumeFile);
        } else {
            super.setFile(file);
        }
    }

    public String getFilename() {
        return this.resumeFile != null ? this.resumeFile.getFinalFilename() : "";
    }

    public long getFilesize() {
        return this.resumeFile != null ? this.resumeFile.getFinalSize() : -1L;
    }

    public ResumeFile3 getResumeFile() {
        return this.resumeFile;
    }

    public void setResumeFile(ResumeFile3 resumeFile3) {
        this.setFile(resumeFile3);
        this.resumeFile = resumeFile3;
        this.totalBytesTransferred = this.resumeFile.length();
    }

    public long getTotalBytesTransferred() {
        return this.totalBytesTransferred;
    }

    public IUser getUser() {
        this.users.show(this.download != null ? this.download.getUser() : null);
        return this.users;
    }

    public int getQueueSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.dlQueue.size() + this.runQueue.size();
        }
    }

    public String getStatusText() {
        long l;
        if (this.getStatus() == 11 && (l = (this.nextWakeUp - System.currentTimeMillis()) / 1000L) > 0L) {
            return MessageFormat.format(XNap.tr("retrying in {0} s"), new Long(l));
        }
        return super.getStatusText();
    }

    public boolean isBusy() {
        Object object = this.lock;
        synchronized (object) {
            return this.runQueue.size() > 0;
        }
    }

    public boolean isFinished() {
        return this.totalBytesTransferred == this.getFilesize();
    }

    public void merge(MultiDownload multiDownload) {
        Iterator iterator = multiDownload.dlQueue.iterator();
        while (iterator.hasNext()) {
            this.add((IDownload)iterator.next());
        }
        multiDownload.delete();
    }

    public void remove(IDownload iDownload) {
        iDownload.dequeue();
        this.queued.remove(iDownload);
        Object object = this.lock;
        synchronized (object) {
            this.dlQueue.remove(iDownload);
            this.users.remove(iDownload.getUser());
        }
        AbstractTransferContainer.logger.debug("removed download: " + iDownload);
        this.wakeup();
    }

    public void reset() {
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.dlQueue.iterator();
            while (iterator.hasNext()) {
                IDownload iDownload = (IDownload)iterator.next();
                iDownload.reset();
            }
        }
    }

    public void skip() {
        if (this.download != null) {
            this.download.close();
        }
    }

    public void run() {
        if (this.resumeFile.length() < this.resumeFile.getFinalSize()) {
            FileHelper.shorten(this.resumeFile, 1L);
            this.totalBytesTransferred = this.resumeFile.length();
        }
        try {
            this.out = new FileOutputStream(this.file.getAbsolutePath(), true);
        }
        catch (IOException iOException) {
            this.setStatus(7, "Could not write file " + this.file.getName());
            return;
        }
        this.download();
        try {
            this.out.flush();
            this.out.close();
            if (!this.die) {
                if (this.isFinished()) {
                    try {
                        String string = FileHelper.getDownloadDirFromExtension(this.resumeFile.getFinalFilename());
                        File file = FileHelper.moveUnique(this.file, string, this.resumeFile.getFinalFilename());
                        this.setFile(file);
                        this.setStatus(6);
                    }
                    catch (IOException iOException) {
                        AbstractTransferContainer.logger.debug("could not rename finished file", iOException);
                        this.setStatus(7, XNap.tr("Could not create file (check download dir)"));
                    }
                } else {
                    this.setStatus(7, XNap.tr("incomplete"));
                }
            }
        }
        catch (IOException iOException) {
            this.setStatus(7, XNap.tr("Could not close file"));
        }
        this.died();
    }

    public String toString() {
        return "MultiDownload " + this.getFilename();
    }

    private final void download() {
        while (!this.die && !this.isFinished()) {
            Object object;
            long l = 0L;
            Object object2 = this.lock;
            synchronized (object2) {
                Iterator iterator = this.dlQueue.iterator();
                while (iterator.hasNext()) {
                    object = (IDownload)iterator.next();
                    if (this.canStart((IDownload)object)) {
                        object.enqueue(this);
                    } else {
                        long l2 = System.currentTimeMillis() - object.getLastTry();
                        l = Math.max(l, l2);
                    }
                    this.setQueuePos((IDownload)object, object.getQueuePos());
                }
            }
            if (!this.die && !this.isFinished()) {
                this.waitForAdd(l);
            }
            boolean bl = false;
            while (!(this.die || this.isFinished() || bl)) {
                object = this.lock;
                synchronized (object) {
                    if (this.runQueue.size() == 0) {
                        bl = true;
                    } else {
                        this.download = (IDownload)this.runQueue.getFirst();
                        AbstractTransferContainer.logger.debug("MultiDownload: start " + this.download);
                    }
                }
                if (bl) continue;
                this.startDownload();
                Object object3 = this.lock;
                synchronized (object3) {
                    this.runQueue.removeFirst();
                }
                if (this.isFinished()) {
                    this.add(this.download);
                } else {
                    Object object4 = this.lock;
                    synchronized (object4) {
                        this.download = null;
                    }
                }
                l = 30000L;
            }
        }
        this.dequeueAll();
        AbstractTransferContainer.logger.debug("finished");
    }

    private final void dequeueAll() {
        Object object = this.lock;
        synchronized (object) {
            Iterator iterator = this.dlQueue.iterator();
            while (iterator.hasNext()) {
                IDownload iDownload = (IDownload)iterator.next();
                iDownload.dequeue();
            }
        }
        this.queued.clear();
    }

    private final boolean canStart(IDownload iDownload) {
        return System.currentTimeMillis() - iDownload.getLastTry() > 30000L;
    }

    private final void startDownload() {
        block7: {
            AbstractTransferContainer.logger.debug("starting download:" + this.download);
            this.totalRate = -1L;
            this.offset = Math.max(this.totalBytesTransferred - 100L, 0L);
            this.download.getUser().modifyLocalDownloadCount(1);
            this.setStatus(1);
            try {
                if (this.download.connect(this.offset)) {
                    this.writeFile();
                    this.download.close();
                    this.totalRate = this.getAverageRate();
                    this.stopDownload(!this.isFinished());
                    break block7;
                }
                if (this.download.getTryCount() >= MAX_TRIES) {
                    this.remove(this.download);
                    break block7;
                }
                Object object = this.lock;
                synchronized (object) {
                    this.dlQueue.addLast(this.download);
                }
            }
            catch (IOException iOException) {
                this.remove(this.download);
                AbstractTransferContainer.logger.warn("connect failed: " + iOException.getMessage());
            }
        }
        this.download.getUser().modifyLocalDownloadCount(-1);
    }

    private final void stopDownload(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            if (bl) {
                if (!this.dlQueue.contains(this.download) && this.download.getTryCount() < MAX_TRIES) {
                    this.dlQueue.addLast(this.download);
                }
            } else {
                this.remove(this.download);
            }
        }
    }

    public void writeFile() {
        this.setStatus(4);
        byte[] byArray = new byte[512];
        this.startTransfer();
        try {
            while (this.offset + this.bytesTransferred < this.getFilesize()) {
                int n;
                long l;
                int n2 = 0;
                long l2 = System.currentTimeMillis();
                while (n2 == 0) {
                    if (this.die) {
                        throw new InterruptedException();
                    }
                    if (System.currentTimeMillis() - l2 > 120000L) {
                        throw new IOException(XNap.tr("socket timeout"));
                    }
                    try {
                        l = this.getFilesize() - this.offset - this.bytesTransferred;
                        n = (int)Math.min(l, (long)byArray.length);
                        n2 = this.download.read(byArray, 0, n);
                    }
                    catch (InterruptedIOException interruptedIOException) {
                        // empty catch block
                    }
                }
                if (n2 != -1) {
                    if (this.offset + this.bytesTransferred < this.totalBytesTransferred) {
                        l = this.totalBytesTransferred - this.bytesTransferred;
                        n = (int)Math.min((long)n2, l - this.offset);
                        if (!this.checkFile(byArray, n)) {
                            AbstractTransferContainer.logger.warn("resume failed");
                            throw new InterruptedException();
                        }
                        if (n < n2) {
                            int n3 = (int)Math.min((long)(n2 - n), this.getFilesize() - this.totalBytesTransferred);
                            this.out.write(byArray, n, n3);
                            this.totalBytesTransferred += (long)n3;
                        }
                    } else {
                        int n4 = (int)Math.min((long)n2, this.getFilesize() - this.totalBytesTransferred);
                        this.out.write(byArray, 0, n4);
                        this.totalBytesTransferred += (long)n4;
                    }
                    this.bytesTransferred += (long)n2;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            AbstractTransferContainer.logger.warn("download failed " + iOException.getMessage());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private final boolean checkFile(byte[] byArray, int n) {
        RandomAccessFile randomAccessFile;
        try {
            randomAccessFile = new RandomAccessFile(this.file, "r");
        }
        catch (IOException iOException) {
            AbstractTransferContainer.logger.debug("file not found");
            return false;
        }
        byte[] byArray2 = new byte[n];
        try {
            randomAccessFile.seek(this.offset + this.bytesTransferred);
            randomAccessFile.readFully(byArray2);
        }
        catch (IOException iOException) {
            AbstractTransferContainer.logger.debug("wrong number of bytes");
            return false;
        }
        int n2 = 0;
        while (n2 < n) {
            if (byArray[n2] != byArray2[n2]) {
                AbstractTransferContainer.logger.debug("resume failed at " + (this.offset + this.bytesTransferred + (long)n2));
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof MultiDownload) {
            MultiDownload multiDownload = (MultiDownload)object;
            if (multiDownload.getResumeFile() == null || this.getResumeFile() == null) {
                return false;
            }
            return multiDownload.getResumeFile().getFinalSize() == this.getResumeFile().getFinalSize() && multiDownload.getResumeFile().getFilterData().searchText.equals(this.getResumeFile().getFilterData().searchText);
        }
        return false;
    }

    private final void setWaitStatus(long l) {
        if (this.runQueue.size() == 0) {
            if (this.dlQueue.size() == 0) {
                if (this.getStatus() != 10) {
                    this.setStatus(11);
                }
            } else if (this.queued.size() > 0) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(MessageFormat.format(XNap.tr("{0} queued"), new Integer(this.queued.size())));
                stringBuffer.append(": ");
                Iterator iterator = this.queued.iterator();
                while (iterator.hasNext()) {
                    IDownload iDownload = (IDownload)iterator.next();
                    stringBuffer.append(iDownload.getUser().getName());
                    stringBuffer.append("@");
                    stringBuffer.append(iDownload.getQueuePos());
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                this.nextWakeUp = 0L;
                this.setStatus(11, stringBuffer.toString());
            } else {
                this.nextWakeUp = System.currentTimeMillis() + (30000L - l);
                this.setStatus(11);
            }
        }
    }

    protected void waitForAdd(long l) {
        this.setWaitStatus(l);
        Object object = this.lock;
        synchronized (object) {
            if (this.runQueue.size() == 0) {
                if (this.dlQueue.size() == 0) {
                    AbstractTransferContainer.logger.debug("waiting for add");
                    this.nextWakeUp = 0L;
                    this.waitLock();
                } else {
                    AbstractTransferContainer.logger.debug("waiting " + (30000L - l));
                    this.waitLock(30000L - l);
                }
            }
        }
    }

    protected void waitLock(long l) {
        if (l <= 0L) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void waitLock() {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void wakeup() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    static {
        State[][] stateArray = new State[][]{{State.CONNECTING, State.ABORTING, State.DOWNLOADING, State.FAILED}, {State.LOCALLY_QUEUED, State.ABORTED, State.CONNECTING}, {State.NOT_STARTED, State.CONNECTING, State.LOCALLY_QUEUED, State.NOT_STARTED}};
        stateTable = FiniteStateMachine.createStateTable(stateArray);
    }
}

