/*
 * Decompiled with CFR 0.152.
 */
package xnap.net;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import xnap.XNap;
import xnap.io.ResumeFile3;
import xnap.io.ResumeRepository;
import xnap.net.AbstractSearchResult;
import xnap.net.AbstractTransferContainer;
import xnap.net.IDownload;
import xnap.net.IDownloadContainer;
import xnap.net.ISearch;
import xnap.net.ISearchResult;
import xnap.net.MultiDownload;
import xnap.net.SearchResultContainer;
import xnap.net.event.StatusChangeEvent;
import xnap.net.event.StatusChangeListener;
import xnap.plugin.PluginManager;
import xnap.util.FileHelper;
import xnap.util.Grouper;
import xnap.util.Preferences;
import xnap.util.SearchFilter;
import xnap.util.SearchFilterHelper;
import xnap.util.SearchResultCollector;
import xnap.util.Searcher;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

public class AutoDownload
extends MultiDownload
implements IDownloadContainer,
StatusChangeListener,
ListListener,
Runnable {
    public static long MAX_SEARCH_INTERVAL = 10800000L;
    public static final long FAILED_SEARCH_INTERVAL = 45000L;
    private SearchResultCollector srCollector;
    private SearchFilter filter;
    private SearchThread st = new SearchThread();
    private Hashtable downloads = new Hashtable();
    private ISearchResult[] orgResults = null;
    private Preferences prefs = Preferences.getInstance();
    private long searchInterval;

    public void initialize(ResumeFile3 resumeFile3) {
        AbstractTransferContainer.logger.debug("resuming " + resumeFile3);
        this.filter = new SearchFilter(SearchFilterHelper.convert(resumeFile3.getFilterData()));
        this.filter.setFilesize(resumeFile3.getFinalSize());
        this.filter.setFilesizeCompare(3);
        this.setResumeFile(resumeFile3);
        this.addStatusChangeListener(this);
        SearchFilter searchFilter = (SearchFilter)this.filter.clone();
        searchFilter.setSearchText("");
        searchFilter.setMediaType(0);
        this.srCollector = new SearchResultCollector(searchFilter, new Grouper());
        this.srCollector.getGroupedData().addListListener(this);
    }

    public boolean add(ISearchResult iSearchResult) {
        AbstractSearchResult abstractSearchResult;
        IDownload iDownload;
        if (iSearchResult.canGroup() && iSearchResult instanceof AbstractSearchResult && this.add(iDownload = (abstractSearchResult = (AbstractSearchResult)iSearchResult).getDownload())) {
            this.downloads.put(iDownload, iSearchResult);
            this.st.incDownloadCount();
            return true;
        }
        return false;
    }

    public void elementAdded(ListEvent listEvent) {
        SearchResultContainer searchResultContainer = (SearchResultContainer)listEvent.getElement();
        ISearchResult[] iSearchResultArray = searchResultContainer.getSearchResults();
        int n = 0;
        while (n < iSearchResultArray.length) {
            this.add(iSearchResultArray[n]);
            ++n;
        }
    }

    public void elementRemoved(ListEvent listEvent) {
    }

    public void die() {
        super.die();
        this.st.die();
    }

    public boolean isResumeCapable() {
        return this.filter.getSearchText().length() > 0;
    }

    public SearchFilter getSearchFilter() {
        return this.filter;
    }

    public void remove(IDownload iDownload) {
        super.remove(iDownload);
        ISearchResult iSearchResult = (ISearchResult)this.downloads.get(iDownload);
        if (iSearchResult != null) {
            AbstractTransferContainer.logger.info("download failed, removing from search results: " + iSearchResult);
            this.srCollector.remove(iSearchResult);
        }
    }

    public void statusChange(StatusChangeEvent statusChangeEvent) {
        if (this.isResumeCapable()) {
            if (this.isDone() || !this.isBusy()) {
                this.st.wakeup();
            }
        } else if (this.isDone()) {
            boolean bl = this.prefs.getDelIncompleteFiles();
            if (this.getStatus() != 6 && bl) {
                this.getFile().delete();
            }
        } else if (this.getStatus() == 11 && this.getQueueSize() == 0 && this.prefs.getLimitDownloadAttempts()) {
            this.fail("N/A");
            return;
        }
    }

    public void start() {
        this.searchInterval = Preferences.getInstance().getAutoDownloadSearchInterval() * 1000;
        this.reset();
        super.start();
        if (this.isResumeCapable()) {
            Thread thread = new Thread((Runnable)this.st, this.toString());
            thread.start();
        } else {
            this.clear();
            this.addResults(this.orgResults);
        }
    }

    public String toString() {
        File file = this.getFile();
        return "AutoDownload " + (file != null ? file.getName() : "(error)");
    }

    public void updatedSearchFilter() {
        this.setStatus(this.getStatus());
    }

    protected void addResults(ISearchResult[] iSearchResultArray) {
        if (iSearchResultArray != null) {
            int n = 0;
            while (n < iSearchResultArray.length) {
                this.add(iSearchResultArray[n]);
                ++n;
            }
        }
    }

    public AutoDownload(ResumeFile3 resumeFile3) {
        this.initialize(resumeFile3);
    }

    public AutoDownload(ISearchResult[] iSearchResultArray, SearchFilter searchFilter, File file) {
        Object object;
        ISearchResult iSearchResult = iSearchResultArray[0];
        if (file == null) {
            try {
                object = this.prefs.getIncompleteDir();
                file = FileHelper.createUnique((String)object, iSearchResult.getShortFilename());
            }
            catch (IOException iOException) {
                this.setStatus(13, XNap.tr("Could not create file, make sure the incomplete directory is writeable."));
                return;
            }
        }
        if (!file.canWrite()) {
            this.setStatus(13, XNap.tr("Can not write to incomplete file."));
            return;
        }
        object = new ResumeFile3(file, iSearchResult.getFilesize(), SearchFilterHelper.convert(searchFilter.getData()));
        ResumeRepository.getInstance().add((ResumeFile3)object);
        this.initialize((ResumeFile3)object);
        this.addResults(iSearchResultArray);
        if (searchFilter == null) {
            this.orgResults = iSearchResultArray;
        }
    }

    public AutoDownload(ISearchResult[] iSearchResultArray, SearchFilter searchFilter) {
        this(iSearchResultArray, searchFilter, null);
    }

    protected class SearchThread
    implements Runnable {
        public int downloadCount = 0;
        private int searchCount = 0;
        private Object lock = new Object();
        private boolean die = false;
        protected Searcher sr = null;
        protected long lastSearch;

        public void die() {
            this.die = true;
            this.wakeup();
        }

        public void incDownloadCount() {
            ++this.downloadCount;
        }

        public void run() {
            this.downloadCount = 0;
            this.searchCount = 0;
            this.lastSearch = 0L;
            this.die = false;
            while (!this.die && !AutoDownload.this.isDone()) {
                if (AutoDownload.this.prefs.getLimitDownloadAttempts() && this.searchCount > AutoDownload.this.prefs.getAutoDownloadMaxSearches() && AutoDownload.this.getQueueSize() == 0) {
                    AutoDownload.this.fail("N/A");
                    break;
                }
                if (!AutoDownload.this.isBusy() && this.searchCount == 0) {
                    this.doSearch();
                }
                Object object = this.lock;
                synchronized (object) {
                    while (!(this.die || AutoDownload.this.isDone() || !AutoDownload.this.isBusy() && this.waitFor() <= 0L)) {
                        if (AutoDownload.this.isBusy()) {
                            AbstractTransferContainer.logger.debug("AutoDownload: waiting");
                            this.waitLock();
                            continue;
                        }
                        AbstractTransferContainer.logger.debug("AutoDownload: waiting for " + this.waitFor());
                        this.waitLock(this.waitFor());
                    }
                }
                if (this.die || AutoDownload.this.isDone()) continue;
                this.doSearch();
            }
            this.stopSearch();
            AutoDownload.this.srCollector.clear();
            AbstractTransferContainer.logger.debug("AutoDownload: finished");
        }

        public void stopSearch() {
            if (this.sr != null) {
                this.sr.abort();
            }
        }

        public long waitFor() {
            long l = System.currentTimeMillis() - this.lastSearch;
            if (this.sr != null && this.sr.getSize() == 0) {
                return 45000L - l;
            }
            return AutoDownload.this.searchInterval - l;
        }

        public void wakeup() {
            Object object = this.lock;
            synchronized (object) {
                this.lock.notify();
            }
        }

        protected void doSearch() {
            this.stopSearch();
            AbstractTransferContainer.logger.debug("AutoDownload: searching");
            if (AutoDownload.this.getStatus() == 11 || AutoDownload.this.getStatus() == 0) {
                AutoDownload.this.setStatus(10);
            }
            ISearch[] iSearchArray = PluginManager.getInstance().search(AutoDownload.this.filter, 1);
            this.sr = new Searcher(iSearchArray, AutoDownload.this.filter, AutoDownload.this.srCollector);
            this.sr.start();
            AutoDownload autoDownload = AutoDownload.this;
            autoDownload.searchInterval = autoDownload.searchInterval * 2L;
            AutoDownload.this.searchInterval = Math.min(AutoDownload.this.searchInterval, MAX_SEARCH_INTERVAL);
            AbstractTransferContainer.logger.debug("increased search intervall: " + AutoDownload.this.searchInterval);
            ++this.searchCount;
            this.lastSearch = System.currentTimeMillis();
        }

        protected void waitLock(long l) {
            if (l <= 0L) {
                return;
            }
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        protected void waitLock() {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        SearchThread() {
        }
    }
}

