/*
 * Decompiled with CFR 0.152.
 */
package xnap.io;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.cmdl.AbstractCommand;
import xnap.cmdl.Console;
import xnap.cmdl.Executer;
import xnap.io.AbstractRepository;
import xnap.io.FileHandler;
import xnap.io.RepositoryFile;
import xnap.util.FileHelper;
import xnap.util.Preferences;
import xnap.util.StringHelper;
import xnap.util.event.StatusListener;

public class Repository
extends AbstractRepository
implements PropertyChangeListener {
    public static int VERSION = 2;
    protected static Logger logger = Logger.getLogger(class$Lxnap$io$Repository != null ? class$Lxnap$io$Repository : (class$Lxnap$io$Repository = Repository.class$("xnap.io.Repository")));
    private static Repository singleton = new Repository();
    protected Node rootNode = new Node();
    private Preferences prefs = Preferences.getInstance();
    private StatusListener listener;
    private boolean autoAddToSearchTree = true;
    private static /* synthetic */ Class class$Lxnap$io$Repository;

    public static Repository getInstance() {
        return singleton;
    }

    public void buildSearchTree() {
        if (!this.autoAddToSearchTree) {
            this.autoAddToSearchTree = true;
            int n = this.size();
            int n2 = 0;
            while (n2 < n) {
                RepositoryFile repositoryFile = this.getFile(n2);
                if (repositoryFile != null) {
                    this.addToSearchTree(repositoryFile);
                }
                ++n2;
            }
        }
    }

    public String getDirs() {
        return this.prefs.getUploadDirs();
    }

    public RepositoryFile getFile(int n) {
        return (RepositoryFile)super.get(n);
    }

    public synchronized void updateStatus() {
        if (this.listener != null) {
            if (this.isUpdateRunning()) {
                this.listener.setStatus(this.getNonNullSize() + XNap.tr("updating", 1, 0));
            } else {
                this.listener.setStatus(this.getNonNullSize() + XNap.tr("shared", 1, 0));
            }
        }
    }

    public synchronized void setStatusListener(StatusListener statusListener) {
        this.listener = statusListener;
        this.updateStatus();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (propertyChangeEvent.getPropertyName().equals("uploadDirs")) {
            this.updateLater();
        }
    }

    public File[] search(String string) {
        Object object;
        this.buildSearchTree();
        logger.info("searching for " + string);
        Object object2 = new HashSet();
        string = StringHelper.stripExtra(string);
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), " ");
        boolean bl = true;
        while (stringTokenizer.hasMoreTokens()) {
            Object object3;
            Object object4;
            object = this.rootNode;
            String string2 = stringTokenizer.nextToken();
            int n = 0;
            while (n < string2.length()) {
                object4 = new Character(string2.charAt(n));
                object = (Node)object.children.get(object4);
                if (object == null) {
                    return null;
                }
                ++n;
            }
            if (bl) {
                object3 = object.files.iterator();
                while (object3.hasNext()) {
                    ((HashSet)object2).add(object3.next());
                }
            } else {
                object3 = new HashSet();
                object4 = object.files.iterator();
                while (object4.hasNext()) {
                    Object e = object4.next();
                    if (!((HashSet)object2).contains(e)) continue;
                    ((HashSet)object3).add(e);
                }
                object2 = object3;
                if (((HashSet)object2).size() == 0) {
                    return null;
                }
            }
            bl = false;
        }
        object = new File[((HashSet)object2).size()];
        System.arraycopy(((AbstractCollection)object2).toArray(), 0, object, 0, ((File[])object).length);
        return object;
    }

    public File[] search(String string, long l) {
        File[] fileArray = this.search(string);
        LinkedList<File> linkedList = new LinkedList<File>();
        if (fileArray == null) {
            return null;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].length() == l) {
                linkedList.add(fileArray[n]);
            }
            ++n;
        }
        File[] fileArray2 = new File[linkedList.size()];
        System.arraycopy(linkedList.toArray(), 0, fileArray2, 0, fileArray2.length);
        return fileArray2;
    }

    public File getRepositoryFile(String string, int n) {
        File file;
        if (n >= 0 && n < this.size() && (file = (File)this.get(n)) != null && file.getName().equals(string)) {
            return file;
        }
        return null;
    }

    protected void addNewFile(File file) {
        if (!(file instanceof RepositoryFile)) {
            file = FileHandler.handle(file, true);
        }
        super.addNewFile(file);
        if (this.getNonNullSize() % 16 == 0) {
            this.updateStatus();
        }
        this.addToSearchTree(file);
    }

    private final void addToSearchTree(File file) {
        if (!this.autoAddToSearchTree) {
            return;
        }
        String string = StringHelper.stripExtra(file.getAbsolutePath());
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), " ");
        while (stringTokenizer.hasMoreTokens()) {
            Node node = this.rootNode;
            String string2 = stringTokenizer.nextToken();
            int n = 0;
            while (n < string2.length()) {
                Character c = new Character(string2.charAt(n));
                Node node2 = (Node)node.children.get(c);
                if (node2 == null) {
                    node2 = new Node();
                    node.children.put(c, node2);
                }
                node = node2;
                ++n;
            }
            node.files.add(file);
        }
    }

    protected boolean isPartOfRepository(File file) {
        if (file.getName().startsWith(".")) {
            return false;
        }
        if (file.isDirectory()) {
            return !file.equals(new File(this.prefs.getIncompleteDir()));
        }
        return true;
    }

    protected void preRead() {
        this.updateStatus();
    }

    protected void postRead(boolean bl, String string) {
        this.allowWrite = true;
    }

    protected void preUpdate() {
        this.updateStatus();
    }

    protected void postUpdate() {
        this.updateStatus();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Repository() {
        super(FileHelper.getHomeDir() + "shared", VERSION);
        this.readAndUpdateLater();
        Preferences.getInstance().addPropertyChangeListener(this);
        Executer.addCommand(new ListCmd());
        Executer.addCommand(new UpdateCmd());
    }

    protected class ListCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            int n = 0;
            Iterator iterator = Repository.this.iterator();
            while (iterator.hasNext()) {
                RepositoryFile repositoryFile = (RepositoryFile)iterator.next();
                if (repositoryFile != null) {
                    Console.getInstance().println(n + ": " + repositoryFile.getName());
                }
                ++n;
            }
            return true;
        }

        public ListCmd() {
            this.putValue("cmd", new String[]{"listrepository"});
            this.putValue("shortHelp", "Shows the repository.");
        }
    }

    protected class UpdateCmd
    extends AbstractCommand {
        public boolean execute(String[] stringArray) {
            Repository.this.updateLater();
            return true;
        }

        public UpdateCmd() {
            this.putValue("cmd", new String[]{"updaterepository"});
            this.putValue("shortHelp", "Updates the repository.");
        }
    }

    protected class Node {
        public HashSet files = new HashSet();
        public Hashtable children = new Hashtable();

        Node() {
        }
    }
}

