/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import xnap.XNap;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.table.FilesizeCellRenderer;
import xnap.gui.table.ProgressCellRenderer;
import xnap.gui.table.StringCellRenderer;
import xnap.gui.table.TimeCellRenderer;
import xnap.gui.util.SwingSynchronizedCache;
import xnap.net.ITransferContainer;
import xnap.net.IUser;
import xnap.net.event.StatusChangeEvent;
import xnap.net.event.StatusChangeListener;
import xnap.util.EventVector;
import xnap.util.Preferences;
import xnap.util.Progress;
import xnap.util.TransferQueue;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

public class TransferTableModel
extends AbstractDynamicTableModel
implements ListListener,
StatusChangeListener {
    public static final int UPDATE_INTERVAL = 1000;
    public static final int FILENAME = 0;
    public static final int FILESIZE = 1;
    public static final int USER = 2;
    public static final int CLIENT_INFO = 3;
    public static final int STATUS = 4;
    public static final int PROGRESS = 5;
    public static final int TIMELEFT = 6;
    public static final int PARTIAL_FILESIZE = 7;
    private static Timer updateTimer = null;
    protected Column[] columns = new Column[]{new Column(XNap.tr("Filename"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TransferTableModel.class$("java.lang.String")), new StringCellRenderer()), new Column(XNap.tr("Size"), class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = TransferTableModel.class$("java.lang.Long")), new FilesizeCellRenderer()), new Column(XNap.tr("User"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TransferTableModel.class$("java.lang.String"))), new Column(XNap.tr("Client"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TransferTableModel.class$("java.lang.String"))), new Column(XNap.tr("Status"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = TransferTableModel.class$("java.lang.String")), new StringCellRenderer()), new Column(XNap.tr("Progress"), class$Lxnap$util$Progress != null ? class$Lxnap$util$Progress : (class$Lxnap$util$Progress = TransferTableModel.class$("xnap.util.Progress")), new ProgressCellRenderer()), new Column(XNap.tr("Time Left"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = TransferTableModel.class$("java.lang.Integer")), new TimeCellRenderer()), new Column(XNap.tr("Transfered"), class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = TransferTableModel.class$("java.lang.Long")), new FilesizeCellRenderer())};
    protected ArrayList rows = new ArrayList();
    private TransferQueue queue;
    private boolean updateQueue = false;
    private String tableName;
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Lxnap$util$Progress;
    private static /* synthetic */ Class class$Ljava$lang$Integer;

    public void elementAdded(ListEvent listEvent) {
        ITransferContainer iTransferContainer = (ITransferContainer)listEvent.getElement();
        iTransferContainer.addStatusChangeListener(this);
        this.rows.add(iTransferContainer);
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void elementRemoved(ListEvent listEvent) {
        ITransferContainer iTransferContainer = (ITransferContainer)listEvent.getElement();
        iTransferContainer.removeStatusChangeListener(this);
        int n = this.rows.indexOf(iTransferContainer);
        if (n != -1) {
            this.rows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public TransferQueue getQueue() {
        return this.queue;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public ITransferContainer get(int n) {
        return (ITransferContainer)this.rows.get(this.mapToIndex(n));
    }

    public Object get(int n, int n2) {
        if (this.rows.get(n) instanceof ITransferContainer) {
            ITransferContainer iTransferContainer = (ITransferContainer)this.rows.get(n);
            if (iTransferContainer == null) {
                return null;
            }
            IUser iUser = iTransferContainer.getUser();
            switch (n2) {
                case 0: {
                    return iTransferContainer.getFilename();
                }
                case 1: {
                    return new Long(iTransferContainer.getFilesize());
                }
                case 2: {
                    return iUser != null ? iUser.getName() : "";
                }
                case 3: {
                    return iUser != null ? iUser.getClientInfo() : "";
                }
                case 4: {
                    return iTransferContainer.getStatusText();
                }
                case 5: {
                    return new Progress(iTransferContainer.getTotalBytesTransferred(), iTransferContainer.getFilesize(), iTransferContainer.getCurrentRate());
                }
                case 6: {
                    long l = iTransferContainer.getAverageRate();
                    if (l <= 0L) {
                        return new Integer(-1);
                    }
                    return new Integer((int)((iTransferContainer.getFilesize() - iTransferContainer.getTotalBytesTransferred()) / l));
                }
                case 7: {
                    return new Long(iTransferContainer.getTotalBytesTransferred());
                }
            }
        }
        return null;
    }

    public String getTableName() {
        return this.tableName;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setUpdateQueue(boolean bl) {
        this.updateQueue = bl;
    }

    public void statusChange(StatusChangeEvent statusChangeEvent) {
        ITransferContainer iTransferContainer = (ITransferContainer)statusChangeEvent.getSource();
        if (statusChangeEvent.getNewStatus() != 4 && statusChangeEvent.getNewStatus() != 5) {
            SwingUtilities.invokeLater(new StatusChangeEventHandler(iTransferContainer));
        }
    }

    public void updateTable() {
        long l = 0L;
        int n = 0;
        while (n < this.rows.size()) {
            ITransferContainer iTransferContainer = (ITransferContainer)this.rows.get(n);
            if (iTransferContainer.getStatus() == 4 || iTransferContainer.getStatus() == 5 || iTransferContainer.getStatus() == 11) {
                this.fireTableRowsUpdated(n, n);
                if (iTransferContainer.getStatus() != 11) {
                    l += iTransferContainer.getCurrentRate();
                }
            }
            ++n;
        }
        if (this.updateQueue) {
            this.getQueue().setCurrentRate(l);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TransferTableModel(TransferQueue transferQueue, String string, String string2, EventVector eventVector) {
        super(string, Preferences.getInstance());
        this.queue = transferQueue;
        this.tableName = string2;
        SwingSynchronizedCache swingSynchronizedCache = new SwingSynchronizedCache(this);
        eventVector.addListListener(swingSynchronizedCache);
        this.setColumns(this.columns);
        if (updateTimer == null) {
            updateTimer = new Timer(1000, new Updater());
            updateTimer.start();
        } else {
            updateTimer.addActionListener(new Updater());
        }
    }

    public TransferTableModel(TransferQueue transferQueue, String string, String string2) {
        this(transferQueue, string, string2, transferQueue);
        this.setUpdateQueue(true);
    }

    private class Updater
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            TransferTableModel.this.updateTable();
        }

        Updater() {
        }
    }

    private class StatusChangeEventHandler
    implements Runnable {
        ITransferContainer item;

        public void run() {
            int n = 0;
            while (n < TransferTableModel.this.rows.size()) {
                if (TransferTableModel.this.rows.get(n).equals(this.item)) {
                    TransferTableModel.this.fireTableRowsUpdated(n, n);
                }
                ++n;
            }
        }

        public StatusChangeEventHandler(ITransferContainer iTransferContainer) {
            this.item = iTransferContainer;
        }
    }
}

