/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.table;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import xnap.XNap;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.table.FilesizeCellRenderer;
import xnap.gui.table.LinkSpeedCellRenderer;
import xnap.gui.table.NumberCellRenderer;
import xnap.gui.table.ScoreCellRenderer;
import xnap.gui.table.StringCellRenderer;
import xnap.gui.table.TimeCellRenderer;
import xnap.gui.util.SwingSynchronizedCache;
import xnap.net.SearchResultContainer;
import xnap.util.EventVector;
import xnap.util.FileHelper;
import xnap.util.Preferences;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

public class SearchTableModel
extends AbstractDynamicTableModel
implements Observer,
ListListener {
    public static final int FILENAME = 0;
    public static final int PATH = 1;
    public static final int FILESIZE = 2;
    public static final int BITRATE = 3;
    public static final int FREQUENCY = 4;
    public static final int LENGTH = 5;
    public static final int USER = 6;
    public static final int LINKSPEED = 7;
    public static final int PLUGIN = 8;
    public static final int STATUS = 9;
    public static final int SCORE = 10;
    public static final int TYPE = 11;
    protected Column[] columns = new Column[]{new Column(XNap.tr("Filename"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SearchTableModel.class$("java.lang.String")), new StringCellRenderer()), new Column(XNap.tr("Path"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SearchTableModel.class$("java.lang.String")), new StringCellRenderer()), new Column(XNap.tr("Filesize"), class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = SearchTableModel.class$("java.lang.Long")), new FilesizeCellRenderer()), new Column(XNap.tr("Bitrate"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = SearchTableModel.class$("java.lang.Integer")), new NumberCellRenderer()), new Column(XNap.tr("Frequency"), class$Ljava$lang$Double != null ? class$Ljava$lang$Double : (class$Ljava$lang$Double = SearchTableModel.class$("java.lang.Double")), new NumberCellRenderer(1)), new Column(XNap.tr("Length"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = SearchTableModel.class$("java.lang.Integer")), new TimeCellRenderer()), new Column(XNap.tr("User"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SearchTableModel.class$("java.lang.String"))), new Column(XNap.tr("Link Speed"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = SearchTableModel.class$("java.lang.Integer")), new LinkSpeedCellRenderer()), new Column(XNap.tr("Plugin"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SearchTableModel.class$("java.lang.String"))), new Column(XNap.tr("Status"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SearchTableModel.class$("java.lang.String")), new StringCellRenderer()), new Column(XNap.tr("Availability"), class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = SearchTableModel.class$("java.lang.Integer")), new ScoreCellRenderer()), new Column(XNap.tr("Type"), class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = SearchTableModel.class$("java.lang.String")), new StringCellRenderer())};
    private ArrayList rows = new ArrayList();
    private SwingSynchronizedCache cache = new SwingSynchronizedCache(this);
    private static /* synthetic */ Class class$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Long;
    private static /* synthetic */ Class class$Ljava$lang$Integer;
    private static /* synthetic */ Class class$Ljava$lang$Double;

    public SearchResultContainer get(int n) {
        return (SearchResultContainer)this.rows.get(this.mapToIndex(n));
    }

    public String getTableName() {
        return XNap.tr("Search Table");
    }

    public void setFilteredData(EventVector eventVector) {
        eventVector.addListListener(this.cache);
    }

    public void elementAdded(ListEvent listEvent) {
        if (listEvent.getElement() instanceof Observable) {
            Observable observable = (Observable)listEvent.getElement();
            observable.addObserver(this);
        }
        this.rows.add(listEvent.getElement());
        this.fireTableRowsInserted(this.rows.size() - 1, this.rows.size() - 1);
    }

    public void elementRemoved(ListEvent listEvent) {
        if (listEvent.getID() == 3) {
            int n = this.rows.size();
            if (n > 0) {
                Iterator iterator = ((AbstractList)this.rows).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (!(e instanceof Observable)) continue;
                    Observable observable = (Observable)e;
                    observable.deleteObserver(this);
                }
                this.rows.clear();
                this.fireTableRowsDeleted(0, n - 1);
            }
        } else {
            int n = this.rows.indexOf(listEvent.getElement());
            if (n != -1) {
                if (listEvent.getElement() instanceof Observable) {
                    Observable observable = (Observable)listEvent.getElement();
                    observable.deleteObserver(this);
                }
                this.rows.remove(n);
                this.fireTableRowsDeleted(n, n);
            }
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object get(int n, int n2) {
        if (n >= this.rows.size()) {
            return null;
        }
        SearchResultContainer searchResultContainer = (SearchResultContainer)this.rows.get(n);
        if (searchResultContainer == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return searchResultContainer.getShortFilename();
            }
            case 2: {
                return new Long(searchResultContainer.getFilesize());
            }
            case 3: {
                return new Integer(searchResultContainer.getBitrate());
            }
            case 4: {
                return new Double((double)searchResultContainer.getFrequency() / 1000.0);
            }
            case 5: {
                return new Integer(searchResultContainer.getLength());
            }
            case 6: {
                return searchResultContainer.getUsername();
            }
            case 7: {
                return new Integer(searchResultContainer.getLinkSpeed());
            }
            case 10: {
                return new Integer(searchResultContainer.getScore());
            }
            case 1: {
                return searchResultContainer.getPath();
            }
            case 9: {
                return searchResultContainer.getStatus();
            }
            case 8: {
                return searchResultContainer.getPlugin();
            }
            case 11: {
                return FileHelper.extension(searchResultContainer.getShortFilename());
            }
        }
        return "";
    }

    public void update(Observable observable, Object object) {
        if (object instanceof SearchResultContainer) {
            SwingUtilities.invokeLater(new StatusChangeEventHandler(object));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public SearchTableModel() {
        super("search", Preferences.getInstance());
        this.setColumns(this.columns);
    }

    protected SearchTableModel(String string, Preferences preferences) {
        super(string, preferences);
    }

    private class StatusChangeEventHandler
    implements Runnable {
        Object item;

        public void run() {
            int n = SearchTableModel.this.rows.indexOf(this.item);
            if (n != -1) {
                SearchTableModel.this.fireTableRowsUpdated(n, n);
            }
        }

        public StatusChangeEventHandler(Object object) {
            this.item = object;
        }
    }
}

