/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import xnap.XNap;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.EnableAction;
import xnap.gui.GridBagHelper;
import xnap.gui.ValidatedTextField;
import xnap.gui.XNapFrame;

public class SearchPrefsPanel
extends AbstractPreferencesPanel {
    private JCheckBox jcRemoveDuplicateResults;
    private JCheckBox jcFilterResults;
    private JCheckBox jcStoppingDownloads;
    private ValidatedTextField jteAutoSearchInterval;
    private EnableAction acLimitDownloadAttempts;
    private ValidatedTextField jtfMaxAutoSearches;

    public void apply() {
        AbstractPreferencesPanel.prefs.setRemoveDuplicateResults(this.jcRemoveDuplicateResults.isSelected());
        AbstractPreferencesPanel.prefs.setFilterResults(this.jcFilterResults.isSelected());
        AbstractPreferencesPanel.prefs.setAutoDownloadSearchInterval(this.jteAutoSearchInterval.getIntValue() * 60);
        AbstractPreferencesPanel.prefs.setLimitDownloadAttempts(this.acLimitDownloadAttempts.isSelected());
        AbstractPreferencesPanel.prefs.setAutoDownloadMaxSearches(this.jtfMaxAutoSearches.getIntValue());
    }

    public Icon getIcon() {
        return XNapFrame.getIcon("find.png");
    }

    public String getTitle() {
        return XNap.tr("Search");
    }

    public SearchPrefsPanel() {
        this.setLayout(new GridBagLayout());
        this.jcRemoveDuplicateResults = new JCheckBox(XNap.tr("Remove duplicate search results", 1), AbstractPreferencesPanel.prefs.getRemoveDuplicateResults());
        GridBagHelper.add((Container)this, this.jcRemoveDuplicateResults);
        this.jcFilterResults = new JCheckBox(XNap.tr("Double filter results", 1), AbstractPreferencesPanel.prefs.getFilterResults());
        GridBagHelper.add((Container)this, this.jcFilterResults);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(XNap.tr("Automatic Downloading", 1)));
        GridBagHelper.addLabel(jPanel, XNap.tr("Search Interval (minutes)", 1));
        this.jteAutoSearchInterval = new ValidatedTextField(AbstractPreferencesPanel.prefs.getAutoDownloadSearchInterval() / 60 + "", 5, "0123456789");
        GridBagHelper.add(jPanel, this.jteAutoSearchInterval, false);
        this.jtfMaxAutoSearches = new ValidatedTextField(AbstractPreferencesPanel.prefs.getAutoDownloadMaxSearches() + "", 5, "0123456789");
        this.acLimitDownloadAttempts = new EnableAction(XNap.tr("Limit Search Attempts"), new Component[]{this.jtfMaxAutoSearches}, AbstractPreferencesPanel.prefs.getLimitDownloadAttempts());
        GridBagHelper.addComponent(jPanel, this.acLimitDownloadAttempts.getCheckBox());
        GridBagHelper.add(jPanel, this.jtfMaxAutoSearches, false);
        GridBagHelper.add((Container)this, jPanel);
        GridBagHelper.addVerticalSpacer(this);
    }
}

