/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import xnap.XNap;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.GridBagHelper;
import xnap.gui.ValidatedTextField;
import xnap.gui.XNapFrame;
import xnap.gui.util.GUIHelper;

public class PersonalPrefsPanel
extends AbstractPreferencesPanel {
    private ValidatedTextField jteUsername;
    private ValidatedTextField jtePassword;
    private ValidatedTextField jteEmail;
    private JComboBox jcbLanguage;
    private JCheckBox jcAutoVersionCheck;
    private JCheckBox jcEmacsKeyBindings;
    private JCheckBox jcbAutoCompletion;

    public void apply() {
        AbstractPreferencesPanel.prefs.setUsername(this.jteUsername.getText());
        AbstractPreferencesPanel.prefs.setPassword(this.jtePassword.getText());
        AbstractPreferencesPanel.prefs.setEmail(this.jteEmail.getText());
        AbstractPreferencesPanel.prefs.setLanguage(((Locale)this.jcbLanguage.getSelectedItem()).getLanguage());
        AbstractPreferencesPanel.prefs.setAutoVersionCheck(this.jcAutoVersionCheck.isSelected());
        AbstractPreferencesPanel.prefs.setUseEmacsKeyBindings(this.jcEmacsKeyBindings.isSelected());
        AbstractPreferencesPanel.prefs.setAutoComplete(this.jcbAutoCompletion.isSelected());
    }

    public Icon getIcon() {
        return XNapFrame.getIcon("gohome.png");
    }

    public String getTitle() {
        return XNap.tr("Personal");
    }

    public PersonalPrefsPanel() {
        this.setLayout(new GridBagLayout());
        GridBagHelper.addLabel(this, XNap.tr("Username"));
        this.jteUsername = new ValidatedTextField(AbstractPreferencesPanel.prefs.getUsername(), 20, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.@_-&");
        GridBagHelper.add((Container)this, this.jteUsername);
        GridBagHelper.addLabel(this, XNap.tr("Password"));
        this.jtePassword = new ValidatedTextField(AbstractPreferencesPanel.prefs.getPassword(), 20, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.@_-&");
        GridBagHelper.add((Container)this, this.jtePassword);
        GridBagHelper.addLabel(this, XNap.tr("Email"));
        this.jteEmail = new ValidatedTextField(AbstractPreferencesPanel.prefs.getEmail(), 20, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789.@_-&");
        GridBagHelper.add((Container)this, this.jteEmail);
        GridBagHelper.addLabel(this, XNap.tr("Language"));
        this.jcbLanguage = new JComboBox();
        this.jcbLanguage.setRenderer(new LocaleCellRenderer());
        this.jcbLanguage.addItem(new Locale("", "", ""));
        int n = 0;
        while (n < XNap.LANGUAGES.length) {
            this.jcbLanguage.addItem(XNap.LANGUAGES[n]);
            if (AbstractPreferencesPanel.prefs.getLanguage().equals(XNap.LANGUAGES[n].getLanguage())) {
                this.jcbLanguage.setSelectedIndex(n + 1);
            }
            ++n;
        }
        GridBagHelper.add(this, this.jcbLanguage, false);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(XNap.tr("Miscellaneous", 1)));
        this.jcAutoVersionCheck = new JCheckBox(XNap.tr("Check for New Version", 1), AbstractPreferencesPanel.prefs.getAutoVersionCheck());
        GridBagHelper.add((Container)jPanel, this.jcAutoVersionCheck);
        this.jcEmacsKeyBindings = new JCheckBox(XNap.tr("Use Emacs Keybindings", 1), AbstractPreferencesPanel.prefs.getUseEmacsKeyBindings());
        this.jcEmacsKeyBindings.setToolTipText(GUIHelper.tt(XNap.tr("Enables the essential Emacs keybindings to facilitate editing text.<br><small>(see FAQ for list of features)</small>")));
        GridBagHelper.add((Container)jPanel, this.jcEmacsKeyBindings);
        this.jcbAutoCompletion = new JCheckBox(XNap.tr("Auto Completion", 1), AbstractPreferencesPanel.prefs.getAutoComplete());
        this.jcbAutoCompletion.setToolTipText(GUIHelper.tt(XNap.tr("Activate completion of user input for all search fields which have a <b>history</b>.")));
        GridBagHelper.add((Container)jPanel, this.jcbAutoCompletion);
        GridBagHelper.add((Container)this, jPanel);
        GridBagHelper.addVerticalSpacer(this);
    }

    protected class LocaleCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = ((Locale)object).getDisplayLanguage();
            this.setText(string.length() > 0 ? string : XNap.tr("System Default"));
            return this;
        }

        LocaleCellRenderer() {
        }
    }
}

