/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.prefs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import xnap.XNap;
import xnap.gui.AbstractPreferencesPanel;
import xnap.gui.GridBagHelper;
import xnap.gui.ThemeManager;
import xnap.gui.table.AbstractDynamicTableModel;
import xnap.gui.table.Column;
import xnap.gui.theme.Theme;
import xnap.util.Debug;
import xnap.util.Preferences;

public class LookAndFeelPrefsPanel
extends AbstractPreferencesPanel
implements ListSelectionListener {
    private DefaultListModel dlmLafs;
    private JList jlLafs;
    private DefaultListModel dlmThemes;
    private JList jlThemes;
    private JPanel jpPreview;
    private int lastIndex = 0;
    private ConfigureThemeAction acConfigureTheme = new ConfigureThemeAction();
    private Object[] data = new Object[]{"Berlin", "Bremen", "Hamburg", "Muenchen", "Stuttgart"};
    private static /* synthetic */ Class class$Ljava$lang$String;

    public void initializeLists() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = ThemeManager.getInstalledLookAndFeels();
        String string = UIManager.getLookAndFeel().getClass().getName();
        int n = 0;
        while (n < lookAndFeelInfoArray.length) {
            this.dlmLafs.addElement(new MyLookAndFeelInfo(lookAndFeelInfoArray[n]));
            if (string.equals(lookAndFeelInfoArray[n].getClassName())) {
                this.jlLafs.setSelectedIndex(n);
                this.jlLafs.ensureIndexIsVisible(n);
                this.lastIndex = n;
            }
            ++n;
        }
        this.jlLafs.addListSelectionListener(this);
        Theme[] themeArray = ThemeManager.getThemes();
        String string2 = Preferences.getInstance().getTheme();
        int n2 = 0;
        while (n2 < themeArray.length) {
            this.dlmThemes.addElement(themeArray[n2]);
            if (string2.equals(themeArray[n2].getClassName())) {
                this.jlThemes.setSelectedIndex(n2);
                this.jlThemes.ensureIndexIsVisible(n2);
            }
            ++n2;
        }
        this.jlThemes.addListSelectionListener(this);
        this.acConfigureTheme.setEnabled(this.getSelectedTheme().isConfigurable());
    }

    public void apply() {
        AbstractPreferencesPanel.prefs.setLookAndFeel(this.getSelectedLaf().getClassName());
        AbstractPreferencesPanel.prefs.setTheme(this.getSelectedTheme().getClassName());
    }

    public Icon getIcon() {
        return null;
    }

    public UIManager.LookAndFeelInfo getSelectedLaf() {
        return ((MyLookAndFeelInfo)this.jlLafs.getSelectedValue()).info;
    }

    public Theme getSelectedTheme() {
        return (Theme)this.jlThemes.getSelectedValue();
    }

    public String getTitle() {
        return XNap.tr("Look & Feel");
    }

    public void updateTheme() {
        Object[] objectArray = ThemeManager.getDefaults();
        ThemeManager.setTheme(this.getSelectedTheme());
        SwingUtilities.updateComponentTreeUI(this.jpPreview);
        ThemeManager.setDefaults(objectArray);
        this.acConfigureTheme.setEnabled(this.getSelectedTheme().isConfigurable());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.jlLafs) {
            String string = UIManager.getLookAndFeel().getClass().getName();
            try {
                UIManager.setLookAndFeel(this.getSelectedLaf().getClassName());
            }
            catch (Exception exception) {
                Debug.log("could not load look and feel");
                exception.printStackTrace(System.out);
                JOptionPane.showMessageDialog(this, XNap.tr("Sorry, not supported or not installed"), "Look and Feel", 0);
                int n = this.jlLafs.getSelectedIndex();
                this.jlLafs.setSelectedIndex(n == this.dlmLafs.size() - 1 ? 0 : n + 1);
                return;
            }
            SwingUtilities.updateComponentTreeUI(this.jpPreview);
            this.lastIndex = this.jlLafs.getSelectedIndex();
            try {
                UIManager.setLookAndFeel(string);
            }
            catch (Exception exception) {}
        } else if (listSelectionEvent.getSource() == this.jlThemes) {
            this.updateTheme();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public LookAndFeelPrefsPanel() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(XNap.tr("Look and Feel")), "North");
        this.dlmLafs = new DefaultListModel();
        this.jlLafs = new JList(this.dlmLafs);
        this.jlLafs.setVisibleRowCount(4);
        JScrollPane jScrollPane = new JScrollPane(this.jlLafs);
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)new JLabel(XNap.tr("Theme")), "North");
        this.dlmThemes = new DefaultListModel();
        this.jlThemes = new JList(this.dlmThemes);
        this.jlThemes.setVisibleRowCount(4);
        JScrollPane jScrollPane2 = new JScrollPane(this.jlThemes);
        jPanel2.add((Component)jScrollPane2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(jPanel);
        jPanel3.add(Box.createHorizontalStrut(5));
        jPanel3.add(jPanel2);
        GridBagHelper.add((Container)this, jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(2, 5, 0));
        JButton jButton = new JButton(this.acConfigureTheme);
        jPanel4.add(jButton);
        GridBagHelper.add((Container)this, jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(new JLabel("I am a Label"));
        jPanel5.add(new JButton("I am a button"));
        jPanel5.add(new JCheckBox("I am a check box"));
        jPanel5.add(new JRadioButton("I am a radio"));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        JSlider jSlider = new JSlider(0, 0, 10, 3);
        jSlider.setSnapToTicks(true);
        jSlider.setPreferredSize(new Dimension(50, 50));
        jPanel6.add(jSlider);
        JScrollBar jScrollBar = new JScrollBar(0, 5, 2, 0, 10);
        jPanel6.add(jScrollBar);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab("Controls", jPanel5);
        jTabbedPane.addTab("Slider", jPanel6);
        JTable jTable = new MyTableModel().createJTable();
        jTable.setPreferredScrollableViewportSize(new Dimension(50, 50));
        JScrollPane jScrollPane3 = new JScrollPane(jTable);
        JTree jTree = new JTree();
        jTree.setVisibleRowCount(4);
        JScrollPane jScrollPane4 = new JScrollPane(jTree);
        this.jpPreview = new JPanel(new GridLayout(1, 3, 10, 10));
        this.jpPreview.add(jTabbedPane);
        this.jpPreview.add(jScrollPane3);
        this.jpPreview.add(jScrollPane4);
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.setBorder(new TitledBorder(XNap.tr("Preview", 1)));
        jPanel7.add((Component)this.jpPreview, "Center");
        GridBagHelper.add((Container)this, jPanel7);
        GridBagHelper.addVerticalSpacer(this);
        this.initializeLists();
    }

    class MyLookAndFeelInfo {
        public UIManager.LookAndFeelInfo info;

        public String getClassName() {
            return this.info.getClassName();
        }

        public String toString() {
            return this.info.getName();
        }

        public MyLookAndFeelInfo(UIManager.LookAndFeelInfo lookAndFeelInfo) {
            this.info = lookAndFeelInfo;
        }
    }

    private class MyTableModel
    extends AbstractDynamicTableModel {
        private Column[] columns;
        private Object[][] data;

        public Object get(int n, int n2) {
            return this.data[n][n2];
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getTableName() {
            return "";
        }

        public void set(Object object, int n, int n2) {
        }

        public MyTableModel() {
            Class clazz;
            Class clazz2;
            Column[] columnArray = new Column[2];
            if (class$Ljava$lang$String != null) {
                clazz2 = class$Ljava$lang$String;
            } else {
                Class clazz3 = LookAndFeelPrefsPanel.class$("java.lang.String");
                clazz2 = clazz3;
                class$Ljava$lang$String = clazz3;
            }
            columnArray[0] = new Column("Operating System", clazz2);
            if (class$Ljava$lang$String != null) {
                clazz = class$Ljava$lang$String;
            } else {
                Class clazz4 = LookAndFeelPrefsPanel.class$("java.lang.String");
                clazz = clazz4;
                class$Ljava$lang$String = clazz4;
            }
            columnArray[1] = new Column("License", clazz);
            this.columns = columnArray;
            this.data = new Object[][]{{"Linux", "GPL"}, {"FreeBSD", "BSD License"}};
            this.setColumns(this.columns);
            this.fireTableDataChanged();
        }
    }

    private class ConfigureThemeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            if (LookAndFeelPrefsPanel.this.getSelectedTheme().showConfigurationDialog(LookAndFeelPrefsPanel.this)) {
                LookAndFeelPrefsPanel.this.updateTheme();
            }
        }

        public ConfigureThemeAction() {
            this.putValue("Name", XNap.tr("Configure Theme") + "...");
            this.putValue("ShortDescription", XNap.tr("Opens the theme configuration dialog"));
            this.putValue("MnemonicKey", new Integer(67));
        }
    }
}

