/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.menu;

import java.awt.Component;
import java.awt.Container;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.log4j.Logger;
import xnap.XNap;
import xnap.gui.UserActionManager;
import xnap.gui.XNapFrame;
import xnap.gui.event.UserSupport;
import xnap.net.IUser;
import xnap.util.LinkSpeed;

public class UserMenu
extends JMenu {
    private static Logger logger = Logger.getLogger(class$Lxnap$gui$menu$UserMenu != null ? class$Lxnap$gui$menu$UserMenu : (class$Lxnap$gui$menu$UserMenu = UserMenu.class$("xnap.gui.menu.UserMenu")));
    private UserSupport us;
    private LinkedList addedComponents = new LinkedList();
    private boolean dynamic;
    private static /* synthetic */ Class class$Lxnap$gui$menu$UserMenu;

    public void addActions(IUser[] iUserArray) {
        if (iUserArray == null || iUserArray.length == 0) {
            this.addDummy();
            return;
        }
        if (iUserArray.length == 1) {
            this.addUser(this, iUserArray[0], !this.dynamic);
        } else {
            int n;
            Container container;
            HashSet<IUser> hashSet = new HashSet<IUser>(Arrays.asList(iUserArray));
            iUserArray = new IUser[hashSet.size()];
            iUserArray = ((AbstractCollection)hashSet).toArray(iUserArray);
            Arrays.sort(iUserArray, new UserComparator());
            HashMap hashMap = this.createMenuByUser(iUserArray);
            int n2 = 0;
            while (n2 < iUserArray.length) {
                container = this.getMenuByUser(hashMap, iUserArray[n2]);
                this.addUser(container, iUserArray[n2], true);
                ++n2;
            }
            AbstractAction[] abstractActionArray = hashMap.values().iterator();
            while (abstractActionArray.hasNext()) {
                container = (Container)abstractActionArray.next();
                int n3 = n = container instanceof JMenu ? ((JMenu)container).getItemCount() : container.getComponentCount();
                if (container == this || n != 0) continue;
                this.removeComponent(this, container);
            }
            abstractActionArray = UserActionManager.getInstance().getActions(iUserArray);
            if (abstractActionArray.length > 0) {
                container = new JMenu(XNap.tr("All Users") + " (" + iUserArray.length + ")");
                n = 0;
                while (n < abstractActionArray.length) {
                    ((JMenu)container).add(abstractActionArray[n]);
                    ++n;
                }
                this.addComponent(this, new JPopupMenu.Separator());
                this.addComponent(this, container);
            }
        }
    }

    protected void addComponent(Container container, Component component) {
        container.add(component);
        if (container == this) {
            this.addedComponents.add(component);
        }
    }

    protected void addDummy() {
        this.addComponent(this, new JMenuItem("(" + XNap.tr("No Users Selected") + ")"));
    }

    protected void addLabel(Container container, String string) {
        this.addComponent(container, new JLabel(string));
    }

    protected void addUser(Container object, IUser iUser, boolean bl) {
        Object object2;
        if (bl) {
            object2 = new JMenu(iUser.getName());
            this.addComponent((Container)object, (Component)object2);
            object = object2;
        }
        if (((AbstractAction[])(object2 = UserActionManager.getInstance().getActions(iUser))).length == 0) {
            object.setEnabled(false);
        } else {
            int n = 0;
            while (n < ((AbstractAction[])object2).length) {
                this.addComponent((Container)object, new JMenuItem(object2[n]));
                ++n;
            }
            this.addUserInfo((Container)object, iUser);
        }
    }

    public void addUserInfo(Container container, IUser iUser) {
        if (iUser.getClientInfo() != null) {
            this.addComponent(container, new JPopupMenu.Separator());
            this.addLabel(container, " " + XNap.tr("Client") + ": " + iUser.getClientInfo());
            if (iUser.getFileCount() != -1) {
                this.addLabel(container, " " + XNap.tr("File Count") + ": " + iUser.getFileCount());
            }
            LinkSpeed linkSpeed = new LinkSpeed(iUser.getLinkSpeed());
            this.addLabel(container, " " + XNap.tr("Link Speed") + ": " + linkSpeed.toString());
        }
    }

    protected HashMap createMenuByUser(IUser[] iUserArray) {
        HashMap<Object, JMenu> hashMap = new HashMap<Object, JMenu>();
        if (iUserArray.length <= 10) {
            hashMap.put(null, this);
        } else {
            int n = Math.min(iUserArray.length / 10, 26);
            char c = 'A';
            int n2 = 1;
            while (n2 < n && c <= 'Z') {
                char c2 = (char)(65 + n2 * (26 / n) - 1);
                this.createMenu(hashMap, c, c2);
                c = (char)(c2 + '\u0001');
                ++n2;
            }
            this.createMenu(hashMap, c, 'Z');
            JMenu jMenu = new JMenu(XNap.tr("Other"));
            hashMap.put(null, jMenu);
            this.addComponent(this, jMenu);
        }
        return hashMap;
    }

    protected void createMenu(HashMap hashMap, char c, char c2) {
        String string = c + (c != c2 ? " - " + c2 : "");
        JMenu jMenu = new JMenu(string);
        this.addComponent(this, jMenu);
        char c3 = c;
        while (c3 <= c2) {
            hashMap.put(new Character(c3).toString(), jMenu);
            c3 = (char)(c3 + '\u0001');
        }
    }

    protected Container getMenuByUser(HashMap hashMap, IUser iUser) {
        JMenu jMenu;
        String string = iUser.getName();
        if (string.length() > 0 && (jMenu = (JMenu)hashMap.get(string.substring(0, 1).toUpperCase())) != null) {
            return jMenu;
        }
        return (Container)hashMap.get(null);
    }

    protected void removeComponent(Container container, Component component) {
        container.remove(component);
        if (container == this) {
            this.addedComponents.remove(component);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public UserMenu(UserSupport userSupport, boolean bl) {
        super(XNap.tr("Users"));
        this.us = userSupport;
        this.dynamic = bl;
        this.setIcon(XNapFrame.getIcon("users.png"));
        this.setToolTipText(XNap.tr("User options"));
        this.getPopupMenu().addPopupMenuListener(new PopupListener());
        this.addDummy();
    }

    public UserMenu(UserSupport userSupport) {
        this(userSupport, false);
    }

    protected class PopupListener
    implements PopupMenuListener {
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Iterator iterator = UserMenu.this.addedComponents.iterator();
            while (iterator.hasNext()) {
                UserMenu.this.remove((Component)iterator.next());
            }
            UserMenu.this.addedComponents.clear();
            UserMenu.this.addActions(UserMenu.this.us.getUsers());
        }

        PopupListener() {
        }
    }

    public class UserComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            IUser iUser = (IUser)object;
            IUser iUser2 = (IUser)object2;
            return iUser.getName().compareToIgnoreCase(iUser2.getName());
        }
    }
}

