/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui.event;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTree;

public class PopupListener
extends MouseAdapter {
    private JPopupMenu popup;

    public void mousePressed(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.showPopup(mouseEvent);
    }

    protected void showPopup(Component component, int n, int n2) {
        this.popup.show(component, n, n2);
    }

    private final void showPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            if (!this.makeSelection(mouseEvent.getComponent(), mouseEvent.getPoint(), mouseEvent.isControlDown())) {
                return;
            }
            mouseEvent.getComponent().requestFocus();
            this.showPopup(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private final boolean makeSelection(Object object, Point point, boolean bl) {
        if (object instanceof JTable) {
            JTable jTable = (JTable)object;
            int n = jTable.rowAtPoint(point);
            if (n == -1) {
                return false;
            }
            int[] nArray = jTable.getSelectedRows();
            boolean bl2 = true;
            int n2 = 0;
            while (n2 < nArray.length) {
                if (nArray[n2] == n) {
                    bl2 = false;
                }
                ++n2;
            }
            if (bl2) {
                jTable.getSelectionModel().setSelectionInterval(n, n);
            }
        } else if (object instanceof JTree) {
            JTree jTree = (JTree)object;
            int n = jTree.getClosestRowForLocation(point.x, point.y);
            if (n == -1) {
                return false;
            }
            if (bl) {
                jTree.addSelectionRow(n);
            } else {
                jTree.setSelectionRow(n);
            }
        }
        return true;
    }

    public PopupListener(JMenu jMenu) {
        this(jMenu.getPopupMenu());
    }

    public PopupListener(JPopupMenu jPopupMenu) {
        this.popup = jPopupMenu;
        jPopupMenu.setBorderPainted(true);
    }
}

