/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import xnap.XNap;
import xnap.gui.DirectoryChooser;
import xnap.gui.XNapFrame;
import xnap.util.FileHelper;
import xnap.util.Updater;

public class DirectoryPanel
extends JPanel {
    private JTextField jtfFilename;

    protected void directorySelected(String string) {
    }

    public String getDirectory() {
        return FileHelper.directory(this.jtfFilename.getText());
    }

    public void setDirectory(String string) {
        this.jtfFilename.setText(string);
    }

    public JTextField getTextField() {
        return this.jtfFilename;
    }

    public DirectoryPanel(String string, int n) {
        this.setLayout(new BoxLayout(this, 0));
        this.jtfFilename = new JTextField(string, n);
        this.add(this.jtfFilename);
        this.add(Box.createHorizontalStrut(1));
        AbstractAction abstractAction = Updater.isMacOSX() ? new SwingDirectoryChooserAction() : new DirectoryChooserAction();
        JButton jButton = new JButton(abstractAction);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        this.add(jButton);
    }

    private class DirectoryChooserAction
    extends AbstractAction {
        private DirectoryChooser chooser = new DirectoryChooser();

        public void actionPerformed(ActionEvent actionEvent) {
            this.chooser.setSelectedDirectory(new File(DirectoryPanel.this.getDirectory()));
            if (this.chooser.showChooseDialog(DirectoryPanel.this) == 1) {
                DirectoryPanel.this.setDirectory(this.chooser.getSelectedDirectory().getAbsolutePath());
                DirectoryPanel.this.directorySelected(DirectoryPanel.this.getDirectory());
            }
        }

        public DirectoryChooserAction() {
            this.putValue("SmallIcon", XNapFrame.getSmallIcon("fileopen.png"));
            this.putValue("ShortDescription", XNap.tr("Choose a directory"));
        }
    }

    private class SwingDirectoryChooserAction
    extends AbstractAction {
        private JFileChooser chooser = new JFileChooser();

        public void actionPerformed(ActionEvent actionEvent) {
            this.chooser.setSelectedFile(new File(DirectoryPanel.this.getDirectory()));
            if (this.chooser.showOpenDialog(DirectoryPanel.this) == 0) {
                DirectoryPanel.this.setDirectory(this.chooser.getSelectedFile().getAbsolutePath());
                DirectoryPanel.this.directorySelected(DirectoryPanel.this.getDirectory());
            }
        }

        public SwingDirectoryChooserAction() {
            this.chooser.setApproveButtonText(XNap.tr("OK"));
            this.chooser.setDialogTitle(XNap.tr("Choose Directory"));
            this.chooser.setFileSelectionMode(1);
            this.putValue("SmallIcon", XNapFrame.getSmallIcon("fileopen.png"));
            this.putValue("ShortDescription", XNap.tr("Choose a directory"));
        }
    }
}

