/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import xnap.gui.DirectoryPanel;
import xnap.gui.XNapFrame;

public class DirectoryList
extends JPanel
implements ListSelectionListener {
    private DirectoryPanel dtfDir;
    private JList jlDirs;
    private DefaultListModel dlmDirs;

    public void addCurrentDirectory() {
        String string = this.dtfDir.getDirectory();
        if (string.length() > 0 && !this.dlmDirs.contains(string)) {
            this.dlmDirs.addElement(string);
            this.jlDirs.ensureIndexIsVisible(this.dlmDirs.getSize() - 1);
        }
        this.dtfDir.setDirectory("");
    }

    public String[] getDirs() {
        String[] stringArray = new String[this.dlmDirs.size()];
        System.arraycopy(this.dlmDirs.toArray(), 0, stringArray, 0, stringArray.length);
        return stringArray;
    }

    public void setDirs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            this.dlmDirs.addElement(stringArray[n]);
            ++n;
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.jlDirs.getSelectedValue() != null) {
            this.dtfDir.setDirectory(this.jlDirs.getSelectedValue().toString());
        }
    }

    public DirectoryList(String[] stringArray, int n, int n2) {
        this.setLayout(new BorderLayout());
        AddAction addAction = new AddAction();
        this.dtfDir = new MyDirectoryPanel("", n);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.dtfDir.getTextField().getInputMap().put(keyStroke, addAction);
        this.dlmDirs = new DefaultListModel();
        this.jlDirs = new JList(this.dlmDirs);
        this.jlDirs.addListSelectionListener(this);
        this.jlDirs.setVisibleRowCount(n2);
        JScrollPane jScrollPane = new JScrollPane(this.jlDirs);
        JButton jButton = new JButton(addAction);
        jButton.setMargin(new Insets(1, 1, 1, 1));
        JButton jButton2 = new JButton(new RemoveAction());
        jButton2.setMargin(new Insets(1, 1, 1, 1));
        Box box = Box.createHorizontalBox();
        box.add(this.dtfDir);
        box.add(jButton);
        box.add(jButton2);
        this.add((Component)box, "North");
        this.add((Component)jScrollPane, "Center");
        this.setDirs(stringArray);
    }

    private class AddAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            DirectoryList.this.addCurrentDirectory();
        }

        public AddAction() {
            this.putValue("SmallIcon", XNapFrame.getSmallIcon("edit_add.png"));
            this.putValue("ShortDescription", "Add directory");
            this.putValue("MnemonicKey", new Integer(65));
        }
    }

    private class RemoveAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray = DirectoryList.this.jlDirs.getSelectedValues();
            int n = 0;
            while (n < objectArray.length) {
                DirectoryList.this.dlmDirs.removeElement(objectArray[n]);
                ++n;
            }
        }

        public RemoveAction() {
            this.putValue("SmallIcon", XNapFrame.getSmallIcon("edit_remove.png"));
            this.putValue("ShortDescription", "Remove directory");
            this.putValue("MnemonicKey", new Integer(82));
        }
    }

    private class MyDirectoryPanel
    extends DirectoryPanel {
        public void directorySelected(String string) {
            DirectoryList.this.addCurrentDirectory();
        }

        public MyDirectoryPanel(String string, int n) {
            super(string, n);
        }
    }
}

