/*
 * Decompiled with CFR 0.152.
 */
package xnap.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import xnap.XNap;
import xnap.gui.AbstractPanel;
import xnap.gui.ChatServerCellRenderer;
import xnap.gui.ConsolePane;
import xnap.gui.XNapFrame;
import xnap.gui.event.DoubleClickListener;
import xnap.gui.event.PopupListener;
import xnap.gui.table.ChannelTableModel;
import xnap.net.IChannel;
import xnap.net.IChatServer;
import xnap.net.event.ChannelEvent;
import xnap.util.ChatManager;
import xnap.util.EventVector;
import xnap.util.event.ListEvent;
import xnap.util.event.ListListener;

public class ChatGlobalSubPanel
extends AbstractPanel
implements ListListener {
    public static final int UPDATE_INTERVAL = 1000;
    protected ConsolePane cpChat;
    protected ChannelTableModel ctm;
    protected DefaultComboBoxModel dcbm;
    protected JComboBox jcbServers;
    protected JTable jta;
    private JSplitPane jspH;
    private CreateChannelAction acCreateChannel = new CreateChannelAction();
    private JoinChannelAction acJoinChannel = new JoinChannelAction();
    private UpdateChannelsAction acUpdateChannels = new UpdateChannelsAction();
    protected Timer updateTimer;

    private final void initialize() {
        this.cpChat = new ConsolePane();
        JPanel jPanel = new JPanel(new BorderLayout());
        this.ctm = new ChannelTableModel();
        this.jta = this.ctm.createJTable();
        this.jta.setSelectionMode(0);
        this.jta.setShowGrid(false);
        this.jta.getInputMap().put(KeyStroke.getKeyStroke(10, 0), this.acJoinChannel);
        this.jta.getActionMap().put(this.acJoinChannel, this.acJoinChannel);
        this.jta.addMouseListener(new DoubleClickListener(this.acJoinChannel, this.jta));
        JScrollPane jScrollPane = new JScrollPane(this.jta);
        jPanel.add((Component)jScrollPane, "Center");
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(this.acJoinChannel);
        jPopupMenu.addSeparator();
        jPopupMenu.add(this.acCreateChannel);
        PopupListener popupListener = new PopupListener(jPopupMenu);
        this.jta.addMouseListener(popupListener);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jPanel2, "South");
        jPanel2.add((Component)new JLabel(XNap.tr("Server") + " "), "West");
        this.dcbm = new DefaultComboBoxModel();
        this.jcbServers = new JComboBox(this.dcbm);
        this.jcbServers.addActionListener(this.acUpdateChannels);
        this.jcbServers.setRenderer(new ChatServerCellRenderer());
        jPanel2.add((Component)this.jcbServers, "Center");
        this.jspH = new JSplitPane(1);
        this.jspH.add((Component)this.cpChat, "left");
        this.jspH.add((Component)jPanel, "right");
        this.jspH.setDividerLocation(AbstractPanel.prefs.getChatGlobalVerticalDividerLocation());
        this.jspH.setResizeWeight(1.0);
        this.jspH.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)this.jspH, "Center");
    }

    public int getDividerLocation() {
        return this.jspH.getDividerLocation();
    }

    public void elementAdded(ListEvent listEvent) {
        Object object = listEvent.getElement();
        SwingUtilities.invokeLater(new Runnable(this, object){
            private final /* synthetic */ ChatGlobalSubPanel this$0;
            private final /* synthetic */ Object val$obj;

            public final void run() {
                this.this$0.dcbm.addElement(this.val$obj);
                try {
                    ((IChatServer)this.val$obj).updateChannels();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            {
                this.val$obj = object;
                this.this$0 = chatGlobalSubPanel;
                this.constructor$0(chatGlobalSubPanel);
            }

            private final void constructor$0(ChatGlobalSubPanel chatGlobalSubPanel) {
            }
        });
    }

    public void elementRemoved(ListEvent listEvent) {
        Object object = listEvent.getElement();
        SwingUtilities.invokeLater(new Runnable(this, object){
            private final /* synthetic */ ChatGlobalSubPanel this$0;
            private final /* synthetic */ Object val$obj;

            public final void run() {
                this.this$0.dcbm.removeElement(this.val$obj);
            }
            {
                this.val$obj = object;
                this.this$0 = chatGlobalSubPanel;
                this.constructor$0(chatGlobalSubPanel);
            }

            private final void constructor$0(ChatGlobalSubPanel chatGlobalSubPanel) {
            }
        });
    }

    public JMenu getChannelTableMenu() {
        return this.ctm.createJMenu();
    }

    public IChannel getSelectedChannel() {
        int n = this.jta.getSelectedRow();
        if (n != -1) {
            return this.ctm.get(n);
        }
        return null;
    }

    public IChatServer getSelectedServer() {
        return (IChatServer)this.jcbServers.getSelectedItem();
    }

    public AbstractAction[] getActions() {
        return new AbstractAction[]{this.acJoinChannel, this.acCreateChannel, this.acUpdateChannels};
    }

    public void messageReceived(ChannelEvent channelEvent) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(channelEvent.getUser() != null ? channelEvent.getUser() + ": " : "");
        stringBuffer.append(channelEvent.getMessage());
        stringBuffer.append("\n");
        this.cpChat.appendLater(stringBuffer.toString());
    }

    public void savePrefs() {
        AbstractPanel.prefs.setChatGlobalVerticalDividerLocation(this.jspH.getDividerLocation());
    }

    public ChatGlobalSubPanel() {
        this.initialize();
        this.updateTimer = new Timer(1000, new Updater());
        this.updateTimer.start();
        EventVector eventVector = ChatManager.getInstance().getChatServers();
        eventVector.addListListener(this);
    }

    private class JoinChannelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            IChannel iChannel = ChatGlobalSubPanel.this.getSelectedChannel();
            if (iChannel != null) {
                try {
                    iChannel.join();
                }
                catch (IOException iOException) {
                    ChatGlobalSubPanel.this.setStatus(iOException.getMessage());
                }
            } else {
                ChatGlobalSubPanel.this.setStatus(XNap.tr("Please select a channel"));
            }
        }

        public JoinChannelAction() {
            this.putValue("Name", XNap.tr("Join"));
            this.putValue("ShortDescription", XNap.tr("Join Selected Channel"));
            this.putValue("SmallIcon", XNapFrame.getIcon("connect_creating.png"));
        }
    }

    private class CreateChannelAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            IChatServer iChatServer = ChatGlobalSubPanel.this.getSelectedServer();
            if (iChatServer != null && (string = JOptionPane.showInputDialog(ChatGlobalSubPanel.this, XNap.tr("Name"), XNap.tr("Create Channel"), 3)) != null && string.trim().length() > 0) {
                try {
                    iChatServer.create(string.trim());
                    iChatServer.updateChannels();
                    ChatGlobalSubPanel.this.ctm.set(iChatServer.getChannels());
                }
                catch (IOException iOException) {
                    ChatGlobalSubPanel.this.setStatus(iOException.getMessage());
                }
            }
        }

        public CreateChannelAction() {
            this.putValue("Name", XNap.tr("Create"));
            this.putValue("ShortDescription", XNap.tr("Create a new Channel"));
            this.putValue("SmallIcon", XNapFrame.getIcon("filenew.png"));
            this.putValue("MnemonicKey", new Integer(67));
        }
    }

    private class UpdateChannelsAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            IChatServer iChatServer = ChatGlobalSubPanel.this.getSelectedServer();
            if (iChatServer != null) {
                try {
                    if (actionEvent.getSource() == ChatGlobalSubPanel.this.jcbServers) {
                        iChatServer.updateChannels();
                    }
                    ChatGlobalSubPanel.this.ctm.set(iChatServer.getChannels());
                }
                catch (IOException iOException) {
                    ChatGlobalSubPanel.this.setStatus(iOException.getMessage());
                }
            }
        }

        public UpdateChannelsAction() {
            this.putValue("Name", XNap.tr("Update"));
            this.putValue("ShortDescription", XNap.tr("Update Channels"));
            this.putValue("SmallIcon", XNapFrame.getIcon("reload.png"));
            this.putValue("MnemonicKey", new Integer(82));
        }
    }

    private class Updater
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            IChatServer iChatServer;
            if (ChatGlobalSubPanel.this.hasFocus() && (iChatServer = ChatGlobalSubPanel.this.getSelectedServer()) != null && ChatGlobalSubPanel.this.jta.getSelectedRowCount() == 0) {
                try {
                    ChatGlobalSubPanel.this.ctm.set(iChatServer.getChannels());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        Updater() {
        }
    }
}

