/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.serializer;

import com.sun.xml.bind.serializer.Messages;
import com.sun.xml.bind.serializer.NamespaceContext;
import com.sun.xml.bind.serializer.PrefixCallback;
import org.xml.sax.SAXException;

public class NamespaceContextImpl
implements NamespaceContext {
    private int iota = 1;
    private String[] nsStack = new String[16];
    private int nsLen = 0;
    private int[] idxStack = new int[16];
    private int idxLen = 0;

    public NamespaceContextImpl() {
        this.addBinding(null, "");
        this.addBinding("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public String declareNamespace(String namespaceUri, boolean requirePrefix) {
        int i = this.nsLen - 2;
        while (i >= 0) {
            if (this.nsStack[i + 1].equals(namespaceUri) && (this.nsStack[i] != null || !requirePrefix)) {
                if ("".equals(this.nsStack[i])) {
                    throw new InternalError();
                }
                return this.nsStack[i];
            }
            i -= 2;
        }
        String prefix = this.assignPrefix(namespaceUri, requirePrefix);
        this.addBinding(prefix, namespaceUri);
        if ("".equals(prefix)) {
            throw new InternalError();
        }
        return prefix;
    }

    public String getPrefix(String namespaceUri) {
        int i = this.nsLen - 2;
        while (i >= 0) {
            if (this.nsStack[i + 1].equals(namespaceUri)) {
                return this.nsStack[i];
            }
            i -= 2;
        }
        throw new InternalError(Messages.format("NamespaceContextImpl.NSURINotDeclared", namespaceUri));
    }

    public String getNamespace(String prefix) {
        int i = this.nsLen - 2;
        while (i >= 0) {
            if (this.nsStack[i].equals(prefix)) {
                return this.nsStack[i + 1];
            }
            i -= 2;
        }
        return null;
    }

    public void startElement() {
        if (this.idxStack.length == this.idxLen) {
            int[] buf = new int[this.idxStack.length * 2];
            System.arraycopy(this.idxStack, 0, buf, 0, this.idxStack.length);
            this.idxStack = buf;
        }
        this.idxStack[this.idxLen++] = this.nsLen;
    }

    public void endElement() {
        this.nsLen = this.getStartIndex();
        --this.idxLen;
    }

    public void iterateDeclaredPrefixes(PrefixCallback callback) throws SAXException {
        int i = this.getStartIndex();
        while (i < this.nsLen) {
            String p = this.nsStack[i];
            if (p != null) {
                callback.onPrefixMapping(p, this.nsStack[i + 1]);
            }
            i += 2;
        }
    }

    private void addBinding(String prefix, String namespaceUri) {
        if (prefix != null && prefix.length() == 0) {
            throw new InternalError();
        }
        if (this.nsStack.length == this.nsLen) {
            String[] buf = new String[this.nsStack.length * 2];
            System.arraycopy(this.nsStack, 0, buf, 0, this.nsStack.length);
            this.nsStack = buf;
        }
        this.nsStack[this.nsLen++] = prefix;
        this.nsStack[this.nsLen++] = namespaceUri;
    }

    private String assignPrefix(String namespaceUri, boolean prefixRequired) {
        return "ns" + this.iota++;
    }

    private int getStartIndex() {
        return this.idxStack[this.idxLen - 1];
    }
}

