/*
 * Decompiled with CFR 0.152.
 */
package phex.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import phex.common.IntObj;
import phex.host.Host;
import phex.msg.GUID;

public class GUIDRoutingTable {
    private static final int MAX_ROUTE_TABLE_SIZE = 50000;
    private Map currentMap;
    private Map lastMap;
    private Map idToHostMap;
    private Map hostToIdMap;
    private long lifetime;
    private long nextReplaceTime;
    private int nextId;

    public GUIDRoutingTable(long l) {
        this.lifetime = l;
        this.nextId = 0;
        this.currentMap = new TreeMap(new GUID.GUIDComparator());
        this.lastMap = new TreeMap(new GUID.GUIDComparator());
        this.idToHostMap = new HashMap();
        this.hostToIdMap = new HashMap();
    }

    public synchronized void addRouting(GUID gUID, Host host) {
        this.checkForSwitch();
        if (!host.isConnected()) {
            return;
        }
        IntObj intObj = this.getIdForHost(host);
        this.lastMap.remove(gUID);
        this.currentMap.put(gUID, intObj);
    }

    public synchronized boolean checkAndAddRouting(GUID gUID, Host host) {
        this.checkForSwitch();
        if (!host.isConnected()) {
            return false;
        }
        if (!this.currentMap.containsKey(gUID) && !this.lastMap.containsKey(gUID)) {
            IntObj intObj = this.getIdForHost(host);
            this.currentMap.put(gUID, intObj);
            return true;
        }
        return false;
    }

    public synchronized void removeHost(Host host) {
        IntObj intObj = (IntObj)this.hostToIdMap.get(host);
        if (intObj != null) {
            this.idToHostMap.remove(intObj);
            this.hostToIdMap.remove(host);
        }
    }

    public synchronized Host findRouting(GUID gUID) {
        IntObj intObj = (IntObj)this.currentMap.get(gUID);
        if (intObj == null) {
            intObj = (IntObj)this.lastMap.get(gUID);
        }
        if (intObj != null) {
            return (Host)this.idToHostMap.get(intObj);
        }
        return null;
    }

    private void checkForSwitch() {
        long l = System.currentTimeMillis();
        if (l < this.nextReplaceTime && this.currentMap.size() < 50000) {
            return;
        }
        this.lastMap.clear();
        Map map = this.lastMap;
        this.lastMap = this.currentMap;
        this.currentMap = map;
        this.nextReplaceTime = l + this.lifetime;
    }

    private IntObj getIdForHost(Host host) {
        IntObj intObj = (IntObj)this.hostToIdMap.get(host);
        if (intObj != null) {
            return intObj;
        }
        intObj = new IntObj(this.nextId++);
        while (this.idToHostMap.get(intObj) != null) {
            intObj.setValue(this.nextId++);
        }
        this.idToHostMap.put(intObj, host);
        this.hostToIdMap.put(host, intObj);
        return intObj;
    }
}

