/*
 * Decompiled with CFR 0.152.
 */
package phex.upload;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URLEncoder;
import phex.common.ThreadPool;
import phex.connection.SocketProvider;
import phex.host.Host;
import phex.http.HTTPProcessor;
import phex.http.HTTPRequest;
import phex.msg.MsgPushRequest;
import phex.share.ShareFile;
import phex.share.ShareManager;
import phex.upload.UploadManager;
import phex.utils.GnutellaInputStream;
import phex.utils.IOUtil;
import phex.utils.Logger;

public class PushWorker
implements Runnable {
    private MsgPushRequest pushMsg;

    public PushWorker(MsgPushRequest msgPushRequest) {
        this.pushMsg = msgPushRequest;
        ThreadPool.getInstance().addJob(this, "PushWorker-" + Integer.toHexString(this.hashCode()));
    }

    public void run() {
        ShareManager shareManager = ShareManager.getInstance();
        Host host = null;
        try {
            Socket socket = SocketProvider.connect(this.pushMsg.getRequestAddress());
            host = new Host(this.pushMsg.getRequestAddress());
            host.setType(Host.TYPE_PUSH);
            host.setSocket(socket);
            ShareFile shareFile = shareManager.getFileAdministration().getFileByIndex((int)this.pushMsg.getFileIndex());
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append("GIV ");
            stringBuffer.append(this.pushMsg.getFileIndex());
            stringBuffer.append(':');
            stringBuffer.append(this.pushMsg.getClientGUID().toHexString());
            stringBuffer.append('/');
            if (shareFile != null) {
                stringBuffer.append(URLEncoder.encode(shareFile.getFileName()));
            }
            byte[] byArray = new byte[stringBuffer.length() + 2];
            int n = IOUtil.serializeString(stringBuffer.toString(), byArray, 0);
            byArray[n++] = 10;
            byArray[n++] = 10;
            OutputStream outputStream = host.getOutputStream();
            outputStream.write(byArray, 0, n);
            outputStream.flush();
            GnutellaInputStream gnutellaInputStream = host.getInputStream();
            if (gnutellaInputStream == null) {
                throw new IOException("Disconnected from remote host during initial handshake");
            }
            HTTPRequest hTTPRequest = HTTPProcessor.parseHTTPRequest(gnutellaInputStream);
            if (hTTPRequest.isGnutellaRequest()) {
                UploadManager.getInstance().handleUploadRequest(host.getSocket(), host.getInputStream(), hTTPRequest);
            } else {
                shareManager.httpRequestHandler(hTTPRequest, host);
            }
            Logger.logMessage(Logger.FINER, (short)4, "PushWorker finished");
        }
        catch (IOException iOException) {
            Logger.logMessage(Logger.FINER, (short)4, iOException);
        }
        catch (Exception exception) {
            Logger.logError(exception);
        }
    }
}

