/*
 * Decompiled with CFR 0.152.
 */
package phex.statistic;

import java.util.HashMap;
import phex.common.Manager;
import phex.common.ServiceManager;
import phex.statistic.StatisticProvider;
import phex.statistic.StatisticProviderConstants;
import phex.statistic.UptimeStatisticProvider;

public class StatisticsManager
implements Manager,
StatisticProviderConstants {
    private HashMap statisticProviderMap = new HashMap();
    private static StatisticsManager instance;

    private StatisticsManager() {
    }

    public void registerStatisticProvider(String string, StatisticProvider statisticProvider) {
        this.statisticProviderMap.put(string, statisticProvider);
    }

    public StatisticProvider getStatisticProvider(String string) {
        return (StatisticProvider)this.statisticProviderMap.get(string);
    }

    public static StatisticsManager getInstance() {
        if (instance == null) {
            instance = new StatisticsManager();
        }
        return instance;
    }

    public boolean initialize() {
        this.registerStatisticProvider("UptimeProvider", new UptimeStatisticProvider());
        return true;
    }

    public boolean onPostInitialization() {
        ServiceManager serviceManager = ServiceManager.getInstance();
        this.registerStatisticProvider("TotalBandwidthProvider", serviceManager.getPhexBandwidthController());
        this.registerStatisticProvider("NetworkBandwidthProvider", serviceManager.getNetworkBandwidthController());
        this.registerStatisticProvider("DownloadBandwidthProvider", serviceManager.getDownloadBandwidthController());
        this.registerStatisticProvider("UploadBandwidthProvider", serviceManager.getUploadBandwidthController());
        return true;
    }

    public void shutdown() {
        UptimeStatisticProvider uptimeStatisticProvider = (UptimeStatisticProvider)this.getStatisticProvider("UptimeProvider");
        uptimeStatisticProvider.saveUptimeStats();
    }
}

