/*
 * Decompiled with CFR 0.152.
 */
package phex.msg;

import phex.msg.InvalidMessageException;
import phex.msg.Message;
import phex.msg.MsgHeader;
import phex.msg.QRPatchTableMsg;
import phex.msg.QRResetTableMsg;

public abstract class RouteTableUpdateMsg
extends Message {
    public static final byte RESET_TABLE_VARIANT = 0;
    public static final byte PATCH_TABLE_VARIANT = 1;
    private byte variant;
    private MsgHeader header;

    public RouteTableUpdateMsg(byte by, int n) {
        this.header = new MsgHeader();
        this.header.setTTL((byte)1);
        this.header.setPayloadType((byte)48);
        this.header.setDataLen(n);
        this.variant = by;
    }

    public RouteTableUpdateMsg(byte by, MsgHeader msgHeader) {
        this.header = msgHeader;
        this.variant = by;
    }

    public int serialize(byte[] byArray, int n) {
        n = this.header.serialize(byArray, n);
        byArray[n++] = this.variant;
        return n;
    }

    public byte getVariant() {
        return this.variant;
    }

    public int getSize() {
        return this.header.getSize() + this.header.getDataLen();
    }

    public MsgHeader getHeader() {
        return this.header;
    }

    public static RouteTableUpdateMsg parseMessage(MsgHeader msgHeader, byte[] byArray) throws InvalidMessageException {
        byte by = byArray[0];
        switch (by) {
            case 0: {
                return new QRResetTableMsg(msgHeader, byArray);
            }
            case 1: {
                return new QRPatchTableMsg(msgHeader, byArray);
            }
        }
        throw new InvalidMessageException("Unknown RouteTableUpdateMsg variant");
    }
}

