/*
 * Decompiled with CFR 0.152.
 */
package phex.http;

import java.util.StringTokenizer;
import phex.utils.Logger;

public class XQueueParameters {
    private static final int DEFAULT_POLL_MIN = 60000;
    private static final int DEFAULT_POLL_MAX = 120000;
    private Integer position;
    private int length;
    private int limit;
    private int pollMin;
    private int pollMax;

    public XQueueParameters(int n, int n2, int n3, int n4, int n5) {
        this.position = new Integer(n);
        this.length = n2;
        this.limit = n3;
        this.pollMin = n4;
        this.pollMax = n5;
    }

    public Integer getPosition() {
        return this.position;
    }

    public int getRequestSleepTime() {
        int n = this.pollMax / 10;
        int n2 = n * (this.position - 1) + this.pollMin + 1000;
        return Math.min((this.pollMax + this.pollMin) / 2, n2);
    }

    public void update(XQueueParameters xQueueParameters) {
        if (xQueueParameters.position != -1) {
            this.position = xQueueParameters.position;
        }
        if (xQueueParameters.length != -1) {
            this.length = xQueueParameters.length;
        }
        if (xQueueParameters.limit != -1) {
            this.limit = xQueueParameters.limit;
        }
        if (xQueueParameters.pollMin != -1) {
            this.pollMin = xQueueParameters.pollMin;
        }
        if (xQueueParameters.pollMax != -1) {
            this.pollMax = xQueueParameters.pollMax;
        }
    }

    public String buildHTTPString() {
        return "position=" + this.position + ",length=" + this.length + ",limit=" + this.limit + ",pollMin=" + this.pollMin + ",pollMax=" + this.pollMax;
    }

    public static XQueueParameters parseHTTPRangeSet(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim().toLowerCase();
                if (string2.startsWith("position")) {
                    n = XQueueParameters.parseIntValue(string2);
                    continue;
                }
                if (string2.startsWith("length")) {
                    n2 = XQueueParameters.parseIntValue(string2);
                    continue;
                }
                if (string2.startsWith("limit")) {
                    n3 = XQueueParameters.parseIntValue(string2);
                    continue;
                }
                if (string2.startsWith("pollmin")) {
                    n4 = XQueueParameters.parseIntValue(string2);
                    continue;
                }
                if (!string2.startsWith("pollmax")) continue;
                n5 = XQueueParameters.parseIntValue(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            Logger.logMessage(Logger.FINE, (short)16, "Invalid X-Queue value: " + string);
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Logger.logMessage(Logger.FINE, (short)16, "Invalid X-Queue value: " + string);
            return null;
        }
        if (n4 == -1 && n5 == -1) {
            n4 = 60000;
            n5 = 120000;
        } else if (n4 == -1) {
            n4 = Math.min(60000, (n5 *= 1000) / 2);
        } else if (n5 == -1) {
            n4 *= 1000;
            n4 = Math.max(120000, n4);
        } else {
            n4 *= 1000;
            n5 *= 1000;
        }
        XQueueParameters xQueueParameters = new XQueueParameters(n, n2, n3, n4, n5);
        return xQueueParameters;
    }

    private static int parseIntValue(String string) {
        int n = string.indexOf(61);
        String string2 = string.substring(n + 1).trim();
        return Integer.parseInt(string2);
    }
}

