/*
 * Decompiled with CFR 0.152.
 */
package phex.host;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import phex.connection.NetworkManager;
import phex.host.MalformedHostAddressException;
import phex.utils.IPUtils;

public class HostAddress {
    public static final byte CLASS_A = 1;
    public static final byte CLASS_B = 2;
    public static final byte CLASS_C = 3;
    public static byte[] LOCAL_HOST_IP = new byte[]{127, 0, 0, 1};
    public static String LOCAL_HOST_NAME = "127.0.0.1";
    public static final int DEFAULT_PORT = 6346;
    private int hash = 0;
    private String hostName;
    private int port;
    private byte[] hostIP;

    public HostAddress(String string, int n) {
        this.hostName = string;
        this.port = n;
    }

    public HostAddress(byte[] byArray, int n) {
        this.hostIP = byArray;
        this.port = n;
    }

    public HostAddress(String string) throws MalformedHostAddressException {
        int n = string.indexOf(58);
        if (n < 0 || n == string.length() - 1) {
            this.hostName = string;
            this.port = 6346;
            return;
        }
        if (n == 0) {
            throw new MalformedHostAddressException("No host name: " + string);
        }
        this.hostName = string.substring(0, n);
        String string2 = string.substring(n + 1);
        try {
            this.port = Integer.parseInt(string2);
            if (!HostAddress.isPortInRange(this.port)) {
                throw new MalformedHostAddressException("Port out of range: " + string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedHostAddressException("Can't parse port: " + string2);
        }
    }

    public void updateAddress(String string, int n) {
        if (!string.equals(this.hostName)) {
            this.hostName = string;
            this.hostIP = null;
        }
        this.port = n;
        this.hash = 0;
    }

    public void updateAddress(byte[] byArray, int n) {
        this.hostIP = byArray;
        this.port = n;
        this.hash = 0;
    }

    public String getHostName() {
        if (this.hostName == null) {
            return IPUtils.ip2string(this.hostIP);
        }
        return this.hostName;
    }

    public String getFullHostName() {
        StringBuffer stringBuffer = new StringBuffer(21);
        stringBuffer.append(this.getHostName());
        stringBuffer.append(':');
        stringBuffer.append(this.port);
        return stringBuffer.toString();
    }

    public int getPort() {
        return this.port;
    }

    public byte[] getHostIP() throws UnknownHostException {
        this.initHostIP();
        return this.hostIP;
    }

    public boolean equals(HostAddress hostAddress) {
        if (this.hostIP != null && hostAddress.hostIP != null) {
            return Arrays.equals(this.hostIP, hostAddress.hostIP) && this.port == hostAddress.port;
        }
        return this.getHostName().equals(hostAddress.getHostName()) && this.port == hostAddress.port;
    }

    public boolean equals(Object object) {
        if (object instanceof HostAddress) {
            return this.equals((HostAddress)object);
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            int n = 0;
            n = 31 * n + this.port;
            if (this.hostIP != null) {
                int n2 = 0;
                while (n2 < 4) {
                    n = 31 * n + this.hostIP[n2];
                    ++n2;
                }
            } else {
                n = 127 * n + (this.hostIP != null ? this.hostName.hashCode() : 0);
            }
            this.hash = n;
        }
        return this.hash;
    }

    public boolean isLocalHost() {
        HostAddress hostAddress = NetworkManager.getInstance().getLocalAddress();
        boolean bl = this.port == hostAddress.getPort();
        try {
            this.initHostIP();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        if (this.hostIP[0] == 127) {
            return bl;
        }
        return hostAddress.equals(this);
    }

    public boolean isPrivateIP() {
        try {
            this.initHostIP();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        if (this.hostIP[0] == 10) {
            return true;
        }
        if (this.hostIP[0] == -84 && this.hostIP[1] >= 16 && this.hostIP[1] <= 31) {
            return true;
        }
        return this.hostIP[0] == -64 && this.hostIP[1] == -88;
    }

    public boolean isValidIP() {
        boolean bl;
        try {
            this.initHostIP();
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        byte by = this.getIPClass();
        switch (by) {
            case 1: {
                bl = (this.hostIP[1] & 0xFF) + (this.hostIP[2] & 0xFF) + (this.hostIP[3] & 0xFF) != 0;
                break;
            }
            case 2: {
                bl = (this.hostIP[2] & 0xFF) + (this.hostIP[3] & 0xFF) != 0;
                break;
            }
            case 3: {
                bl = (this.hostIP[3] & 0xFF) != 0;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public byte getIPClass() {
        try {
            this.initHostIP();
        }
        catch (UnknownHostException unknownHostException) {
            return -1;
        }
        if ((this.hostIP[0] & 0x80) == 0) {
            return 1;
        }
        if ((this.hostIP[0] & 0xC0) == 128) {
            return 2;
        }
        if ((this.hostIP[0] & 0xE0) == 192) {
            return 3;
        }
        return -1;
    }

    private void initHostIP() throws UnknownHostException {
        if (this.hostIP == null) {
            this.hostIP = InetAddress.getByName(this.hostName).getAddress();
            this.hash = 0;
        }
    }

    public String toString() {
        return this.getFullHostName();
    }

    public static int parsePort(String string) {
        int n = string.indexOf(58);
        if (n == -1) {
            return -1;
        }
        String string2 = string.substring(n + 1);
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            char c = cArray[n3];
            if (c < '0' || c > '9') break;
            n2 = n2 * 10 + c - 48;
            ++n3;
        }
        if (!HostAddress.isPortInRange(n2)) {
            return -1;
        }
        return n2;
    }

    public static boolean isPortInRange(int n) {
        return (n & 0xFFFF0000) == 0 && n != 0;
    }

    public static byte[] parseIP(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            string = string.substring(0, n);
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < cArray.length) {
            char c = cArray[n4];
            if (c < '0' || c > '9') {
                return null;
            }
            int n5 = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return null;
                }
                n5 = n5 * 10 + c - 48;
                if (++n4 >= cArray.length) break;
                c = cArray[n4];
            }
            if (n5 > 255) {
                return null;
            }
            n2 = (n2 << 8) + n5;
            ++n3;
            ++n4;
        }
        if (n3 != 4 || string.endsWith(".")) {
            return null;
        }
        byte[] byArray = new byte[]{(byte)(n2 >>> 24 & 0xFF), (byte)(n2 >>> 16 & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF)};
        return byArray;
    }
}

