/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.models;

import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import phex.event.SearchListChangeListener;
import phex.gui.common.GUIRegistry;
import phex.gui.common.LazyEventQueue;
import phex.query.QueryManager;
import phex.query.Search;
import phex.query.SearchContainer;

public class SearchComboBoxModel
extends AbstractListModel
implements ComboBoxModel {
    private Object selectedItem = null;
    private SearchContainer searchContainer = QueryManager.getInstance().getSearchContainer();

    public SearchComboBoxModel() {
        this.searchContainer.addSearchListChangeListener(new SearchContainerChangeListener());
    }

    public int getSize() {
        return this.searchContainer.getSearchCount();
    }

    public Object getElementAt(int n) {
        Search search = this.searchContainer.getSearchAt(n);
        if (search == null) {
            this.fireIntervalRemoved(this, n, n);
            return null;
        }
        return search;
    }

    public void setSelectedItem(Object object) {
        this.selectedItem = object;
        this.fireContentsChanged(this, -1, -1);
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }

    public class SearchContainerChangeListener
    implements SearchListChangeListener {
        private LazyEventQueue lazyEventQueue = GUIRegistry.getInstance().getLazyEventQueue();

        public void searchChanged(int n) {
            this.lazyEventQueue.addListDataEvent(new ListDataEvent(SearchComboBoxModel.this, 0, n, n));
        }

        public void searchAdded(int n) {
            SearchComboBoxModel.this.fireIntervalAdded(SearchComboBoxModel.this, n, n);
            SearchComboBoxModel.this.setSelectedItem(SearchComboBoxModel.this.getElementAt(n));
        }

        public void searchRemoved(int n) {
            SearchComboBoxModel.this.fireIntervalRemoved(SearchComboBoxModel.this, n, n);
            SearchComboBoxModel.this.setSelectedItem(SearchComboBoxModel.this.getElementAt(0));
        }
    }
}

