/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import phex.common.ServiceManager;
import phex.gui.common.GUIUtils;
import phex.gui.common.IntegerTextField;
import phex.gui.dialogs.options.OptionsSettingsPane;
import phex.utils.Localizer;

public class SharingPane
extends OptionsSettingsPane {
    private static final String SIMULTANEOUS_UPLOADS_KEY = "SimultaneousUploads";
    private static final String UPLOADS_PER_HOST_KEY = "UploadsPerHost";
    private static final String RETURNED_SEARCH_LIMIT_KEY = "ReturnedSearchLimit";
    private static final String QUEUE_LIMIT_KEY = "QueueLimit";
    private static final String MIN_POLL_TIME_KEY = "UploadQueueMinPollTime";
    private static final String MAX_POLL_TIME_KEY = "UploadQueueMaxPollTime";
    private static final String SEARCH_HIT_LIMIT_ERROR_KEY = "SearchHitLimitError";
    private IntegerTextField simultaneousUploadsTF;
    private IntegerTextField uploadsPerHostTF;
    private IntegerTextField returnedSearchLimitTF;
    private JCheckBox allowUploadQueuingChkbx;
    private JLabel queueLimitLabel;
    private IntegerTextField queueLimitTF;
    private JLabel minPollTimeLabel;
    private IntegerTextField minPollTimeTF;
    private JLabel maxPollTimeLabel;
    private IntegerTextField maxPollTimeTF;
    private JCheckBox removeCompletedUploadsChkbx;
    private JCheckBox sharePartialFilesChkbx;
    private JCheckBox allowBrowsingChkbx;

    public SharingPane() {
        super("Sharing");
    }

    protected void prepareComponent() {
        this.setLayout(new GridBagLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Localizer.getString("GeneralUploadSettings")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JLabel jLabel = new JLabel(Localizer.getString(SIMULTANEOUS_UPLOADS_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.simultaneousUploadsTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mMaxUpload), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.simultaneousUploadsTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString(UPLOADS_PER_HOST_KEY) + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.uploadsPerHostTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mMaxUploadPerIP), 2, 2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.uploadsPerHostTF, gridBagConstraints);
        jLabel = new JLabel(Localizer.getString("MaxReturnedSearchHits") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        jPanel2.add((Component)jLabel, gridBagConstraints);
        this.returnedSearchLimitTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.mUploadMaxSearch), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.returnedSearchLimitTF, gridBagConstraints);
        this.allowUploadQueuingChkbx = new JCheckBox(Localizer.getString("AllowUploadQueuing"), ServiceManager.sCfg.allowUploadQueuing);
        this.allowUploadQueuingChkbx.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SharingPane.this.refreshEnableState();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 4;
        jPanel2.add((Component)this.allowUploadQueuingChkbx, gridBagConstraints);
        this.queueLimitLabel = new JLabel(Localizer.getString("MaxQueueLength") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 15, 0, 5);
        jPanel2.add((Component)this.queueLimitLabel, gridBagConstraints);
        this.queueLimitTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxUploadQueueSize), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.queueLimitTF, gridBagConstraints);
        this.minPollTimeLabel = new JLabel(Localizer.getString("MinPollTime") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 15, 0, 5);
        jPanel2.add((Component)this.minPollTimeLabel, gridBagConstraints);
        this.minPollTimeTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.minUploadQueuePollTime), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 5);
        jPanel2.add((Component)this.minPollTimeTF, gridBagConstraints);
        this.maxPollTimeLabel = new JLabel(Localizer.getString("MaxPollTime") + ": ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 5);
        jPanel2.add((Component)this.maxPollTimeLabel, gridBagConstraints);
        this.maxPollTimeTF = new IntegerTextField(String.valueOf(ServiceManager.sCfg.maxUploadQueuePollTime), 3, 3);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        jPanel2.add((Component)this.maxPollTimeTF, gridBagConstraints);
        this.sharePartialFilesChkbx = new JCheckBox(Localizer.getString("SharePartialFiles"), ServiceManager.sCfg.arePartialFilesShared);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.sharePartialFilesChkbx, gridBagConstraints);
        this.removeCompletedUploadsChkbx = new JCheckBox(Localizer.getString("AutoRemoveCompletedUploads"), ServiceManager.sCfg.mUploadAutoRemoveCompleted);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.removeCompletedUploadsChkbx, gridBagConstraints);
        this.allowBrowsingChkbx = new JCheckBox(Localizer.getString("AllowBrowsingDirectories"), ServiceManager.sCfg.mShareBrowseDir);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.allowBrowsingChkbx, gridBagConstraints);
        this.refreshEnableState();
    }

    public void checkInput(HashMap hashMap) {
        Integer n;
        String string;
        try {
            string = this.simultaneousUploadsTF.getText();
            n = new Integer(string);
            hashMap.put(SIMULTANEOUS_UPLOADS_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.simultaneousUploadsTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.uploadsPerHostTF.getText();
            n = new Integer(string);
            hashMap.put(UPLOADS_PER_HOST_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.uploadsPerHostTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.returnedSearchLimitTF.getText();
            n = new Integer(string);
            if (n > 255) {
                hashMap.put(SEARCH_HIT_LIMIT_ERROR_KEY, n);
                this.setInputValid(hashMap, false);
                return;
            }
            hashMap.put(RETURNED_SEARCH_LIMIT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.returnedSearchLimitTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.queueLimitTF.getText();
            n = new Integer(string);
            hashMap.put(QUEUE_LIMIT_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.queueLimitTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.minPollTimeTF.getText();
            n = new Integer(string);
            hashMap.put(MIN_POLL_TIME_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.minPollTimeTF);
            this.setInputValid(hashMap, false);
            return;
        }
        try {
            string = this.maxPollTimeTF.getText();
            n = new Integer(string);
            hashMap.put(MAX_POLL_TIME_KEY, n);
        }
        catch (NumberFormatException numberFormatException) {
            hashMap.put("NumberFormatError", this.maxPollTimeTF);
            this.setInputValid(hashMap, false);
            return;
        }
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
        if (hashMap.containsKey("NumberFormatError")) {
            this.displayNumberFormatError(hashMap);
        } else if (hashMap.containsKey(SEARCH_HIT_LIMIT_ERROR_KEY)) {
            this.returnedSearchLimitTF.setText("255");
            this.returnedSearchLimitTF.requestFocus();
            this.returnedSearchLimitTF.selectAll();
            GUIUtils.showErrorMessage(Localizer.getString("ExceedSearchHitLimit"), Localizer.getString("Error"));
        }
    }

    public void saveAndApplyChanges(HashMap hashMap) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Integer n;
        int n2;
        Integer n3;
        int n4;
        Integer n5;
        int n6;
        boolean bl4;
        Integer n7;
        int n8;
        Integer n9;
        int n10;
        Integer n11 = (Integer)hashMap.get(SIMULTANEOUS_UPLOADS_KEY);
        int n12 = n11;
        if (ServiceManager.sCfg.mMaxUpload != n12) {
            ServiceManager.sCfg.mMaxUpload = n12;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mMaxUploadPerIP != (n10 = (n9 = (Integer)hashMap.get(UPLOADS_PER_HOST_KEY)).intValue())) {
            ServiceManager.sCfg.mMaxUploadPerIP = n10;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mUploadMaxSearch != (n8 = (n7 = (Integer)hashMap.get(RETURNED_SEARCH_LIMIT_KEY)).intValue())) {
            ServiceManager.sCfg.mUploadMaxSearch = n8;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.allowUploadQueuing != (bl4 = this.allowUploadQueuingChkbx.isSelected())) {
            ServiceManager.sCfg.allowUploadQueuing = bl4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.maxUploadQueueSize != (n6 = (n5 = (Integer)hashMap.get(QUEUE_LIMIT_KEY)).intValue())) {
            ServiceManager.sCfg.maxUploadQueueSize = n6;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.minUploadQueuePollTime != (n4 = (n3 = (Integer)hashMap.get(MIN_POLL_TIME_KEY)).intValue())) {
            ServiceManager.sCfg.minUploadQueuePollTime = n4;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.maxUploadQueuePollTime != (n2 = (n = (Integer)hashMap.get(MAX_POLL_TIME_KEY)).intValue())) {
            ServiceManager.sCfg.maxUploadQueuePollTime = n2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.arePartialFilesShared != (bl3 = this.sharePartialFilesChkbx.isSelected())) {
            ServiceManager.sCfg.arePartialFilesShared = bl3;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mUploadAutoRemoveCompleted != (bl2 = this.removeCompletedUploadsChkbx.isSelected())) {
            ServiceManager.sCfg.mUploadAutoRemoveCompleted = bl2;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
        if (ServiceManager.sCfg.mShareBrowseDir != (bl = this.allowBrowsingChkbx.isSelected())) {
            ServiceManager.sCfg.mShareBrowseDir = bl;
            OptionsSettingsPane.triggerConfigSave(hashMap);
        }
    }

    private void refreshEnableState() {
        boolean bl = this.allowUploadQueuingChkbx.isSelected();
        this.queueLimitLabel.setEnabled(bl);
        this.queueLimitTF.setEnabled(bl);
        this.minPollTimeLabel.setEnabled(bl);
        this.minPollTimeTF.setEnabled(bl);
        this.maxPollTimeLabel.setEnabled(bl);
        this.maxPollTimeTF.setEnabled(bl);
    }
}

