/*
 * Decompiled with CFR 0.152.
 */
package phex.gui.dialogs.options;

import java.awt.Component;
import java.util.HashMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import phex.utils.Localizer;

public abstract class OptionsSettingsPane
extends JPanel {
    protected static final String NUMBER_FORMAT_ERROR_KEY = "NumberFormatError";
    protected static final String IS_INPUT_VALID_KEY = "IsInputValid";
    protected static final String SAVE_CONFIG_TRIGGER = "SaveConfigTrigger";
    protected static final String RESCAN_FILES_TRIGGER = "RescanFilesTrigger";
    private String treeRepresentation;
    private boolean isPreparedForDisplay;

    public OptionsSettingsPane(String string) {
        this.treeRepresentation = string;
        this.isPreparedForDisplay = false;
    }

    public void prepareForDisplay() {
        if (!this.isPreparedForDisplay) {
            this.prepareComponent();
            this.isPreparedForDisplay = true;
        }
    }

    public boolean isSettingsPaneDisplayed() {
        return this.isPreparedForDisplay;
    }

    protected abstract void prepareComponent();

    public void checkInput(HashMap hashMap) {
        this.setInputValid(hashMap, true);
    }

    public void displayErrorMessage(HashMap hashMap) {
    }

    public void saveAndApplyChanges(HashMap hashMap) {
    }

    protected String getOptionTreeRepresentation() {
        return this.treeRepresentation;
    }

    protected void setInputValid(HashMap hashMap, boolean bl) {
        hashMap.put(IS_INPUT_VALID_KEY, new Boolean(bl));
    }

    public boolean isInputValid(HashMap hashMap) {
        Boolean bl = (Boolean)hashMap.get(IS_INPUT_VALID_KEY);
        return bl;
    }

    public static void triggerConfigSave(HashMap hashMap) {
        if (!hashMap.containsKey(SAVE_CONFIG_TRIGGER)) {
            hashMap.put(SAVE_CONFIG_TRIGGER, SAVE_CONFIG_TRIGGER);
        }
    }

    public static boolean isSaveConfigTriggered(HashMap hashMap) {
        return hashMap.containsKey(SAVE_CONFIG_TRIGGER);
    }

    public static void triggerSharedFilesRescan(HashMap hashMap) {
        if (!hashMap.containsKey(RESCAN_FILES_TRIGGER)) {
            hashMap.put(RESCAN_FILES_TRIGGER, RESCAN_FILES_TRIGGER);
        }
    }

    public static boolean isSharedFilesRescanTriggered(HashMap hashMap) {
        return hashMap.containsKey(RESCAN_FILES_TRIGGER);
    }

    protected void displayNumberFormatError(HashMap hashMap) {
        Component component = (Component)hashMap.get(NUMBER_FORMAT_ERROR_KEY);
        if (component == null) {
            return;
        }
        component.requestFocus();
        if (component instanceof JTextField) {
            ((JTextField)component).selectAll();
        }
        JOptionPane.showMessageDialog(this, Localizer.getString("WrongNumberFormat"), Localizer.getString("FormatError"), 0);
    }
}

